/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.util.ArrayList;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TablePosition;
import javafx.scene.input.MouseEvent;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.table.FxTableRowList;
import jp.co.extreme.fx.table.FxTableUtil;
import jp.co.extreme.fx.table.FxTableView;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.html.util.EtcHtmlUtil;

class XdtsSelectColumnPane
extends FxDecoratePane {
    FxButton addRowBbutton;
    FxButton deleteRowBbutton;
    BcTableColumnModel tableColumnModel;
    BcTableModel tableModel;
    FxTableRowList tableRowList;
    FxTableView tableView;
    Number nextRowId;

    public XdtsSelectColumnPane() throws Exception {
        this.addRowBbutton = new FxButton(BcWords.getInstance().addRow, (Node)FxImageHelper.createImageView_icon("add_64x64.png"));
        this.deleteRowBbutton = new FxButton(BcWords.getInstance().deleteRow, (Node)FxImageHelper.createImageView_icon("cancel_64x64.png"));
        this.addRowBbutton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.addRowBbutton);
        this.deleteRowBbutton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.deleteRowBbutton);
        this.tableColumnModel = this.createTableColumnModel();
        this.tableModel = new BcTableModel(this.tableColumnModel);
    }

    public void temp() throws Exception {
        this.tableRowList = new FxTableRowList(this.tableModel);
        this.tableView = new InnerTableView();
        FxTableUtil.createColumn(this.tableColumnModel, this.tableView, null);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.tableView.setItems(this.tableRowList);
        this.tableView.setEditable(true);
        FxTableUtil.setSortable(this.tableView, false);
        this.deleteRowBbutton.setDisable(true);
        this.setCenter((Node)this.tableView);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.addRowBbutton) {
            ArrayList<Integer> row = new ArrayList<Integer>();
            row.add(null);
            row.add(null);
            row.add(0);
            this.tableModel.addRow(row);
            this.tableRowList = new FxTableRowList(this.tableModel);
            this.tableView.setItems(this.tableRowList);
        } else if (ev.getSource() == this.deleteRowBbutton) {
            this.tableModel.removeRow(this.nextRowId.intValue());
            this.tableRowList = new FxTableRowList(this.tableModel);
            this.tableView.setItems(this.tableRowList);
        }
    }

    protected BcTableColumnModel createTableColumnModel() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = BcWords.getInstance().columnName;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 36;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = true;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = BcWords.getInstance().alias;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 16;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = true;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.fieldDisplay.displayName = EtcHtmlUtil.toHtml(BcWords.getInstance().displayOrder);
        mmdField.dataClass = Integer.class;
        mmdField.columnCount = 6;
        mmdField.nullable = BcConstants.Existence.FALSE.value;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = true;
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    class InnerTableView<S>
    extends FxTableView<S> {
        @Override
        public void rowSelectionChanged(FxTableView tableView, ObservableList<Integer> rowIdList, int prevRowId, int nextRowId) throws Exception {
            super.rowSelectionChanged(tableView, rowIdList, prevRowId, nextRowId);
            XdtsSelectColumnPane.this.deleteRowBbutton.setDisable(true);
        }

        @Override
        public void rowSelected(FxTableView tableView, ObservableList<TablePosition> tablePositionList, MouseEvent ev, boolean doubleClicked) throws Exception {
            super.rowSelected(tableView, tablePositionList, ev, doubleClicked);
            XdtsSelectColumnPane.this.nextRowId = -1;
            TablePosition tablePosition = BcCollectionUtil.getFirst(tablePositionList);
            if (tablePosition != null) {
                XdtsSelectColumnPane.this.nextRowId = tablePosition.getRow();
                XdtsSelectColumnPane.this.deleteRowBbutton.setDisable(false);
            }
        }
    }
}

