/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import java.util.Map;
import jp.co.extreme.base.charset.BcCharsetNames;
import jp.co.extreme.base.charset.BcSjisUtil;
import jp.co.extreme.base.charset.BcWindows3JUtil;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcCharacterCodingException;
import org.mozilla.universalchardet.UniversalDetector;

public class BcEncoder {
    private Charset encodeCharset;
    private CharsetEncoder encoder;
    private boolean isThrowException;
    public Map<Character, byte[]> charMap;

    public BcEncoder() throws Exception {
        this.init();
    }

    public void init() throws Exception {
        this.setEncodCharset(BcConstants.charset);
        this.isThrowException = true;
        this.charMap = new HashMap<Character, byte[]>();
    }

    public boolean isThrowException() {
        return this.isThrowException;
    }

    public void setThrowException(boolean isThrowException) {
        this.isThrowException = isThrowException;
    }

    public Charset getEncodCharset() {
        return this.encodeCharset;
    }

    public void setEncodCharset(Charset encodeCharset) {
        this.encodeCharset = encodeCharset;
        this.encoder = encodeCharset.newEncoder();
        if (BcStringUtil.equalsIgnoreCase(encodeCharset.name(), BcCharsetNames.SJIS.value) || BcStringUtil.equalsIgnoreCase(encodeCharset.name(), BcCharsetNames.Shift_JIS.value)) {
            BcSjisUtil.setCharMap(this.charMap);
        } else if (BcStringUtil.equalsIgnoreCase(encodeCharset.name(), BcCharsetNames.Windows_31J.value)) {
            BcWindows3JUtil.setCharMap(this.charMap);
        }
    }

    public ByteBuffer toByteBuffer(CharSequence charSeq) throws Exception {
        CharBuffer charBuf1 = CharBuffer.wrap(charSeq);
        ByteBuffer byteBuf = null;
        ByteArrayOutputStream byteOut = null;
        int offset = 65216;
        byteOut = new ByteArrayOutputStream();
        try {
            int i = 0;
            while (i < charBuf1.length()) {
                char char1 = charBuf1.charAt(i);
                byte[] bytes = this.charMap.get(Character.valueOf(char1));
                if (bytes != null) {
                    BcLogUtil.debug("char1=" + char1);
                    BcLogUtil.debug("bytes=" + bytes);
                    byteOut.write(bytes);
                } else if (BcEncoder.isControl(char1) || BcEncoder.isAscii(char1)) {
                    byteOut.write(char1);
                } else if (BcEncoder.isHankana(char1)) {
                    byteOut.write(char1 - offset);
                } else {
                    try {
                        char[] chars2 = new char[]{char1};
                        bytes = this.encoder.encode(CharBuffer.wrap(chars2)).array();
                        byteOut.write(bytes);
                    }
                    catch (CharacterCodingException ex2) {
                        if (this.isThrowException) {
                            BcCharacterCodingException ex3 = new BcCharacterCodingException();
                            ex3.errorText = Character.valueOf(char1);
                            throw ex3;
                        }
                        byteOut.write(new byte[]{63});
                    }
                }
                ++i;
            }
        }
        finally {
            if (byteOut != null) {
                byteOut.close();
            }
        }
        byteBuf = ByteBuffer.wrap(byteOut.toByteArray());
        return byteBuf;
    }

    public static final boolean isControl(char char1) {
        return char1 >= '\u0000' && char1 <= '\u001f' || char1 == '\u007f';
    }

    public static final boolean isAscii(char char1) {
        return char1 >= ' ' && char1 <= '~';
    }

    public static final boolean isHankana(char char1) {
        return char1 >= '\uff61' && char1 <= '\uff9f';
    }

    public static String detectEncoding(InputStream is) throws IOException {
        int nread;
        String charset = null;
        byte[] buf = new byte[4096];
        UniversalDetector universalDetector = new UniversalDetector(null);
        while ((nread = is.read(buf)) > 0 && !universalDetector.isDone()) {
            universalDetector.handleData(buf, 0, nread);
        }
        universalDetector.dataEnd();
        charset = universalDetector.getDetectedCharset();
        universalDetector.reset();
        return charset;
    }

    public static String urlDecode(String src, String enc) throws Exception {
        if (BcStringUtil.isEmpty(src)) {
            return src;
        }
        return URLDecoder.decode(src, enc);
    }

    public static String detectEncoding(File file) throws Exception {
        try (FileInputStream fis = new FileInputStream(file);){
            String string = BcEncoder.detectEncoding(fis);
            return string;
        }
    }

    public static String urlEncode(String src, String enc) throws Exception {
        if (BcStringUtil.isEmpty(src)) {
            return src;
        }
        return URLEncoder.encode(src, enc);
    }
}

