/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.swing.lookAndFeel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.swing.lookAndFeel.SwgLafEventHandler;
import jp.co.extreme.swing.lookAndFeel.SwgLafNimrodUtil;
import jp.co.extreme.swing.lookAndFeel.SwgLafUtil;
import jp.co.extreme.swing.lookAndFeel.general.theme.SwgAquaMetalTheme;
import jp.co.extreme.swing.lookAndFeel.general.theme.SwgBigContrastMetalTheme;
import jp.co.extreme.swing.lookAndFeel.general.theme.SwgCharcoalTheme;
import jp.co.extreme.swing.lookAndFeel.general.theme.SwgContrastMetalTheme;
import jp.co.extreme.swing.lookAndFeel.general.theme.SwgDemoMetalTheme;
import jp.co.extreme.swing.lookAndFeel.general.theme.SwgEmeraldMetalTheme;
import jp.co.extreme.swing.lookAndFeel.general.theme.SwgGreenMetalTheme;
import jp.co.extreme.swing.lookAndFeel.general.theme.SwgKhakiMetalTheme;
import jp.co.extreme.swing.lookAndFeel.general.theme.SwgRubyTheme;

public class SwgLafManager {
    protected List<SwgLafEventHandler> lafEventHandlerList = new ArrayList<SwgLafEventHandler>();
    public static final int FONT_SIZE_DEFAULT = 12;
    protected int fontSize = 12;
    public Font font;
    protected static String themeName;
    public Color textField_EditablBg = Color.WHITE;
    public Color textField_NotEditablBg = new Color(220, 220, 220);
    public Color consoleBgColor = new Color(27, 49, 75);
    public Color consoleFgColor = new Color(85, 170, 170);

    private SwgLafManager() {
        this.font = new Font("Monospaced", 0, this.fontSize);
    }

    public static SwgLafManager getInstance() {
        return SingletonHolder.instance;
    }

    public void setFontSize(int fontSize) throws Exception {
        this.fontSize = fontSize;
        this.font = new Font("Monospaced", 0, fontSize);
        SwgLafUtil.setFont(this.font);
        this.lafChanged();
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public String getThemeName() {
        return themeName;
    }

    public void setTheme(Component compo, String themeName) throws Exception {
        BcLogUtil.debug("setLookAndFeelMode:themeName=" + themeName);
        if (themeName.equals("Motif")) {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        } else if (themeName.equals("GTK")) {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
        } else if (themeName.equals("Nimbus")) {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
            UIManager.getLookAndFeelDefaults().put("TextField.contentMargins", new Insets(2, 6, 2, 6));
            UIManager.getLookAndFeelDefaults().put("Table.cellNoFocusBorder", new Insets(0, 0, 0, 0));
            UIManager.getLookAndFeelDefaults().put("Table.focusCellHighlightBorder", new Insets(0, 0, 0, 0));
        } else if (themeName.equals("Macintosh")) {
            UIManager.setLookAndFeel("apple.laf.AquaLookAndFeel");
        } else if (themeName.equals("Windows")) {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        } else if (themeName.equals("Metal")) {
            MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        } else if (themeName.equals("Metal(Aqua)")) {
            MetalLookAndFeel.setCurrentTheme(new SwgAquaMetalTheme());
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        } else if (themeName.equals("Metal(Emerald)")) {
            MetalLookAndFeel.setCurrentTheme(new SwgEmeraldMetalTheme());
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        } else if (themeName.equals("Metal(Ruby)")) {
            MetalLookAndFeel.setCurrentTheme(new SwgRubyTheme());
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        } else if (themeName.equals("Metal(Green)")) {
            MetalLookAndFeel.setCurrentTheme(new SwgGreenMetalTheme());
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        } else if (themeName.equals("Metal(Khaki)")) {
            MetalLookAndFeel.setCurrentTheme(new SwgKhakiMetalTheme());
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        } else if (themeName.equals("Metal(Charcoal)")) {
            MetalLookAndFeel.setCurrentTheme(new SwgCharcoalTheme());
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        } else if (themeName.equals("Metal(Contrast)")) {
            MetalLookAndFeel.setCurrentTheme(new SwgContrastMetalTheme());
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        } else if (themeName.equals("Metal(Font18)")) {
            MetalLookAndFeel.setCurrentTheme(new SwgDemoMetalTheme());
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        } else if (themeName.equals("Metal(BigContrast)")) {
            MetalLookAndFeel.setCurrentTheme(new SwgBigContrastMetalTheme());
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        } else if (themeName.startsWith("")) {
            SwgLafNimrodUtil.setTheme(themeName);
        } else {
            String msg = "Not supported theme. '" + themeName + "'";
            throw new Exception(msg);
        }
        UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
        Object value = uiDefaults.get("TextField[Enabled].borderPainter");
        Enumeration keys = uiDefaults.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (!key.toString().endsWith(".font")) continue;
            uiDefaults.put(key, this.font);
        }
        SwingUtilities.updateComponentTreeUI(compo);
        SwgLafManager.themeName = themeName;
        this.lafChanged();
    }

    public boolean addLafEventHandler(SwgLafEventHandler eventHandler) {
        return this.lafEventHandlerList.add(eventHandler);
    }

    public boolean removeLafEventHandler(SwgLafEventHandler eventHandler) {
        return this.lafEventHandlerList.remove(eventHandler);
    }

    public void lafChanged() throws Exception {
        SwgLafEventHandler[] lafEventHandlers = this.lafEventHandlerList.toArray(new SwgLafEventHandler[0]);
        int i = 0;
        while (i < lafEventHandlers.length) {
            BcLogUtil.debug("lafChanged\uff1alafEventHandlers=" + lafEventHandlers);
            try {
                lafEventHandlers[i].lafChanged(this.fontSize, themeName);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            ++i;
        }
    }

    /* synthetic */ SwgLafManager(SwgLafManager swgLafManager) {
        this();
    }

    private static final class SingletonHolder {
        private static final SwgLafManager instance = new SwgLafManager(null);

        private SingletonHolder() {
        }
    }
}

