/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.sql.context;

import java.util.HashMap;
import java.util.Map;
import jp.co.extreme.base.core.BcUnicode;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.sql.SqlConstants;
import jp.co.extreme.sql.SqlDefinitionCondition;
import jp.co.extreme.sql.context.SqlContext;

public class SqlContext_DB2
extends SqlContext {
    public static final String DRIVER_CLASS_NAME = "com.ibm.db2.jcc.DB2Driver";
    public static final String[] DRIVER_CLASS_NAMES = new String[]{"com.ibm.db2.jcc.DB2Driver"};
    public static final int PORT_DEFAULT = 50000;
    private Map<Character, String> escapeCharacterMap;

    public SqlContext_DB2(SqlConstants.DatabaseProduct databaseProduct) {
        super(databaseProduct);
    }

    @Override
    public boolean isSupported(SqlContext.Function function) {
        switch (function) {
            case resultSetScroll: {
                return false;
            }
        }
        return true;
    }

    @Override
    public String[] getDriverClassNames() {
        return DRIVER_CLASS_NAMES;
    }

    @Override
    public int getDefaultPort() {
        return 50000;
    }

    @Override
    public Map<Character, String> getEscapeCharacterMap() {
        if (this.escapeCharacterMap == null) {
            this.escapeCharacterMap = new HashMap<Character, String>();
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.BS.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.BS.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.HT.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.HT.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.LF.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.LF.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.FF.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.FF.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.CR.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.CR.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.apostrophe.char_), String.valueOf(String.valueOf(BcUnicode.apostrophe.char_)) + String.valueOf(BcUnicode.apostrophe.char_));
        }
        return this.escapeCharacterMap;
    }

    @Override
    public String type_NUMBER(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -6: {
                definition = "SMALLINT";
                break;
            }
            case 2: 
            case 3: {
                if (mmdField.dataSize < 1 || mmdField.dataSize > 31 || mmdField.decimalDigit > 30) break;
                definition = "DECIMAL(" + mmdField.dataSize + ", " + mmdField.decimalDigit + ")";
                break;
            }
            default: {
                definition = super.type_NUMBER(mmdField, definitionCondition);
            }
        }
        return definition;
    }

    @Override
    public String type_BINARY(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                definition = "BLOB";
            }
        }
        return definition;
    }

    @Override
    public String setLimit(String srcSql, long limit, long offset) throws Exception {
        StringBuilder sb = new StringBuilder(srcSql.length() + 20);
        sb.append(srcSql);
        if (limit > 0L) {
            sb.append(" LIMIT " + limit);
        }
        if (offset > 0L) {
            sb.append(" OFFSET " + offset);
        }
        return sb.toString();
    }

    @Override
    public String func_substring(String columnName, int startIndex, int length) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("SUBSTR(");
        sb.append(columnName);
        if (length > 0) {
            sb.append("," + length);
        }
        if (length > 0) {
            sb.append("," + length);
        }
        return sb.toString();
    }

    @Override
    public String func_substring(String columnName, int startIndex) throws Exception {
        return this.func_substring(columnName, startIndex, -1);
    }
}

