/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.util;

import java.util.List;
import javafx.geometry.Dimension2D;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.swing.lookAndFeel.SwgLafManager;

public class FxFontUtil {
    public static final String Monospaced = "Monospaced";
    public static final String monospaceFontName = "Monospaced";
    public static final String Meiryo = "Meiryo";
    public static final String Times_New_Roman = "Times New Roman";
    public static final String MS_Gothic = "MS Gothic";
    public static final String MS_UI_Gothic = "MS UI Gothic";
    public static final String MS_PGothic = "MS PGothic";
    public static final String MS_Mincho = "MS Mincho";
    public static final String MS_PMincho = "MS PMincho";
    public static final String Meiryo_UI = "Meiryo UI";
    public static String defaultFontName = "Monospaced";
    public static FontWeight defaultFontWeight = FontWeight.NORMAL;
    private static Font defaultFont;
    public static char sampleHankaku;
    public static String sampleHalfWidthStr;
    public static char sampleFullWidth;
    public static String sampleFullWidthStr;
    public static double widthRatio;
    public static double fullWidthRatio;
    public static Font font_9r;
    public static Font font_9b;
    public static Font font_9_black;
    public static Font font_10r;
    public static Font font_10b;
    public static Font font_10_black;
    public static Font font_11r;
    public static Font font_11b;
    public static Font font_11_black;
    public static Font font_12r;
    public static Font font_12b;
    public static Font font_12_black;
    public static Font font_13b;
    public static Font font_13_black;
    public static Font font_14b;
    public static Font font_14_black;
    public static Font font_15b;
    public static Font font_16b;
    public static Font font_16_black;
    public static Font font_18b;
    public static Font font_18_black;
    public static Font font_20b;
    public static Font font_20_black;
    public static Font font_24b;
    public static Font font_32b;
    public static Font font_50_BL;

    static {
        sampleHankaku = (char)87;
        sampleHalfWidthStr = Character.toString(sampleHankaku);
        sampleFullWidth = (char)65335;
        sampleFullWidthStr = Character.toString(sampleFullWidth);
        int textLength = 1;
        Text halfWidthText = new Text(BcStringUtil.fill(sampleHalfWidthStr, textLength));
        halfWidthText.setFont(FxFontUtil.getDefaultFont());
        double halfWidth = halfWidthText.getBoundsInLocal().getWidth();
        widthRatio = halfWidth / (double)(12 * textLength);
        Text fullWidthText = new Text(BcStringUtil.fill(sampleFullWidthStr, textLength));
        fullWidthText.setFont(FxFontUtil.getDefaultFont());
        double fullWidth = fullWidthText.getBoundsInLocal().getWidth();
        fullWidthRatio = (fullWidth *= 1.02) / halfWidth;
        font_9r = Font.font((String)defaultFontName, (FontWeight)FontWeight.NORMAL, (FontPosture)FontPosture.REGULAR, (double)9.0);
        font_9b = Font.font((String)defaultFontName, (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)9.0);
        font_9_black = Font.font((String)defaultFontName, (FontWeight)FontWeight.BLACK, (FontPosture)FontPosture.REGULAR, (double)9.0);
        font_10r = Font.font((String)defaultFontName, (FontWeight)FontWeight.NORMAL, (FontPosture)FontPosture.REGULAR, (double)10.0);
        font_10b = Font.font((String)defaultFontName, (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)10.0);
        font_10_black = Font.font((String)defaultFontName, (FontWeight)FontWeight.BLACK, (FontPosture)FontPosture.REGULAR, (double)10.0);
        font_11r = Font.font((String)defaultFontName, (FontWeight)FontWeight.NORMAL, (FontPosture)FontPosture.REGULAR, (double)11.0);
        font_11b = Font.font((String)defaultFontName, (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)11.0);
        font_11_black = Font.font((String)defaultFontName, (FontWeight)FontWeight.BLACK, (FontPosture)FontPosture.REGULAR, (double)11.0);
        font_12r = Font.font((String)defaultFontName, (FontWeight)FontWeight.NORMAL, (FontPosture)FontPosture.REGULAR, (double)12.0);
        font_12b = Font.font((String)defaultFontName, (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)12.0);
        font_12_black = Font.font((String)defaultFontName, (FontWeight)FontWeight.BLACK, (FontPosture)FontPosture.REGULAR, (double)12.0);
        font_13b = Font.font((String)defaultFontName, (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)13.0);
        font_13_black = Font.font((String)defaultFontName, (FontWeight)FontWeight.BLACK, (FontPosture)FontPosture.REGULAR, (double)13.0);
        font_14b = Font.font((String)defaultFontName, (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)14.0);
        font_14_black = Font.font((String)defaultFontName, (FontWeight)FontWeight.BLACK, (FontPosture)FontPosture.REGULAR, (double)14.0);
        font_15b = Font.font((String)defaultFontName, (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)15.0);
        font_16b = Font.font((String)defaultFontName, (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)16.0);
        font_16_black = Font.font((String)defaultFontName, (FontWeight)FontWeight.BLACK, (FontPosture)FontPosture.REGULAR, (double)16.0);
        font_18b = Font.font((String)defaultFontName, (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)18.0);
        font_18_black = Font.font((String)defaultFontName, (FontWeight)FontWeight.BLACK, (FontPosture)FontPosture.REGULAR, (double)18.0);
        font_20b = Font.font((String)defaultFontName, (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)20.0);
        font_20_black = Font.font((String)defaultFontName, (FontWeight)FontWeight.BLACK, (FontPosture)FontPosture.REGULAR, (double)20.0);
        font_24b = Font.font((String)defaultFontName, (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)24.0);
        font_32b = Font.font((String)defaultFontName, (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)32.0);
        font_50_BL = Font.font((String)defaultFontName, (FontWeight)FontWeight.BLACK, (FontPosture)FontPosture.REGULAR, (double)50.0);
    }

    private FxFontUtil() {
    }

    public static Dimension2D getTextSize(Font font, String str) {
        if (BcStringUtil.isEmpty(str)) {
            str = sampleHalfWidthStr;
        }
        double charWidth = font.getSize() * widthRatio;
        double charHeght = font.getSize() * 1.0;
        double width = 0.0;
        int i = 0;
        while (i < str.length()) {
            width = BcStringUtil.isHanLatinCharacter(str.charAt(i)) ? (width += charWidth) : (width += charWidth * fullWidthRatio);
            ++i;
        }
        Dimension2D dmension2D = new Dimension2D(width, charHeght);
        return dmension2D;
    }

    public static Dimension2D getTextSize(Font font, int textLength, boolean isFullWidth) {
        String text = null;
        text = isFullWidth ? BcStringUtil.fill(sampleFullWidthStr, textLength) : BcStringUtil.fill(sampleHalfWidthStr, textLength);
        return FxFontUtil.getTextSize(font, text);
    }

    public static Dimension2D getTextSize(Font font, int textLength) {
        return FxFontUtil.getTextSize(font, textLength, false);
    }

    public static Font getDefaultFont() {
        if (defaultFont == null) {
            int swgLafFontSize = SwgLafManager.getInstance().getFontSize();
            double fontSize = swgLafFontSize;
            defaultFont = Font.font((String)defaultFontName, (FontWeight)defaultFontWeight, (FontPosture)FontPosture.REGULAR, (double)fontSize);
        }
        return defaultFont;
    }

    public static void dispFontList() throws Exception {
        List fontNames = Font.getFontNames();
        int i = 0;
        while (i < fontNames.size()) {
            String fontname = (String)fontNames.get(i);
            System.out.println(fontname);
            ++i;
        }
        List fontFamilies = Font.getFamilies();
        int i2 = 0;
        while (i2 < fontFamilies.size()) {
            String fontFamily = (String)fontFamilies.get(i2);
            System.out.println(fontFamily);
            ++i2;
        }
    }
}

