/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.table;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.co.extreme.base.charset.BcCharsetNames;
import jp.co.extreme.base.charset.BcUtf8Util;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.table.BcTableUtil;
import jp.co.extreme.base.util.BcCharsetDetector;
import jp.co.extreme.base.util.BcCsvUtil;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public final class BcCsvToTable
extends BcLoggableObject {
    private Object fillValue;

    public static BcCsvToTable getInstance() {
        return SingletonHolder.instance;
    }

    public void csvToTable(CSVFormat csvFormat, Reader reader, BcTableModel tableModel, int headerRowNumber) throws Exception {
        BcTableColumnModel tableColumnModel = tableModel.getTableColumnModel();
        CSVParser csvRecords = csvFormat.parse(reader);
        int columnCountMax = 0;
        for (CSVRecord csvRecord : csvRecords) {
            ArrayList<String> row = new ArrayList<String>();
            int i = 0;
            while (i < csvRecord.size()) {
                String value = csvRecord.get(i);
                row.add(value);
                ++i;
            }
            columnCountMax = Math.max(columnCountMax, row.size());
            if (csvRecord.getRecordNumber() < (long)headerRowNumber) continue;
            if (csvRecord.getRecordNumber() == (long)headerRowNumber) {
                this.addColumnName(tableColumnModel, row);
                continue;
            }
            tableModel.addRow(row);
        }
        int columnGap = columnCountMax - tableColumnModel.getColumnCount();
        this.getLogger().debug("columnGap=" + columnGap);
        if (columnGap > 0) {
            int i = 0;
            while (i < columnGap) {
                MmdField mmdField = this.createMmdField(Integer.toString(tableColumnModel.getColumnCount() + 1));
                BcTableColumn tableColumn = new BcTableColumn(tableColumnModel.getColumnCount());
                tableColumn.setMmdField(mmdField);
                tableColumnModel.addColumn(tableColumn);
                ++i;
            }
        }
        BcTableUtil.adjustToColmnCount(tableModel, this.getFillValue());
    }

    public BcTableModel csvToTable(CSVFormat csvFormat, Reader reader, int headerRowNumber) throws Exception {
        BcTableModel tableModel = new BcTableModel();
        this.csvToTable(csvFormat, reader, tableModel, headerRowNumber);
        return tableModel;
    }

    public BcTableModel csvToTable(Reader reader, int headerRowNumber) throws Exception {
        CSVFormat csvFormat = BcCsvUtil.createCsvFormat();
        return this.csvToTable(csvFormat, reader, headerRowNumber);
    }

    public BcTableModel csvToTable(InputStream is, String charsetName, boolean isTsv, int headerRowNumber) throws Exception {
        if (BcCharsetNames.SJIS.value.equals(charsetName)) {
            charsetName = BcCharsetNames.MS932.value;
            this.getLogger().warning("charset:" + (Object)((Object)BcCharsetNames.SJIS) + " -> " + charsetName);
        }
        if (BcCharsetNames.UTF_8.value.equals(charsetName)) {
            is = BcUtf8Util.skipBom(is);
        }
        InputStreamReader inputStreamReader = new InputStreamReader(is, charsetName);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        CSVFormat csvFormat = BcCsvUtil.createCsvFormat(isTsv);
        return this.csvToTable(csvFormat, bufferedReader, headerRowNumber);
    }

    public BcTableModel csvToTable(File file, int headerRowNumber) throws Exception {
        String charsetName = BcCharsetDetector.getInstance().detectCharset(file);
        boolean isTsv = BcTableUtil.Extention.tsv.name().equalsIgnoreCase(BcFileUtil.getExtention(file));
        FileInputStream is = new FileInputStream(file);
        return this.csvToTable(is, charsetName, isTsv, headerRowNumber);
    }

    public BcTableModel csvToTable(CSVFormat csvFormat, String csv, int headerRowNumber) throws Exception {
        CharArrayReader charArrayReader = new CharArrayReader(csv.toCharArray());
        BufferedReader bufferedReader = new BufferedReader(charArrayReader);
        return this.csvToTable(csvFormat, bufferedReader, headerRowNumber);
    }

    public BcTableModel csvToTable(String csv, int headerRowNumber) throws Exception {
        CSVFormat csvFormat = BcCsvUtil.createCsvFormat();
        return this.csvToTable(csvFormat, csv, headerRowNumber);
    }

    public MmdField createMmdField(String columnName) throws Exception {
        MmdField mmdField = new MmdField();
        mmdField.dataClass = String.class;
        mmdField.tableColumnName = mmdField.columnName = BcStringUtil.toString(columnName);
        return mmdField;
    }

    public BcTableColumn createTableColumn(String columnName) throws Exception {
        MmdField mmdField = this.createMmdField(columnName);
        BcTableColumn tableColumn = new BcTableColumn();
        tableColumn.setMmdField(mmdField);
        return tableColumn;
    }

    public BcTableColumn addColumnName(BcTableColumnModel tableColumnModel, String columnName) throws Exception {
        BcTableColumn tableColumn = this.createTableColumn(columnName);
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        return tableColumn;
    }

    public void addColumnName(BcTableColumnModel tableColumnModel, List<? extends String> columnNameList) throws Exception {
        int i = 0;
        while (i < columnNameList.size()) {
            String columnName = columnNameList.get(i);
            this.getLogger().debug("addColumnName:columnName=" + columnName);
            this.addColumnName(tableColumnModel, columnName);
            ++i;
        }
    }

    public void addColumnName(BcTableColumnModel tableColumnModel, String ... columnNames) throws Exception {
        List<String> columnNameList = Arrays.asList(columnNames);
        this.addColumnName(tableColumnModel, columnNameList);
    }

    public Object getFillValue() {
        return this.fillValue;
    }

    public void setFillValue(Object fillValue) {
        this.fillValue = fillValue;
    }

    private static final class SingletonHolder {
        private static final BcCsvToTable instance = new BcCsvToTable();

        private SingletonHolder() {
        }
    }
}

