/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.server;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.core.BcLangUtil;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdRenderingConverter;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.base.reflect.BcReflectUtil;
import jp.co.extreme.base.table.BcCsvToTable;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.table.BcTableUtil;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.datasource.util.DtsWordManagerImpl;
import jp.co.extreme.etc.model.EtcWord;
import jp.co.extreme.etc.util.EtcWordUtil;
import jp.co.extreme.json.JacksonUtil;
import jp.co.extreme.module.xdts.common.XdtsSqlParser;
import jp.co.extreme.module.xdts.model.XysWordContext;
import jp.co.extreme.module.xdts.model.v0001.XdtsExtractionCondition;
import jp.co.extreme.module.xdts.model.v0001.XdtsSelectColumn;
import jp.co.extreme.module.xdts.model.v0001.XdtsSelectContext;
import jp.co.extreme.poi.PoiCsvWriter4Table;
import jp.co.extreme.poi.PoiExportCondition;
import jp.co.extreme.poi.PoiUtil;
import jp.co.extreme.sql.SqlConnection;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.context.SqlContext;

public class XdtsTempProc
extends BcLoggableObject {
    File dir = new File("X:/ext_develop/ews_ext_g40/63_91_11_test");
    public Map<String, String> viewColumnMap = new HashMap<String, String>();

    public void test1(DtsSessionFactory dtsSessionFactory) throws Exception {
        File inputFile = new File(this.dir, "nls_words_new.json");
        String jsonStr = BcFileUtil.readAsString(inputFile, BcConstants.charset);
        List wordContextList = (List)JacksonUtil.getObjectMapper().readValue(jsonStr, (TypeReference)new TypeReference<List<XysWordContext>>(){});
        ArrayList<EtcWord> etcWordList = new ArrayList<EtcWord>();
        ArrayList<MmdField> mmdFieldList = new ArrayList<MmdField>();
        BcLogUtil.debug("wordContextList.size()=" + wordContextList.size());
        int i = 0;
        while (i < wordContextList.size()) {
            XysWordContext wordContext = (XysWordContext)wordContextList.get(i);
            mmdFieldList.add(wordContext.field);
            for (Map.Entry entry : wordContext.map.entrySet()) {
                EtcWord etcWord = new EtcWord();
                etcWord.code = wordContext.wordCode;
                etcWord.lang = (String)entry.getKey();
                etcWord.value = (String)entry.getValue();
                etcWordList.add(etcWord);
            }
            ++i;
        }
        DtsWordManagerImpl wordManager = (DtsWordManagerImpl)dtsSessionFactory.wordManager;
        EtcWordUtil.setWordCollection(wordManager, etcWordList);
        Map<String, MmdField> mmdFieldMap = dtsSessionFactory.mmdFieldMap;
        for (MmdField mmdField : mmdFieldList) {
            mmdField.tableColumnName = mmdField.tableColumnName.toLowerCase();
            BcLogUtil.debug("tableColumnName=" + mmdField.tableColumnName);
            this.setupMmdField(mmdField);
            mmdFieldMap.put(mmdField.tableColumnName, mmdField);
        }
        BcTableModel bcTableModel = this.createTable(wordManager.wordMap, mmdFieldMap);
        PoiExportCondition exportCondition = PoiUtil.createExportCondition();
        PoiCsvWriter4Table csvWriter4Table = new PoiCsvWriter4Table();
        File destFile = new File(this.dir, "nls_words.csv");
        BcFileUtil.deleteIfExists(destFile);
        csvWriter4Table.writeTable(exportCondition, bcTableModel.getTableColumnModel(), bcTableModel, destFile);
    }

    public BcTableModel createTable(Map<String, Map<String, String>> wordMap, Map<String, MmdField> mmdFieldMap) throws Exception {
        BcTableModel tableModel = BcTableUtil.createTableModelByHeaderValues("code", "lang", "word", "decimalDigits", "columnCount", "valueConverterClass", "formatPattern", "displayClassName", "horizonalAlignment", "renderingConverterClass", "decimalPointShift");
        Set<Map.Entry<String, Map<String, String>>> entrySet1 = wordMap.entrySet();
        for (Map.Entry<String, Map<String, String>> mapEntry1 : entrySet1) {
            Map<String, String> map2 = mapEntry1.getValue();
            MmdField mmdField = mmdFieldMap.get(mapEntry1.getKey());
            Set<Map.Entry<String, String>> entrySet2 = map2.entrySet();
            int cnt = 0;
            for (Map.Entry<String, String> mapEntry2 : entrySet2) {
                ++cnt;
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(mapEntry1.getKey());
                row.add(mapEntry2.getKey());
                String word = mapEntry2.getValue();
                if (!BcStringUtil.isEmpty(word)) {
                    word = mapEntry2.getValue().replace("\n", "").replace("\r", "");
                }
                row.add(word);
                if (mmdField != null) {
                    if (mmdField.decimalDigit > -1) {
                        row.add(mmdField.decimalDigit);
                    } else {
                        row.add(null);
                    }
                    if (mmdField.columnCount > -1) {
                        row.add(mmdField.columnCount);
                    } else {
                        row.add(null);
                    }
                    row.add(mmdField.valueConverterClassName);
                    row.add(mmdField.fieldDisplay.formatPattern);
                    row.add(mmdField.fieldDisplay.displayClassName);
                    MmdUtil.Alignment alignment = MmdUtil.Alignment.getById(mmdField.fieldDisplay.horizonalAlignment);
                    if (alignment != null && alignment != MmdUtil.Alignment.NULL) {
                        row.add(alignment.name());
                    } else {
                        row.add(null);
                    }
                    row.add(mmdField.fieldDisplay.renderingConverterClassName);
                    if (mmdField.fieldDisplay.shift != 0) {
                        row.add(mmdField.fieldDisplay.shift);
                    } else {
                        row.add(null);
                    }
                } else {
                    row.add(null);
                    row.add(null);
                    row.add(null);
                    row.add(null);
                    row.add(null);
                    row.add(null);
                    row.add(null);
                }
                tableModel.addRow(row);
            }
        }
        BcTableUtil.sort(tableModel, true, 0, 1, 2);
        this.getLogger().debug("#1:tableModel.getRowCount()=" + tableModel.getRowCount());
        return tableModel;
    }

    public void loadWordCsv(DtsSessionFactory dtsSessionFactory) throws Exception {
        File file = new File(this.dir, "nls_words.csv");
        BcCsvToTable csvToTable = new BcCsvToTable();
        csvToTable.setLogger(this.getLogger());
        BcTableModel tableModel = csvToTable.csvToTable(file, 1);
        this.getLogger().debug("loadWordCsv:tableModel.getRowCount()=" + tableModel.getRowCount());
        DtsWordManagerImpl wordManager = (DtsWordManagerImpl)dtsSessionFactory.wordManager;
        Map<String, Map<String, String>> wordMap = wordManager.wordMap;
        wordMap.clear();
        Map<String, MmdField> mmdFieldMap = dtsSessionFactory.mmdFieldMap;
        mmdFieldMap.clear();
        int i = 0;
        while (i < tableModel.getRowCount()) {
            String code = (String)tableModel.getValueAt(i, 0);
            String lang = (String)tableModel.getValueAt(i, 1);
            String word = (String)tableModel.getValueAt(i, 2);
            wordManager.putWord(code, lang, word);
            MmdField mmdField = new MmdField();
            String tmpStr = (String)tableModel.getValueAt(i, 3);
            mmdField.decimalDigit = BcNumberUtil.parseInteger(tmpStr, -1);
            tmpStr = (String)tableModel.getValueAt(i, 4);
            mmdField.columnCount = BcNumberUtil.parseInteger(tmpStr, -1);
            mmdField.valueConverterClassName = (String)tableModel.getValueAt(i, 5);
            mmdField.fieldDisplay.formatPattern = (String)tableModel.getValueAt(i, 6);
            mmdField.fieldDisplay.displayClassName = (String)tableModel.getValueAt(i, 7);
            tmpStr = (String)tableModel.getValueAt(i, 8);
            MmdUtil.Alignment alignment = BcLangUtil.getEnumByName(MmdUtil.Alignment.class, tmpStr, true);
            if (alignment != null) {
                mmdField.fieldDisplay.horizonalAlignment = alignment.id;
            }
            mmdField.fieldDisplay.renderingConverterClassName = (String)tableModel.getValueAt(i, 9);
            tmpStr = (String)tableModel.getValueAt(i, 10);
            mmdField.fieldDisplay.shift = BcNumberUtil.parseInteger(tmpStr, 0);
            this.setupMmdField(mmdField);
            mmdFieldMap.put(code, mmdField);
            ++i;
        }
    }

    public void setupMmdField(MmdField mmdField) throws Exception {
        if (!BcStringUtil.isEmpty(mmdField.dataClassName)) {
            mmdField.dataClass = Class.forName(mmdField.dataClassName);
        } else {
            BcLogUtil.debug("  ??????? dataClassName=" + mmdField.dataClassName);
        }
        BcLogUtil.debug("  displayClassName=" + mmdField.fieldDisplay.displayClassName);
        if (!BcStringUtil.isEmpty(mmdField.fieldDisplay.displayClassName)) {
            try {
                mmdField.fieldDisplay.displayClass = Class.forName(mmdField.fieldDisplay.displayClassName);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
        BcLogUtil.debug("  renderingConverterClassName=" + mmdField.fieldDisplay.renderingConverterClassName);
        if (!BcStringUtil.isEmpty(mmdField.fieldDisplay.renderingConverterClassName)) {
            try {
                Class<?> clazz = Class.forName(mmdField.fieldDisplay.renderingConverterClassName);
                mmdField.fieldDisplay.renderingConverter = (MmdRenderingConverter)BcReflectUtil.getInstance(clazz);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
    }

    public void getViewInfo(SqlConnection sqlConn) throws Exception {
        SqlContext sqlContext = sqlConn.getSqlContext();
        List<String> viewNameList = sqlContext.getViewNameList(sqlConn);
        int i = 0;
        while (i < viewNameList.size()) {
            String viewName = viewNameList.get(i);
            this.getLogger().debug("viewName=" + viewName);
            this.getViewInfo(sqlConn, viewName);
            ++i;
        }
        this.getLogger().debug("viewColumnMap.size()=" + this.viewColumnMap.size());
    }

    public void getViewInfo(SqlConnection sqlConn, String viewName) throws Exception {
        String definition = this.getViewDefinition(sqlConn, viewName);
        XdtsSqlParser sqlParser = new XdtsSqlParser();
        XdtsExtractionCondition extractionCondition = sqlParser.createExtractionCondition(definition);
        int i = 0;
        while (i < extractionCondition.selectContextList.size()) {
            XdtsSelectContext selectContext = extractionCondition.selectContextList.get(i);
            int j = 0;
            while (j < selectContext.selectColumnList.size()) {
                XdtsSelectColumn selectColumn = selectContext.selectColumnList.get(j);
                this.getLogger().debug("tableColumnName='" + selectColumn.tableColumnName.orign + "'");
                String[] strArray = MmdUtil.splitTableColumnName(selectColumn.tableColumnName.orign);
                String viewColumnName = MmdUtil.createTableColumnName(viewName, strArray[1]);
                this.viewColumnMap.put(viewColumnName, strArray[0].toLowerCase());
                ++j;
            }
            ++i;
        }
    }

    public String getViewDefinition(SqlConnection sqlConn, String viewName) throws Exception {
        SqlContext sqlContext = sqlConn.getSqlContext();
        String query = "SELECT definition FROM pg_views WHERE viewname " + sqlContext.toCondition_string("=", viewName);
        this.getLogger().debug("query=" + query);
        String definition = null;
        try (SqlStatement stmt = sqlConn.createStatement();){
            ResultSet rs = stmt.executeQuery(query);
            if (rs.next()) {
                definition = rs.getString(1);
            }
            rs.close();
        }
        return definition;
    }
}

