/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import sun.security.internal.spec.TlsMasterSecretParameterSpec;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11SecretKeyFactory;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_SSL3_MASTER_KEY_DERIVE_PARAMS;
import sun.security.pkcs11.wrapper.CK_SSL3_RANDOM_DATA;
import sun.security.pkcs11.wrapper.CK_TLS12_MASTER_KEY_DERIVE_PARAMS;
import sun.security.pkcs11.wrapper.CK_VERSION;
import sun.security.pkcs11.wrapper.Functions;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public final class P11TlsMasterSecretGenerator
extends KeyGeneratorSpi {
    private static final String MSG = "TlsMasterSecretGenerator must be initialized using a TlsMasterSecretParameterSpec";
    private final Token token;
    private final String algorithm;
    private long mechanism;
    private TlsMasterSecretParameterSpec spec;
    private P11Key p11Key;
    int version;
    CK_VERSION ckVersion;
    private final boolean supportSSLv3;

    P11TlsMasterSecretGenerator(Token token, String string, long l) throws PKCS11Exception {
        this.token = token;
        this.algorithm = string;
        this.mechanism = l;
        this.supportSSLv3 = l == 881L;
    }

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof TlsMasterSecretParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        TlsMasterSecretParameterSpec tlsMasterSecretParameterSpec = (TlsMasterSecretParameterSpec)algorithmParameterSpec;
        this.version = tlsMasterSecretParameterSpec.getMajorVersion() << 8 | tlsMasterSecretParameterSpec.getMinorVersion();
        if (this.version == 768 && !this.supportSSLv3 || this.version < 768 || this.version > 771) {
            throw new InvalidAlgorithmParameterException("Only SSL 3.0, TLS 1.0, TLS 1.1, and TLS 1.2 are supported");
        }
        SecretKey secretKey = tlsMasterSecretParameterSpec.getPremasterSecret();
        try {
            this.p11Key = P11SecretKeyFactory.convertKey(this.token, secretKey, null);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidAlgorithmParameterException("init() failed", invalidKeyException);
        }
        this.spec = tlsMasterSecretParameterSpec;
        boolean bl = this.p11Key.getAlgorithm().equals("TlsRsaPremasterSecret");
        if (this.version == 768) {
            this.mechanism = bl ? 881L : 883L;
        } else if (this.version == 769 || this.version == 770) {
            this.mechanism = bl ? 885L : 887L;
        } else if (this.version == 771) {
            this.mechanism = bl ? 992L : 994L;
        }
        this.ckVersion = bl ? new CK_VERSION(0, 0) : null;
    }

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        Object object;
        if (this.spec == null) {
            throw new IllegalStateException("TlsMasterSecretGenerator must be initialized");
        }
        byte[] byArray = this.spec.getClientRandom();
        byte[] byArray2 = this.spec.getServerRandom();
        CK_SSL3_RANDOM_DATA cK_SSL3_RANDOM_DATA = new CK_SSL3_RANDOM_DATA(byArray, byArray2);
        CK_MECHANISM cK_MECHANISM = null;
        if (this.version < 771) {
            object = new CK_SSL3_MASTER_KEY_DERIVE_PARAMS(cK_SSL3_RANDOM_DATA, this.ckVersion);
            cK_MECHANISM = new CK_MECHANISM(this.mechanism, (CK_SSL3_MASTER_KEY_DERIVE_PARAMS)object);
        } else if (this.version == 771) {
            object = new CK_TLS12_MASTER_KEY_DERIVE_PARAMS(cK_SSL3_RANDOM_DATA, this.ckVersion, Functions.getHashMechId(this.spec.getPRFHashAlg()));
            cK_MECHANISM = new CK_MECHANISM(this.mechanism, (CK_TLS12_MASTER_KEY_DERIVE_PARAMS)object);
        }
        object = null;
        try {
            SecretKey secretKey;
            int n;
            int n2;
            object = this.token.getObjSession();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = this.token.getAttributes("generate", 4L, 16L, new CK_ATTRIBUTE[0]);
            long l = this.token.p11.C_DeriveKey(((Session)object).id(), cK_MECHANISM, this.p11Key.keyID, cK_ATTRIBUTEArray);
            if (this.ckVersion == null) {
                n2 = -1;
                n = -1;
            } else {
                n2 = this.ckVersion.major;
                n = this.ckVersion.minor;
            }
            SecretKey secretKey2 = secretKey = P11Key.masterSecretKey((Session)object, l, "TlsMasterSecret", 384, cK_ATTRIBUTEArray, n2, n);
            return secretKey2;
        }
        catch (Exception exception) {
            throw new ProviderException("Could not generate key", exception);
        }
        finally {
            this.token.releaseSession((Session)object);
        }
    }
}

