/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.sql.context;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcUnicode;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.sql.SqlConnection;
import jp.co.extreme.sql.SqlConstants;
import jp.co.extreme.sql.SqlDefinitionCondition;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlResultSet_PostgreSQL;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import org.apache.commons.codec.binary.Hex;

public class SqlContext_PostgreSQL
extends SqlContext {
    public static final String DRIVER_CLASS_NAME = "org.postgresql.Driver";
    public static final String[] DRIVER_CLASS_NAMES = new String[]{"org.postgresql.Driver"};
    public static final int PORT_DEFAULT = 5432;
    private Map<Character, String> escapeCharacterMap;
    boolean NO_BACKSLASH_ESCAPES = true;
    public static final String NANO = "ffffff";
    private List<String> reservedWordList;

    public SqlContext_PostgreSQL(SqlConstants.DatabaseProduct productName) throws Exception {
        super(productName);
    }

    @Override
    public String[] getDriverClassNames() {
        return DRIVER_CLASS_NAMES;
    }

    @Override
    public int getDefaultPort() {
        return 5432;
    }

    @Override
    public Map<Character, String> getEscapeCharacterMap() {
        if (this.escapeCharacterMap == null) {
            this.escapeCharacterMap = new HashMap<Character, String>();
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.BS.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.BS.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.HT.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.HT.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.LF.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.LF.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.FF.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.FF.char_));
            this.escapeCharacterMap.put(Character.valueOf(BcUnicode.CR.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.CR.char_));
            if (this.NO_BACKSLASH_ESCAPES) {
                this.escapeCharacterMap.put(Character.valueOf(BcUnicode.quotationMark.char_), String.valueOf(String.valueOf(BcUnicode.quotationMark.char_)) + String.valueOf(BcUnicode.quotationMark.char_));
                this.escapeCharacterMap.put(Character.valueOf(BcUnicode.apostrophe.char_), String.valueOf(String.valueOf(BcUnicode.apostrophe.char_)) + String.valueOf(BcUnicode.apostrophe.char_));
            } else {
                this.escapeCharacterMap.put(Character.valueOf(BcUnicode.quotationMark.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.quotationMark.char_));
                this.escapeCharacterMap.put(Character.valueOf(BcUnicode.apostrophe.char_), String.valueOf(String.valueOf(BcUnicode.reverseSolidus.char_)) + String.valueOf(BcUnicode.apostrophe.char_));
            }
        }
        return this.escapeCharacterMap;
    }

    @Override
    public String type_NUMBER(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -6: {
                definition = "SMALLINT";
                break;
            }
            case 2: 
            case 3: {
                if (mmdField.dataSize > 1000) break;
                definition = "NUMERIC(" + mmdField.dataSize + ", " + mmdField.decimalDigit + ")";
                break;
            }
            default: {
                definition = super.type_NUMBER(mmdField, definitionCondition);
            }
        }
        return definition;
    }

    @Override
    public String type_CHAR(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        String definition = null;
        switch (mmdField.sqlTypeId) {
            case -15: 
            case 1: {
                definition = "CHARACTER(" + mmdField.dataSize + ")";
                break;
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: 
            case 2005: 
            case 2011: {
                definition = mmdField.dataSize <= 65535 ? "VARCHAR(" + mmdField.dataSize + ")" : "TEXT";
            }
        }
        return definition;
    }

    @Override
    public String type_BINARY(MmdField mmdField, SqlDefinitionCondition definitionCondition) throws Exception {
        return "BYTEA";
    }

    @Override
    public void setNull_BLOB(PreparedStatement ppst, int colmunIndex) throws Exception {
        ppst.setNull(colmunIndex, -4);
    }

    @Override
    public String getTimestampFormatForUpdate() {
        return "yyyy/MM/dd HH:mm:ss.ffffff";
    }

    @Override
    public String getTimestampFormatForCondition() {
        return this.getTimestampFormatForUpdate();
    }

    @Override
    public String getDateTimeFormatForCondition() {
        return "yyyy/MM/dd HH:mm:ss";
    }

    @Override
    public String getDateFormatForCondition() {
        return "yyyy/MM/dd";
    }

    @Override
    public int dropIndex(SqlConnection sqlConn, String tableName, String indexName) throws Exception {
        String query = "DROP INDEX " + indexName;
        BcLogUtil.info("query=" + query);
        return SqlUtil.executeUpdate(sqlConn, query);
    }

    @Override
    public String toNumber(String columnName, int length) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("TO_NUMBER(");
        sb.append(columnName);
        sb.append(",");
        sb.append("'" + BcStringUtil.fill('9', length) + "'");
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String func_clockTimestamp() throws Exception {
        return "clock_timestamp()";
    }

    @Override
    public String func_statementTimestamp() throws Exception {
        return "statement_timestamp()";
    }

    @Override
    public String func_transactionTimestamp() throws Exception {
        return "transaction_timestamp()";
    }

    @Override
    public String func_coalesce(String ... values) throws Exception {
        return "COALESCE(" + BcStringUtil.toCsv(true, values) + ")";
    }

    @Override
    public String func_replace_regexp(String src, String regexp, String replacement) throws Exception {
        return this.func_replace_regexp(src, BcStringUtil.singleQuotation(regexp), BcStringUtil.singleQuotation(replacement), BcStringUtil.singleQuotation(RegexFrag.g.name()));
    }

    @Override
    public String convertSql(String srcSql, Map<String, String> paramMap, SqlContext baseSqlContext) throws Exception {
        StringBuilder sb = new StringBuilder(srcSql);
        sb = BcStringUtil.replace(sb, " DECIMAL", " NUMERIC", false);
        return sb.toString();
    }

    @Override
    public SqlResultSet convToSqlResultSet(ResultSet rs, SqlStatement sqlStatement) throws SQLException {
        return new SqlResultSet_PostgreSQL(rs, sqlStatement);
    }

    @Override
    public String createBinaryInsert(byte[] bytes) throws Exception {
        String hex = new String(Hex.encodeHex((byte[])bytes));
        return "DECODE(" + BcStringUtil.singleQuotation(hex) + ", 'HEX')";
    }

    @Override
    public boolean isReservedWord(String word) throws Exception {
        if (this.reservedWordList == null) {
            this.reservedWordList = this.cretaeReservedWordList("psql_10");
        }
        return this.reservedWordList.contains(word.toLowerCase());
    }

    public static enum RegexFrag {
        i,
        g;

    }
}

