/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdIndex;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.module.xdts.common.EtcSqlConditionUtil;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.model.XdtsProcessCondition;
import jp.co.extreme.module.xdts.model.XdtsSchemaObject;
import jp.co.extreme.module.xdts.server.XdtsServerUtil;
import jp.co.extreme.module.xdts.server.XsysResultSetCopyTask;
import jp.co.extreme.sql.SqlConnection;
import jp.co.extreme.sql.SqlDefinitionCondition;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.task.TskAbstractCallable;

public class XdtsRowCopyTask
extends TskAbstractCallable<BcResult> {
    @Override
    public BcResult taskProcess() throws Exception {
        BcResult result = new BcResult();
        return result;
    }

    public void copyRow(SqlConnection sqlConn1, SqlConnection sqlConn2, Collection<XdtsSchemaObject> schemaObjectCollection, XdtsProcessCondition processCondition) throws Exception {
        this.getLogger().debug("commitMode=" + (Object)((Object)processCondition.commitMode));
        File errorFile = new File(processCondition.errorFilePath);
        this.getLogger().info("errorFile=" + errorFile.getPath());
        BcFileUtil.makeParent(errorFile);
        OutputStreamWriter errorWriter = null;
        errorWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(errorFile, false), BcConstants.charset.name());
        if (processCondition.commitMode == XdtsConstants.CommitMode.AUTO) {
            sqlConn2.setAutoCommit(true);
        }
        this.copyRow_L2(sqlConn1, sqlConn2, schemaObjectCollection, processCondition, errorWriter);
        if (processCondition.commitMode == XdtsConstants.CommitMode.FINAL) {
            sqlConn2.commit();
        }
        sqlConn2.setAutoCommit(false);
    }

    public void copyRow_L2(SqlConnection sqlConn1, SqlConnection sqlConn2, Collection<XdtsSchemaObject> schemaObjectCollection, XdtsProcessCondition processCondition, Writer errorWriter) throws Exception {
        for (XdtsSchemaObject schemaObject : schemaObjectCollection) {
            SqlContext sqlContext1 = sqlConn1.getSqlContext();
            MmdModel mmdModel1 = sqlContext1.createModelMetaData(sqlConn1, schemaObject.name1);
            this.copyRow_L3(sqlConn1, sqlConn2, mmdModel1, processCondition, errorWriter);
            if (processCondition.commitMode != XdtsConstants.CommitMode.TABLE) continue;
            sqlConn2.commit();
        }
    }

    public void copyRow_L3(SqlConnection sqlConn1, SqlConnection sqlConn2, MmdModel mmdModel1, XdtsProcessCondition processCondition, Writer errorWriter) throws Exception {
        SqlContext sqlContext1 = sqlConn1.getSqlContext();
        SqlContext sqlContext2 = sqlConn2.getSqlContext();
        MmdModel mmdModel2 = this.createTablePre(sqlContext1, mmdModel1, sqlContext2, processCondition.definitionCondition);
        boolean existTable = XdtsServerUtil.getInstance().dropTable(sqlConn2, mmdModel2.tableName, processCondition.recreateTable, processCondition.truncateTable, processCondition.deleteRecord);
        if (!existTable) {
            this.createTable(processCondition, mmdModel2, sqlConn2, errorWriter);
        }
        this.copyRow_L4(sqlConn1, sqlConn2, mmdModel2, processCondition.copyRowUnit, processCondition.ignoreException, errorWriter);
        if (processCondition.recreateTable) {
            this.createIndex(sqlConn2, mmdModel2, processCondition, errorWriter);
        }
    }

    public long copyRow_L4(SqlConnection sqlConn1, SqlConnection sqlConn2, MmdModel mmdModel2, long rowCountUnit, boolean ignoreException, Writer errorWriter) throws Exception {
        SqlContext sqlContext1 = sqlConn1.getSqlContext();
        MmdModel mmdModel1 = sqlContext1.createModelMetaData(sqlConn1, mmdModel2.tableName);
        SqlSelectQuery selectQuery = EtcSqlConditionUtil.createSelectQuery(sqlContext1, mmdModel1);
        MmdIndex primaryIndex = mmdModel1.getPrimaryIndex();
        if (primaryIndex != null) {
            List<String> orderByList = EtcSqlConditionUtil.createOrderByList(primaryIndex);
            selectQuery.getOrderByList().addAll(orderByList);
        }
        long rowCount = sqlContext1.getRowCount(sqlConn1, mmdModel2.tableName);
        this.getLogger().info("rowCount=" + rowCount);
        long roopCnt = 1L;
        if (rowCountUnit > 0L) {
            roopCnt = rowCount / rowCountUnit;
            if (rowCount % rowCountUnit > 0L) {
                ++roopCnt;
            }
        }
        long updateCountSum = 0L;
        int i = 0;
        while ((long)i < roopCnt) {
            if (roopCnt > 1L) {
                selectQuery.rowLimit = rowCountUnit;
                selectQuery.rowOffset = (long)i * rowCountUnit + 1L;
            }
            String query = sqlContext1.buildSelectQuery(selectQuery);
            this.getLogger().info("selectQuery=" + query);
            Throwable throwable = null;
            Object var21_20 = null;
            try (SqlStatement stmt = sqlConn1.createStatement();){
                SqlResultSet rs = stmt.executeQuery(query);
                long updateCount = this.copyRow_L5(rs, sqlConn2, mmdModel2, ignoreException, errorWriter);
                this.getLogger().info("updateCount=" + updateCount + " updateCountSum=" + (updateCountSum += updateCount));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++i;
        }
        return updateCountSum;
    }

    public long copyRow_L5(SqlResultSet rs, SqlConnection sqlConn2, MmdModel mmdModel2, boolean ignoreException, Writer errorWriter) throws Exception {
        XsysResultSetCopyTask resultSetCopyTask = new XsysResultSetCopyTask();
        resultSetCopyTask.setLogger(this.getLogger());
        resultSetCopyTask.setResultSet(rs);
        resultSetCopyTask.setCondition(sqlConn2, mmdModel2, ignoreException, errorWriter);
        resultSetCopyTask.taskProcess();
        return resultSetCopyTask.updateCount;
    }

    public MmdModel createTablePre(SqlContext sqlContext1, MmdModel mmdModel1, SqlContext sqlContext2, SqlDefinitionCondition definitionCondition) throws Exception {
        MmdModel mmdModel2 = sqlContext1.convertModelMetaData(mmdModel1, sqlContext2);
        int i = 0;
        while (i < mmdModel2.getFieldCount()) {
            MmdField mmdField = mmdModel2.getField(i);
            if (sqlContext2.isReservedWord(mmdField.columnName)) {
                mmdField.columnName = String.valueOf(mmdField.columnName) + "_";
            }
            ++i;
        }
        XdtsServerUtil.getInstance().removeField(sqlContext2, mmdModel2, definitionCondition, true, this.getLogger());
        return mmdModel2;
    }

    public void createTable(XdtsProcessCondition processCondition, MmdModel mmdModel2, SqlConnection sqlConn2, Writer errorWriter) throws Exception {
        SqlContext sqlContext2 = sqlConn2.getSqlContext();
        this.getLogger().info("\u30c6\u30fc\u30d6\u30eb\u3092\u4f5c\u6210\u4e2d... \u30c6\u30fc\u30d6\u30eb\u540d=" + mmdModel2.tableName);
        String query = sqlContext2.createCreateTableQuery(mmdModel2, false, processCondition.definitionCondition);
        this.getLogger().info("query=" + query);
        int cnt = SqlUtil.executeUpdate(sqlConn2, query);
    }

    public void createIndex(SqlConnection sqlConn, MmdModel mmdModel, XdtsProcessCondition processCondition, Writer errorWriter) throws Exception {
        block2: {
            this.getLogger().info("\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3092\u4f5c\u6210\u4e2d... \u30c6\u30fc\u30d6\u30eb\u540d=" + mmdModel.tableName);
            SqlContext sqlContext = sqlConn.getSqlContext();
            try {
                int n = sqlContext.createIndex(sqlConn, mmdModel, this.getLogger());
            }
            catch (Exception ex) {
                String stackTrace = BcLogUtil.getStackTrace(ex);
                errorWriter.append(stackTrace);
                if (processCondition.ignoreException) break block2;
                throw ex;
            }
        }
    }
}

