/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.transforms.implementations;

import com.sun.org.apache.xml.internal.security.parser.XMLParserException;
import com.sun.org.apache.xml.internal.security.signature.NodeFilter;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.TransformSpi;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.utils.JDKXPathFactory;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.XPathAPI;
import com.sun.org.apache.xml.internal.security.utils.XPathFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.Security;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TransformXPath
extends TransformSpi {
    static final boolean HEREFUNC;

    @Override
    protected String engineGetURI() {
        return "http://www.w3.org/TR/1999/REC-xpath-19991116";
    }

    @Override
    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput, OutputStream outputStream, Element element, String string, boolean bl) throws TransformationException {
        try {
            Element element2 = XMLUtils.selectDsNode(element.getFirstChild(), "XPath", 0);
            if (element2 == null) {
                Object[] objectArray = new Object[]{"ds:XPath", "Transform"};
                throw new TransformationException("xml.WrongContent", objectArray);
            }
            Node node = element2.getFirstChild();
            if (node == null) {
                throw new DOMException(3, "Text must be in ds:Xpath");
            }
            String string2 = XMLUtils.getStrFromNode(node);
            xMLSignatureInput.setNeedsToBeExpanded(this.needsCircumvent(string2));
            XPathFactory xPathFactory = this.getXPathFactory();
            XPathAPI xPathAPI = xPathFactory.newXPathAPI();
            xMLSignatureInput.addNodeFilter(new XPathNodeFilter(element2, node, string2, xPathAPI));
            xMLSignatureInput.setNodeSet(true);
            return xMLSignatureInput;
        }
        catch (XMLParserException | IOException | DOMException exception) {
            throw new TransformationException(exception);
        }
    }

    protected XPathFactory getXPathFactory() {
        return HEREFUNC ? XPathFactory.newInstance() : new JDKXPathFactory();
    }

    private boolean needsCircumvent(String string) {
        return string.indexOf("namespace") != -1 || string.indexOf("name()") != -1;
    }

    static {
        String string = AccessController.doPrivileged(() -> Security.getProperty("jdk.xml.dsig.hereFunctionSupported"));
        if (string == null) {
            HEREFUNC = true;
        } else if (string.equals("true")) {
            HEREFUNC = true;
        } else if (string.equals("false")) {
            HEREFUNC = false;
        } else {
            throw new IllegalArgumentException("Invalid jdk.xml.dsig.hereFunctionSupported setting: " + string);
        }
    }

    private static class XPathNodeFilter
    implements NodeFilter {
        private final XPathAPI xPathAPI;
        private final Node xpathnode;
        private final Element xpathElement;
        private final String str;

        XPathNodeFilter(Element element, Node node, String string, XPathAPI xPathAPI) {
            this.xpathnode = node;
            this.str = string;
            this.xpathElement = element;
            this.xPathAPI = xPathAPI;
        }

        @Override
        public int isNodeInclude(Node node) throws TransformationException {
            try {
                boolean bl = this.xPathAPI.evaluate(node, this.xpathnode, this.str, this.xpathElement);
                if (bl) {
                    return 1;
                }
                return 0;
            }
            catch (TransformerException transformerException) {
                throw new TransformationException(transformerException);
            }
        }

        @Override
        public int isNodeIncludeDO(Node node, int n) throws TransformationException {
            return this.isNodeInclude(node);
        }
    }
}

