/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.Enumerated;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;

public class SnmpInt
extends SnmpValue {
    private static final long serialVersionUID = -7163624758070343373L;
    static final String name = "Integer32";
    protected long value = 0L;

    public SnmpInt(int n) throws IllegalArgumentException {
        if (!this.isInitValueValid(n)) {
            throw new IllegalArgumentException();
        }
        this.value = n;
    }

    public SnmpInt(Integer n) throws IllegalArgumentException {
        this((int)n);
    }

    public SnmpInt(long l) throws IllegalArgumentException {
        if (!this.isInitValueValid(l)) {
            throw new IllegalArgumentException();
        }
        this.value = l;
    }

    public SnmpInt(Long l) throws IllegalArgumentException {
        this((long)l);
    }

    public SnmpInt(Enumerated enumerated) throws IllegalArgumentException {
        this(enumerated.intValue());
    }

    public SnmpInt(boolean bl) {
        this.value = bl ? 1L : 2L;
    }

    public long longValue() {
        return this.value;
    }

    public Long toLong() {
        return new Long(this.value);
    }

    public int intValue() {
        return (int)this.value;
    }

    public Integer toInteger() {
        return new Integer((int)this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public SnmpOid toOid() {
        return new SnmpOid(this.value);
    }

    public static SnmpOid toOid(long[] lArray, int n) throws SnmpStatusException {
        try {
            return new SnmpOid(lArray[n]);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SnmpStatusException(2);
        }
    }

    public static int nextOid(long[] lArray, int n) throws SnmpStatusException {
        if (n >= lArray.length) {
            throw new SnmpStatusException(2);
        }
        return n + 1;
    }

    public static void appendToOid(SnmpOid snmpOid, SnmpOid snmpOid2) {
        if (snmpOid.getLength() != 1) {
            throw new IllegalArgumentException();
        }
        snmpOid2.append(snmpOid);
    }

    @Override
    public final synchronized SnmpValue duplicate() {
        return (SnmpValue)this.clone();
    }

    public final synchronized Object clone() {
        SnmpInt snmpInt = null;
        try {
            snmpInt = (SnmpInt)super.clone();
            snmpInt.value = this.value;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
        return snmpInt;
    }

    @Override
    public String getTypeName() {
        return name;
    }

    boolean isInitValueValid(int n) {
        return n >= Integer.MIN_VALUE && n <= Integer.MAX_VALUE;
    }

    boolean isInitValueValid(long l) {
        return l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE;
    }
}

