/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp.util;

import com.sun.media.CircularBuffer;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketSource;
import com.sun.media.rtp.util.UDPPacket;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import javax.media.rtp.RTPPushDataSource;

public class RTPPacketReceiver
implements PacketSource,
SourceTransferHandler {
    RTPPushDataSource rtpsource = null;
    CircularBuffer bufQue = new CircularBuffer(2);
    boolean closed = false;
    boolean dataRead = false;

    public RTPPacketReceiver(RTPPushDataSource rtpsource) {
        this.rtpsource = rtpsource;
        PushSourceStream output = rtpsource.getOutputStream();
        output.setTransferHandler(this);
    }

    public RTPPacketReceiver(PushSourceStream pss) {
        pss.setTransferHandler(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transferData(PushSourceStream sourcestream) {
        Buffer buf;
        CircularBuffer circularBuffer = this.bufQue;
        synchronized (circularBuffer) {
            while (!this.bufQue.canWrite() && !this.closed) {
                try {
                    this.bufQue.wait(1000L);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
            }
            if (this.closed) {
                return;
            }
            buf = this.bufQue.getEmptyBuffer();
        }
        int size = sourcestream.getMinimumTransferSize();
        byte[] data = (byte[])buf.getData();
        int len = 0;
        if (data == null || data.length < size) {
            data = new byte[size];
            buf.setData(data);
        }
        try {
            len = sourcestream.read(data, 0, size);
        }
        catch (IOException e3) {
            // empty catch block
        }
        buf.setLength(len);
        buf.setOffset(0);
        CircularBuffer circularBuffer2 = this.bufQue;
        synchronized (circularBuffer2) {
            this.bufQue.writeReport();
            this.bufQue.notify();
            return;
        }
    }

    public Packet receiveFrom() throws IOException {
        Buffer buf;
        CircularBuffer circularBuffer = this.bufQue;
        synchronized (circularBuffer) {
            if (this.dataRead) {
                this.bufQue.readReport();
                this.bufQue.notify();
            }
            while (!this.bufQue.canRead() && !this.closed) {
                try {
                    this.bufQue.wait(1000L);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
            }
            if (this.closed) {
                buf = null;
                this.dataRead = false;
            } else {
                buf = this.bufQue.read();
                this.dataRead = true;
            }
        }
        byte[] data = buf != null ? (byte[])buf.getData() : new byte[1];
        UDPPacket p = new UDPPacket();
        p.receiptTime = System.currentTimeMillis();
        p.data = data;
        p.offset = 0;
        p.length = buf == null ? 0 : buf.getLength();
        return p;
    }

    public void closeSource() {
        CircularBuffer circularBuffer = this.bufQue;
        synchronized (circularBuffer) {
            this.closed = true;
            this.bufQue.notifyAll();
        }
    }

    public String sourceString() {
        String s = "RTPPacketReceiver for " + this.rtpsource;
        return s;
    }
}

