/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util.type;

import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import org.apache.bsf.util.type.TypeConvertor;

public class TypeConvertorRegistry {
    Hashtable reg = new Hashtable();
    Hashtable keyedReg = new Hashtable();

    public TypeConvertorRegistry() {
        TypeConvertor tc = new TypeConvertor(){

            @Override
            public Object convert(Class from, Class to, Object obj) {
                return obj;
            }

            @Override
            public String getCodeGenString() {
                return "(Class from, Class to, Object obj) {\nreturn obj;\n}";
            }
        };
        this.register(Boolean.class, Boolean.TYPE, tc);
        this.register(Boolean.TYPE, Boolean.class, tc);
        this.register(Byte.class, Byte.TYPE, tc);
        this.register(Byte.TYPE, Byte.class, tc);
        this.register(Character.class, Character.TYPE, tc);
        this.register(Character.TYPE, Character.class, tc);
        this.register(Short.class, Short.TYPE, tc);
        this.register(Short.TYPE, Short.class, tc);
        this.register(Integer.class, Integer.TYPE, tc);
        this.register(Integer.TYPE, Integer.class, tc);
        this.register(Long.class, Long.TYPE, tc);
        this.register(Long.TYPE, Long.class, tc);
        this.register(Float.class, Float.TYPE, tc);
        this.register(Float.TYPE, Float.class, tc);
        this.register(Double.class, Double.TYPE, tc);
        this.register(Double.TYPE, Double.class, tc);
        tc = new TypeConvertor(){

            @Override
            public Object convert(Class from, Class to, Object obj) {
                return obj == null ? "(null)" : obj.toString();
            }

            @Override
            public String getCodeGenString() {
                return "(Class from, Class to, Object obj) {\nreturn (obj == null) ? \"(null)\" : obj.toString ();\n}";
            }
        };
        this.register(Object.class, String.class, tc);
        tc = new TypeConvertor(){

            @Override
            public Object convert(Class from, Class to, Object obj) {
                String str = (String)obj;
                if (to == Boolean.class || to == Boolean.TYPE) {
                    return Boolean.valueOf(str);
                }
                if (to == Byte.class || to == Byte.TYPE) {
                    return Byte.valueOf(str);
                }
                if (to == Character.class || to == Character.TYPE) {
                    return new Character(str.charAt(0));
                }
                if (to == Short.class || to == Short.TYPE) {
                    return Short.valueOf(str);
                }
                if (to == Integer.class || to == Integer.TYPE) {
                    return Integer.valueOf(str);
                }
                if (to == Long.class || to == Long.TYPE) {
                    return Long.valueOf(str);
                }
                if (to == Float.class || to == Float.TYPE) {
                    return Float.valueOf(str);
                }
                if (to == Double.class || to == Double.TYPE) {
                    return Double.valueOf(str);
                }
                return null;
            }

            @Override
            public String getCodeGenString() {
                return "(Class from, Class to, Object obj) {\nString str = (String) obj;\nif (to == Boolean.class || to == boolean.class) {\nreturn Boolean.valueOf (str);\n} else if (to == Byte.class || to == byte.class) {\nreturn Byte.valueOf (str);\n} else if (to == Character.class || to == char.class) {\nreturn new Character (str.charAt (0));\n} else if (to == Short.class || to == short.class) {\nreturn Short.valueOf (str);\n} else if (to == Integer.class || to == int.class) {\nreturn Integer.valueOf (str);\n} else if (to == Long.class || to == long.class) {\nreturn Long.valueOf (str);\n} else if (to == Float.class || to == float.class) {\nreturn Float.valueOf (str);\n} else if (to == Double.class || to == double.class) {\nreturn Double.valueOf (str);\n} else {\nreturn null;\n}\n}";
            }
        };
        this.register(String.class, Boolean.TYPE, tc);
        this.register(String.class, Boolean.class, tc);
        this.register(String.class, Byte.TYPE, tc);
        this.register(String.class, Byte.class, tc);
        this.register(String.class, Character.TYPE, tc);
        this.register(String.class, Character.class, tc);
        this.register(String.class, Short.TYPE, tc);
        this.register(String.class, Short.class, tc);
        this.register(String.class, Integer.TYPE, tc);
        this.register(String.class, Integer.class, tc);
        this.register(String.class, Long.TYPE, tc);
        this.register(String.class, Long.class, tc);
        this.register(String.class, Float.TYPE, tc);
        this.register(String.class, Float.class, tc);
        this.register(String.class, Double.TYPE, tc);
        this.register(String.class, Double.class, tc);
        tc = new TypeConvertor(){

            @Override
            public Object convert(Class from, Class to, Object obj) {
                return Font.decode((String)obj);
            }

            @Override
            public String getCodeGenString() {
                return "(Class from, Class to, Object obj) {\nreturn Font.decode ((String) obj);\n}";
            }
        };
        this.register(String.class, Font.class, tc);
        tc = new TypeConvertor(){

            @Override
            public Object convert(Class from, Class to, Object obj) {
                return Color.decode((String)obj);
            }

            @Override
            public String getCodeGenString() {
                return "(Class from, Class to, Object obj) {\nreturn Color.decode ((String) obj);\n}";
            }
        };
        this.register(String.class, Color.class, tc);
    }

    public TypeConvertor lookup(Class from, Class to) {
        String key = String.valueOf(from.getName()) + " -> " + to.getName();
        TypeConvertor tc = (TypeConvertor)this.reg.get(key);
        if (tc == null && from != Void.TYPE && from != Void.class && to == String.class) {
            return this.lookup(Object.class, String.class);
        }
        return tc;
    }

    public TypeConvertor lookupByKey(Object key) {
        return (TypeConvertor)this.keyedReg.get(key);
    }

    public void register(Class from, Class to, TypeConvertor convertor) {
        String key = String.valueOf(from.getName()) + " -> " + to.getName();
        this.reg.put(key, convertor);
    }

    public void registerByKey(Object key, TypeConvertor convertor) {
        this.keyedReg.put(key, convertor);
    }
}

