/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.nlp;

import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.nlp.NlpElement;
import jp.co.extreme.nlp.NlpTokenWrap;
import jp.co.extreme.nlp.NlpUtil;
import jp.co.extreme.nlp.NlpWord;

public abstract class NlpNounFinderHelper
extends BcLoggableObject {
    protected int max = 6;

    protected List<NlpElement> find(List<NlpTokenWrap> tokenWrapList1) throws Exception {
        ArrayList<NlpElement> elementList = new ArrayList<NlpElement>();
        int i = 0;
        while (i < tokenWrapList1.size()) {
            NlpTokenWrap tokenWrap1 = tokenWrapList1.get(i);
            if (!this.isSkip(tokenWrap1)) {
                int loopMax = Math.min(this.max, tokenWrapList1.size() - i - 1);
                int j = 0;
                while (j < loopMax) {
                    List<NlpTokenWrap> tokenWrapList2;
                    NlpWord noun;
                    int toIndex = i + loopMax - j + 1;
                    if (toIndex <= tokenWrapList1.size() && (noun = this.find_L2(tokenWrapList2 = tokenWrapList1.subList(i, toIndex))) != null) {
                        NlpElement nlpElement = NlpUtil.createElement(noun, tokenWrapList2);
                        elementList.add(nlpElement);
                        i += tokenWrapList2.size() - 1;
                        int k = 0;
                        while (k < tokenWrapList2.size()) {
                            NlpTokenWrap tokenWrap2 = tokenWrapList2.get(k);
                            ++tokenWrap2.usage;
                            ++k;
                        }
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return elementList;
    }

    protected NlpWord find_L2(List<NlpTokenWrap> tokenWrapList1) throws Exception {
        ArrayList<NlpTokenWrap> tokenWrapList2 = new ArrayList<NlpTokenWrap>();
        int i = 0;
        while (i < tokenWrapList1.size()) {
            NlpTokenWrap tokenWrap = tokenWrapList1.get(i);
            if (tokenWrap.posLevel > 0) {
                return null;
            }
            if (tokenWrap.usage > 0) {
                return null;
            }
            if (tokenWrap.comma > 0) {
                return null;
            }
            if (i == 0 || i == tokenWrapList1.size() - 1 || !this.isSkip(tokenWrap)) {
                tokenWrapList2.add(tokenWrap);
            }
            ++i;
        }
        NlpWord noun = this.getNoun(tokenWrapList2);
        return noun;
    }

    protected boolean isSkip(NlpTokenWrap tokenWrap1) throws Exception {
        return BcStringUtil.isSpace(tokenWrap1.token.surface);
    }

    abstract NlpWord getNoun(List<NlpTokenWrap> var1) throws Exception;
}

