/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsod.fx;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.MenuBar;
import javafx.stage.Screen;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.fx.extension.FxxAbstractDesktopPane;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.module.xsod.common.XsodConstants;
import jp.co.extreme.module.xsod.common.XsodWords;
import jp.co.extreme.module.xsod.fx.XsodController;
import jp.co.extreme.module.xsod.fx.XsodCustomerPane;
import jp.co.extreme.module.xsod.fx.XsodKitchenPane;
import jp.co.extreme.module.xsod.fx.XsodSignagePane;
import jp.co.extreme.module.xsod.fx.XsodUiFactory;
import jp.co.extreme.scf4.fx.HfxClientUtil;

public class XsodDesktop
extends FxxAbstractDesktopPane {
    XsodCustomerPane customerPane;
    public XsodKitchenPane kitchenPane;
    XsodSignagePane signagePane;

    private XsodDesktop() {
    }

    public static XsodDesktop getInstance() throws Exception {
        return SingletonHolder.instance;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        XsodController.getInstance().setupLocalProperty();
        Rectangle2D screenRectangle = Screen.getPrimary().getVisualBounds();
        if (XsodController.getInstance().debugMode > 0) {
            screenRectangle = new Rectangle2D(0.0, 0.0, (double)XsodConstants.SIZE_1920x1080[0], (double)XsodConstants.SIZE_1920x1080[1]);
        }
        XsodUiFactory.getInstance().setWindowSize(screenRectangle.getWidth(), screenRectangle.getHeight());
        String desktopMode = XsodController.getInstance().desktopMode;
        if ("K".equals(desktopMode)) {
            this.kitchenPane = new XsodKitchenPane();
            this.setContentNode((Node)this.kitchenPane);
        } else if ("T".equals(desktopMode)) {
            this.getChildren().remove((Object)this.topPane);
            this.getStage().setFullScreen(true);
            this.customerPane = new XsodCustomerPane();
            this.setContentNode((Node)this.customerPane);
            XsodController.getInstance().selectTop();
        } else if ("S".equals(desktopMode)) {
            this.getChildren().remove((Object)this.topPane);
            if (XsodController.getInstance().isFullScreen) {
                this.getStage().setFullScreen(true);
            }
            this.signagePane = new XsodSignagePane();
            this.setContentNode((Node)this.signagePane);
        } else {
            String msg = "\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u306a\u3044\u30c7\u30b9\u30af\u30c8\u30c3\u30d7\u30e2\u30fc\u30c9" + desktopMode;
            throw new Exception(msg);
        }
    }

    @Override
    public void aboutAction() throws Exception {
    }

    @Override
    protected void createUserMenu(MenuBar menuBar) throws Exception {
    }

    @Override
    public void exitAction() throws Exception {
        if (HfxClientUtil.confirmExit((Window)this.stage)) {
            this.stage.close();
        }
    }

    public void show() throws Exception {
        if (this.stage != null) {
            this.stage.show();
            this.stage.toFront();
            return;
        }
        this.createStage();
        this.init();
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                BcLogUtil.debug("Window shown.");
                try {
                    XsodController.getInstance().loadResource();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                if (!HfxClientUtil.confirmExit((Window)XsodDesktop.this.stage)) {
                    ev.consume();
                }
            }
        });
        this.stage.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                AfbApplication.getInstance().exit();
            }
        });
        this.stage.iconifiedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> prop, Boolean oldValue, Boolean newValue) {
            }
        });
        this.stage.setTitle(XsodWords.getInstance().\u30bb\u30eb\u30d5\u30aa\u30fc\u30c0\u30fc\u30b7\u30b9\u30c6\u30e0.toString());
        FxImageHelper.setStageIcon(this.stage);
        this.stage.setWidth(XsodUiFactory.getInstance().windowWidth);
        this.stage.setHeight(XsodUiFactory.getInstance().windowHeight);
        this.stage.centerOnScreen();
        this.stage.show();
    }

    public static void show2() throws Exception {
        XsodDesktop.getInstance().show();
    }

    /* synthetic */ XsodDesktop(XsodDesktop xsodDesktop) {
        this();
    }

    private static final class SingletonHolder {
        private static final XsodDesktop instance = new XsodDesktop(null);

        private SingletonHolder() {
        }
    }
}

