/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.fx;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.net.BcNetUtil;
import jp.co.extreme.base.util.BcCompareUtil;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.tree.FxTreeCell;
import jp.co.extreme.fx.tree.FxTreeItem;
import jp.co.extreme.fx.tree.FxTreeUtil;
import jp.co.extreme.fx.tree.FxTreeView;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.viewer.FxxUrlEvent;
import jp.co.extreme.module.xfil.common.XfilUtil;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.module.xfil.model.XfilUriEntityWrap;

public class XfilFileTreeView
extends FxTreeView {
    FxTreeItem rootTreeItem = new FxTreeItem();
    FxTreeItem myPcTreeItem = new FxTreeItem();
    public static String dummyUrl;
    InnerComparator innerComparator = new InnerComparator();
    TreeItem treeItem1;
    TreeItem treeItem2;
    EventHandler<? super FxxUrlEvent> eventHandler;
    private volatile boolean stop = false;

    public XfilFileTreeView() throws Exception {
        dummyUrl = "dummy";
        this.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.setRoot(this.rootTreeItem);
        this.setShowRoot(false);
        this.rootTreeItem.setExpanded(true);
        this.setFiles_default();
    }

    protected TreeCell createTreeCell() throws Exception {
        InnerTreeCell treeCell = new InnerTreeCell();
        treeCell.setOnDragDetected(ev -> {
            TreeItem treeItem = treeCell.getTreeItem();
            if (treeItem != null && treeItem.isLeaf()) {
                Dragboard dragboard = treeCell.startDragAndDrop(new TransferMode[]{TransferMode.COPY});
                ClipboardContent clipboardContent = new ClipboardContent();
                File file = (File)treeCell.getTreeItem().getValue();
                BcLogUtil.debug("setOnDragDetected:file=" + file.getName());
                List<File> filesList = Arrays.asList(file);
                clipboardContent.putFiles(filesList);
                dragboard.setContent((Map)clipboardContent);
                ev.consume();
            }
        });
        treeCell.setOnDragEntered(ev -> {
            TreeItem treeItem = treeCell.getTreeItem();
            if (treeItem != null && !treeItem.isLeaf() && ev.getGestureSource() != treeCell) {
                ev.getDragboard().hasFiles();
            }
            ev.consume();
        });
        treeCell.setOnDragExited(ev -> ev.consume());
        treeCell.setOnDragOver(ev -> {
            ev.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            ev.consume();
        });
        treeCell.setOnDragDropped(ev -> {
            Dragboard dragboard = ev.getDragboard();
            if (dragboard.hasString()) {
                BcLogUtil.debug("setOnDragDropped:dragboard.getString()=" + dragboard.getString());
            }
            ev.setDropCompleted(dragboard.hasString());
            ev.consume();
        });
        return treeCell;
    }

    protected void treeItemExpanded(TreeItem.TreeModificationEvent ev) throws Exception {
        super.treeItemExpanded(ev);
        TreeItem treeItem = ev.getTreeItem();
        this.treeItem2 = this.treeItem1;
        BcLogUtil.debug("---- treeItemExpanded:treeItem=" + treeItem.getValue());
        treeItem.setGraphic((Node)FxImageHelper.createImageView_icon("deep_blue/folder_opened_256x256.png"));
        if (this.hasDimmyChild(treeItem)) {
            File file = this.getFile(treeItem);
            this.setFiles_L2(file.toPath(), treeItem);
        }
    }

    protected void treeItemCollapsed(TreeItem.TreeModificationEvent ev) throws Exception {
        super.treeItemCollapsed(ev);
        TreeItem treeItem = ev.getTreeItem();
        treeItem.setGraphic((Node)FxImageHelper.createImageView_icon("deep_blue/folder_closed_256x256.png"));
    }

    protected void selectionChanged(ObservableValue observable, TreeItem oldTreeItem, TreeItem newTreeItem) throws Exception {
        if (newTreeItem != null && this.treeItem1 != newTreeItem) {
            this.treeItem1 = newTreeItem;
            if (this.eventHandler != null) {
                BcLogUtil.debug("handle!");
                FxxUrlEvent urlEvent = new FxxUrlEvent(newTreeItem, null, FxxUrlEvent.SELECTED);
                this.eventHandler.handle(urlEvent);
            }
        }
    }

    public void setEventHandler(EventHandler<? super FxxUrlEvent> eventHandler) throws Exception {
        this.eventHandler = eventHandler;
    }

    protected void setFiles_default() throws Exception {
        XfilUriEntityWrap uriEntityWrap = new XfilUriEntityWrap();
        uriEntityWrap.uriEntity = new XfilUriEntity();
        uriEntityWrap.uriEntity.name = "MyPC";
        this.myPcTreeItem.setValue(uriEntityWrap);
        this.rootTreeItem.getChildren().add((Object)this.myPcTreeItem);
        File[] files = File.listRoots();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            try {
                this.addDriveDir(file);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            ++i;
        }
        this.myPcTreeItem.setExpanded(true);
    }

    public void addDriveDir(File file) throws Exception {
        Path path = Paths.get(file.getPath(), new String[0]);
        URI uri = file.toURI();
        XfilUriEntityWrap uriEntityWrap = XfilUtil.createUriEntityWrap(uri, true);
        String[] res = BcFileUtil.separatePath(file.getPath());
        uriEntityWrap.uriEntity.name = res[0];
        FxTreeItem treeItem = new FxTreeItem();
        treeItem.setValue(uriEntityWrap);
        treeItem.setGraphic((Node)FxImageHelper.createImageView_icon("hard_drive_64x64.png"));
        this.myPcTreeItem.getChildren().add(treeItem);
        if (file.isDirectory()) {
            this.setFiles_L2(file.toPath(), treeItem);
        }
    }

    protected void setFiles_L2(Path path, final TreeItem parentTreeItem) throws Exception {
        BcLogUtil.debug("setFiles_L2:#2 path=" + XfilUtil.createInfo(path));
        Stream<Path> pathStream = Files.list(path);
        this.getSelectionModel().clearSelection();
        parentTreeItem.getChildren().clear();
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return;
        }
        final List pathList = pathStream.sorted(Comparator.comparing(Path::toString)).collect(Collectors.toList());
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < pathList.size()) {
                    Path subPath = (Path)pathList.get(i);
                    if (Files.isDirectory(subPath, new LinkOption[0])) {
                        try {
                            XfilUriEntityWrap uriEntityWrap = XfilUtil.createUriEntityWrap(subPath.toFile().toURI(), true);
                            FxTreeItem fxTreeItem = XfilFileTreeView.this.createTreeItem(parentTreeItem, uriEntityWrap);
                        }
                        catch (Exception ex) {
                            XfilFileTreeView.this.handleException(ex);
                        }
                    }
                    ++i;
                }
            }
        });
    }

    protected FxTreeItem createTreeItem(TreeItem parentTreeItem, XfilUriEntityWrap uriEntityWrap) throws Exception {
        FxTreeItem treeItem = new FxTreeItem();
        treeItem.setValue(uriEntityWrap);
        treeItem.setGraphic((Node)FxImageHelper.createImageView_icon("deep_blue/folder_closed_256x256.png"));
        parentTreeItem.getChildren().add(treeItem);
        XfilUriEntityWrap uriEntityWrapDummy = new XfilUriEntityWrap();
        uriEntityWrapDummy.uriEntity = new XfilUriEntity();
        uriEntityWrapDummy.uriEntity.name = dummyUrl;
        uriEntityWrapDummy.uriStr = dummyUrl;
        FxTreeItem dummyTreeItem = new FxTreeItem();
        dummyTreeItem.setValue(uriEntityWrapDummy);
        treeItem.getChildren().add(dummyTreeItem);
        return treeItem;
    }

    protected File getFile(TreeItem treeItem) throws Exception {
        XfilUriEntityWrap uriEntityWrap = (XfilUriEntityWrap)treeItem.getValue();
        Path path = BcNetUtil.urlToPath(uriEntityWrap.uri);
        File file = path.toFile();
        return file;
    }

    protected boolean isDimmy(TreeItem treeItem) throws Exception {
        XfilUriEntityWrap uriEntityWrap = (XfilUriEntityWrap)treeItem.getValue();
        return dummyUrl.equals(uriEntityWrap.uriStr);
    }

    protected boolean hasDimmyChild(TreeItem treeItem) throws Exception {
        if (treeItem.getChildren().size() == 1) {
            TreeItem childTreeItem = (TreeItem)treeItem.getChildren().get(0);
            return this.isDimmy(childTreeItem);
        }
        return false;
    }

    protected void crearDimmyChild(TreeItem treeItem) throws Exception {
        if (this.hasDimmyChild(treeItem)) {
            treeItem.getChildren().clear();
        }
    }

    public void setUri(URI uri) throws Exception {
        BcLogUtil.debug("----- setUrl:uri=" + uri);
        if (!BcNetUtil.isFile(uri)) {
            return;
        }
        Path path = BcNetUtil.urlToPath(uri);
        if (!Files.exists(path, new LinkOption[0])) {
            BcLogUtil.debug("\u5b58\u5728\u3057\u307e\u305b\u3093\u3002" + path);
            return;
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return;
        }
        if (!Files.isReadable(path)) {
            return;
        }
        List<Path> pathList = BcFileUtil.toPathList(path);
        TreeItem treeItem = FxTreeUtil.findByValue_3(this.myPcTreeItem, pathList, this.innerComparator);
        if (treeItem == null) {
            Path parentPath = path.getParent();
            List<Path> parentPathList = BcFileUtil.toPathList(parentPath);
            TreeItem parentTreeItem = FxTreeUtil.findByValue_3(this.myPcTreeItem, parentPathList, this.innerComparator);
            if (parentTreeItem == null) {
                parentTreeItem = new TreeItem();
                this.myPcTreeItem.getChildren().add((Object)parentTreeItem);
            }
            if (!this.hasDimmyChild(parentTreeItem)) {
                XfilUriEntityWrap uriEntityWrap = XfilUtil.createUriEntityWrap(uri, true);
                treeItem = this.createTreeItem(parentTreeItem, uriEntityWrap);
            }
            if (!parentTreeItem.isExpanded()) {
                parentTreeItem.setExpanded(true);
            }
        }
        this.getSelectionModel().clearSelection();
        this.getSelectionModel().select((Object)treeItem);
    }

    public void test() throws Exception {
        FileSystem fileSystem = FileSystems.getDefault();
        Path path = fileSystem.getPath("C:/temp", new String[0]);
        WatchService watchService = fileSystem.newWatchService();
        WatchEvent.Kind[] events = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE};
        path.register(watchService, events);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                XfilFileTreeView.this.stop = false;
            }
        });
        while (!Thread.currentThread().isInterrupted() && !this.stop) {
            System.out.println("Watching...");
            try {
                WatchKey watchKey = watchService.take();
                String watchableName = watchKey.watchable().toString();
                System.out.println("Watchable : " + watchableName);
                if (!watchKey.isValid()) continue;
                for (WatchEvent<?> ev : watchKey.pollEvents()) {
                    BcLogUtil.debug("ev.kind()=" + ev.kind());
                    if (ev.kind() == StandardWatchEventKinds.OVERFLOW) continue;
                    System.out.println("\u5bfe\u8c61\u30b3\u30f3\u30c6\u30f3\u30c4 : " + ev.context());
                    System.out.println("\u30a4\u30d9\u30f3\u30c8\u56de\u6570 : " + ev.count());
                    Path targetPath = FileSystems.getDefault().getPath(String.valueOf(watchableName) + "\\" + ev.context(), new String[0]);
                    BcLogUtil.debug("targetPath=" + targetPath);
                    XfilFileTreeView.processContent(targetPath, ev);
                    System.out.println();
                }
                if (watchKey.reset()) continue;
                System.out.println("The watch key might be invalid.");
                break;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        System.out.println("See you.");
    }

    private static final void processContent(Path targetPath, WatchEvent<?> watchEvent) {
        block13: {
            if (Files.isRegularFile(targetPath, new LinkOption[0]) && watchEvent.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
                try {
                    if (Files.size(targetPath) <= 0L) break block13;
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (BufferedReader reader = Files.newBufferedReader(targetPath, Charset.defaultCharset());){
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            System.out.println(line);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public class InnerComparator
    implements Comparator {
        public int compare(Object value1, Object value2) {
            try {
                TreeItem treeItem = (TreeItem)value1;
                XfilUriEntityWrap uriEntityWrap = (XfilUriEntityWrap)treeItem.getValue();
                String str1 = BcFileUtil.toCommonPath(uriEntityWrap.uri.getPath().toString());
                str1 = BcStringUtil.replace((CharSequence)str1, "//", "/").toString();
                str1 = BcFileUtil.deleteEndSlash(str1);
                String str2 = BcFileUtil.toCommonPath(value2.toString());
                str2 = BcFileUtil.deleteEndSlash(str2);
                if (str1.equals(str2)) {
                    return BcCompareUtil.Comparison.equals.value;
                }
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            return BcCompareUtil.Comparison.big.value;
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }
    }

    class InnerTreeCell
    extends FxTreeCell {
        @Override
        public String getItemText() {
            FxTreeItem treeItem = (FxTreeItem)this.getTreeItem();
            Object value = treeItem.getValue();
            String text = this.getItemText(value);
            return text;
        }

        public String getItemText(Object value) {
            String text = null;
            XfilUriEntityWrap uriEntityWrap = (XfilUriEntityWrap)value;
            XfilUriEntity uriEntity = uriEntityWrap.uriEntity;
            text = uriEntity.name;
            return text;
        }
    }
}

