/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.common;

import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.etc.model.EtcWord;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class XdtsWordXmlParser
extends DefaultHandler {
    public List<EtcWord> wordList;
    protected EtcWord word;
    protected StringBuilder sb = new StringBuilder();

    @Override
    public void startDocument() {
        this.wordList = new ArrayList<EtcWord>();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.sb.delete(0, this.sb.length());
        if (qName.equals("word")) {
            this.word = new EtcWord();
            this.word.code = attributes.getValue("code");
        } else if (qName.equals("value")) {
            this.word.lang = attributes.getValue("lang");
        }
    }

    @Override
    public void characters(char[] ch, int offset, int length) {
        String str = new String(ch, offset, length);
        this.sb.append(str);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.endsWith("value")) {
            BcLogUtil.debug("word.code=" + this.word.code + " value=" + this.sb);
            this.word.value = this.sb.toString();
            this.wordList.add(this.word);
        }
    }

    @Override
    public void endDocument() {
    }
}

