/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.impt.stub;

import java.io.File;
import java.util.List;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.module.impt.common.ImptWords;
import jp.co.extreme.module.impt.model.ImptDefineIndex;
import jp.co.extreme.module.impt.model.ImptImportContext;
import jp.co.extreme.module.impt.model.ImptImportDefine;
import jp.co.extreme.module.impt.rmo.ImptDefineIndexRMO;
import jp.co.extreme.module.impt.rmo.ImptImportContextRMO;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.rmi.model.RmiRespons;
import jp.co.extreme.scf.client.ScfClientContainer;
import jp.co.extreme.scf5.model.ScfFileResource;

public class ImptGeneralStub {
    private ImptGeneralStub() {
    }

    public static ImptGeneralStub getInstance() {
        return SingletonHolder.instance;
    }

    public int putDefineIndex(ImptDefineIndex defineIndex, String fileName) throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(ImptDefineIndexRMO.class.getName());
        rmiReq.setMethodName("putDefineIndex");
        rmiReq.addData(defineIndex);
        rmiReq.addData(fileName);
        RmiRespons rmiRes = ScfClientContainer.getInstance().getAgent().invoke(rmiReq);
        return (Integer)rmiRes.getData();
    }

    public int deleteDefineIndex(int defineIndexId) throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(ImptDefineIndexRMO.class.getName());
        rmiReq.setMethodName("deleteDefineIndex");
        rmiReq.addData(defineIndexId);
        RmiRespons rmiRes = ScfClientContainer.getInstance().getAgent().invoke(rmiReq);
        return (Integer)rmiRes.getData();
    }

    public ImptDefineIndex getDefineIndex(int defineIndexId) throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(ImptDefineIndexRMO.class.getName());
        rmiReq.setMethodName("getDefineIndex");
        rmiReq.addData(defineIndexId);
        RmiRespons rmiRes = ScfClientContainer.getInstance().getAgent().invoke(rmiReq);
        return (ImptDefineIndex)rmiRes.getData();
    }

    public List<ImptDefineIndex> getDefineIndexList() throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(ImptDefineIndexRMO.class.getName());
        rmiReq.setMethodName("getDefineIndexList");
        RmiRespons rmiRes = ScfClientContainer.getInstance().getAgent().invoke(rmiReq);
        List importModeList = (List)rmiRes.getData();
        ImptDefineIndex defineIndex = new ImptDefineIndex();
        defineIndex.name = String.valueOf(ImptWords.getInstance().\u30c7\u30fc\u30bf\u53d6\u8fbc\u5b9a\u7fa9) + "\u306b\u3088\u308b\u6307\u5b9a";
        importModeList.add(0, defineIndex);
        return importModeList;
    }

    public ScfFileResource getFileResource(int fileResourceId) throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(ImptDefineIndexRMO.class.getName());
        rmiReq.setMethodName("getFileResource");
        rmiReq.addData(fileResourceId);
        RmiRespons rmiRes = ScfClientContainer.getInstance().getAgent().invoke(rmiReq);
        ScfFileResource fileResource = (ScfFileResource)rmiRes.getData();
        return fileResource;
    }

    public ImptImportDefine getImportDefine(int fileResourceId) throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(ImptDefineIndexRMO.class.getName());
        rmiReq.setMethodName("getImportDefine");
        rmiReq.addData(fileResourceId);
        RmiRespons rmiRes = ScfClientContainer.getInstance().getAgent().invoke(rmiReq);
        ImptImportDefine importDefine3 = (ImptImportDefine)rmiRes.getData();
        return importDefine3;
    }

    public int deleteImportContext(int importContextId) throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(ImptImportContextRMO.class.getName());
        rmiReq.setMethodName("deleteImportContext");
        rmiReq.addData(importContextId);
        RmiRespons rmiRes = ScfClientContainer.getInstance().getAgent().invoke(rmiReq);
        return (Integer)rmiRes.getData();
    }

    public ImptImportContext getImportContextByLastModified(File file) throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(ImptImportContextRMO.class.getName());
        rmiReq.setMethodName("getImportContextByLastModified");
        rmiReq.addData(BcTimeUtil.toCalendar(file.lastModified()));
        rmiReq.addData(file.length());
        RmiRespons rmiRes = ScfClientContainer.getInstance().getAgent().invoke(rmiReq);
        ImptImportContext importContext = (ImptImportContext)rmiRes.getData();
        return importContext;
    }

    public ImptImportContext getImportContextNewest() throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(ImptImportContextRMO.class.getName());
        rmiReq.setMethodName("getImportContextNewest");
        RmiRespons rmiRes = ScfClientContainer.getInstance().getAgent().invoke(rmiReq);
        ImptImportContext importContext = (ImptImportContext)rmiRes.getData();
        return importContext;
    }

    /* synthetic */ ImptGeneralStub(ImptGeneralStub imptGeneralStub) {
        this();
    }

    private static final class SingletonHolder {
        private static final ImptGeneralStub instance = new ImptGeneralStub(null);

        private SingletonHolder() {
        }
    }
}

