/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.html.util;

import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.html.parser.HtmlParseEventHandler;
import jp.co.extreme.html.parser.HtmlParser;

public class HtmlToPlain
extends BcLoggableObject
implements HtmlParseEventHandler {
    protected HtmlParser htmlParser = new HtmlParser();
    protected StringBuilder sb;
    protected List<String> textList;

    public HtmlToPlain() {
        this.htmlParser.setParseEventHandler(this);
    }

    public List<String> toTextList(String src) throws Exception {
        this.textList = new ArrayList<String>();
        this.htmlParser.parse(src);
        return this.textList;
    }

    public StringBuilder toPlain(String src) throws Exception {
        this.sb = new StringBuilder();
        this.htmlParser.parse(src);
        return this.sb;
    }

    @Override
    public void handleStartTag(String tagName, int pos) {
    }

    @Override
    public void handleEndTag(String tagName, int pos) {
    }

    @Override
    public void handleText(String str, int pos) {
        if (BcStringUtil.isEmpty(str)) {
            return;
        }
        str = str.replace(BcStringUtil.LINE_FEED_STR, "");
        if (BcStringUtil.isEmpty(str = str.replace(BcStringUtil.CARRIAGE_RETURN_STR, ""))) {
            return;
        }
        if (this.textList != null) {
            this.textList.add(str);
        }
        if (this.sb != null) {
            this.sb.append(str);
        }
    }

    @Override
    public void attributeName(String attributeName, int pos) throws Exception {
    }

    @Override
    public void attributeValue(String attributeValue, int pos) throws Exception {
    }

    @Override
    public void parseEnd() {
    }
}

