/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.io;

import java.io.File;
import java.io.FileFilter;
import jp.co.extreme.base.log.BcLoggableObject;

public class BcFileCircuiter
extends BcLoggableObject {
    protected FileFilter fileFilter;
    private boolean isStop;
    private int dirCount;
    private int fileCount;

    public FileFilter getFileFilter() throws Exception {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter fileFilter) throws Exception {
        this.fileFilter = fileFilter;
    }

    public synchronized void start(File file) throws Exception {
        this.isStop = false;
        this.circuitFile(file);
    }

    public void stop() throws Exception {
        this.isStop = true;
    }

    protected void circuitFile(File file) throws Exception {
        boolean accept;
        if (this.isStop) {
            return;
        }
        if (this.fileFilter != null && !(accept = this.fileFilter.accept(file))) {
            return;
        }
        if (file.isDirectory()) {
            ++this.dirCount;
        } else {
            ++this.fileCount;
        }
        this.fileWasFound(file, this.dirCount, this.fileCount);
        if (this.isStop) {
            return;
        }
        if (file.isDirectory()) {
            File[] chiledFiles = file.listFiles();
            if (chiledFiles != null) {
                int i = 0;
                while (i < chiledFiles.length) {
                    if (this.isStop) {
                        return;
                    }
                    this.circuitFile(chiledFiles[i]);
                    ++i;
                }
            } else {
                this.getLogger().debug("startCircuit:err file=" + file.getPath());
            }
        }
    }

    public void fileWasFound(File file, int dirCount, int fileCount) throws Exception {
    }
}

