/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import sun.misc.Unsafe;

public class CompletableFuture<T>
implements Future<T>,
CompletionStage<T> {
    volatile Object result;
    volatile Completion stack;
    static final AltResult NIL = new AltResult(null);
    private static final boolean useCommonPool = ForkJoinPool.getCommonPoolParallelism() > 1;
    private static final Executor asyncPool = useCommonPool ? ForkJoinPool.commonPool() : new ThreadPerTaskExecutor();
    static final int SYNC = 0;
    static final int ASYNC = 1;
    static final int NESTED = -1;
    private static final int SPINS = Runtime.getRuntime().availableProcessors() > 1 ? 256 : 0;
    private static final Unsafe UNSAFE;
    private static final long RESULT;
    private static final long STACK;
    private static final long NEXT;

    final boolean internalComplete(Object object) {
        return UNSAFE.compareAndSwapObject(this, RESULT, null, object);
    }

    final boolean casStack(Completion completion, Completion completion2) {
        return UNSAFE.compareAndSwapObject(this, STACK, completion, completion2);
    }

    final boolean tryPushStack(Completion completion) {
        Completion completion2 = this.stack;
        CompletableFuture.lazySetNext(completion, completion2);
        return UNSAFE.compareAndSwapObject(this, STACK, completion2, completion);
    }

    final void pushStack(Completion completion) {
        while (!this.tryPushStack(completion)) {
        }
    }

    final boolean completeNull() {
        return UNSAFE.compareAndSwapObject(this, RESULT, null, NIL);
    }

    final Object encodeValue(T t) {
        return t == null ? NIL : t;
    }

    final boolean completeValue(T t) {
        return UNSAFE.compareAndSwapObject(this, RESULT, null, t == null ? NIL : t);
    }

    static AltResult encodeThrowable(Throwable throwable) {
        return new AltResult(throwable instanceof CompletionException ? throwable : new CompletionException(throwable));
    }

    final boolean completeThrowable(Throwable throwable) {
        return UNSAFE.compareAndSwapObject(this, RESULT, null, CompletableFuture.encodeThrowable(throwable));
    }

    static Object encodeThrowable(Throwable throwable, Object object) {
        if (!(throwable instanceof CompletionException)) {
            throwable = new CompletionException(throwable);
        } else if (object instanceof AltResult && throwable == ((AltResult)object).ex) {
            return object;
        }
        return new AltResult(throwable);
    }

    final boolean completeThrowable(Throwable throwable, Object object) {
        return UNSAFE.compareAndSwapObject(this, RESULT, null, CompletableFuture.encodeThrowable(throwable, object));
    }

    Object encodeOutcome(T t, Throwable throwable) {
        return throwable == null ? (t == null ? NIL : t) : CompletableFuture.encodeThrowable(throwable);
    }

    static Object encodeRelay(Object object) {
        Throwable throwable;
        return object instanceof AltResult && (throwable = ((AltResult)object).ex) != null && !(throwable instanceof CompletionException) ? new AltResult(new CompletionException(throwable)) : object;
    }

    final boolean completeRelay(Object object) {
        return UNSAFE.compareAndSwapObject(this, RESULT, null, CompletableFuture.encodeRelay(object));
    }

    private static <T> T reportGet(Object object) throws InterruptedException, ExecutionException {
        if (object == null) {
            throw new InterruptedException();
        }
        if (object instanceof AltResult) {
            Throwable throwable;
            Throwable throwable2 = ((AltResult)object).ex;
            if (throwable2 == null) {
                return null;
            }
            if (throwable2 instanceof CancellationException) {
                throw (CancellationException)throwable2;
            }
            if (throwable2 instanceof CompletionException && (throwable = throwable2.getCause()) != null) {
                throwable2 = throwable;
            }
            throw new ExecutionException(throwable2);
        }
        Object object2 = object;
        return (T)object2;
    }

    private static <T> T reportJoin(Object object) {
        if (object instanceof AltResult) {
            Throwable throwable = ((AltResult)object).ex;
            if (throwable == null) {
                return null;
            }
            if (throwable instanceof CancellationException) {
                throw (CancellationException)throwable;
            }
            if (throwable instanceof CompletionException) {
                throw (CompletionException)throwable;
            }
            throw new CompletionException(throwable);
        }
        Object object2 = object;
        return (T)object2;
    }

    static Executor screenExecutor(Executor executor) {
        if (!useCommonPool && executor == ForkJoinPool.commonPool()) {
            return asyncPool;
        }
        if (executor == null) {
            throw new NullPointerException();
        }
        return executor;
    }

    static void lazySetNext(Completion completion, Completion completion2) {
        UNSAFE.putOrderedObject(completion, NEXT, completion2);
    }

    final void postComplete() {
        CompletableFuture<?> completableFuture = this;
        while (true) {
            CompletableFuture<?> completableFuture2;
            Completion completion;
            Completion completion2;
            if ((completion2 = completableFuture.stack) == null) {
                if (completableFuture == this) break;
                completableFuture = this;
                completion2 = completableFuture.stack;
                if (completion2 == null) break;
            }
            if (!completableFuture.casStack(completion2, completion = completion2.next)) continue;
            if (completion != null) {
                if (completableFuture != this) {
                    this.pushStack(completion2);
                    continue;
                }
                completion2.next = null;
            }
            completableFuture = (completableFuture2 = completion2.tryFire(-1)) == null ? this : completableFuture2;
        }
    }

    final void cleanStack() {
        Completion completion = null;
        Completion completion2 = this.stack;
        while (completion2 != null) {
            Completion completion3 = completion2.next;
            if (completion2.isLive()) {
                completion = completion2;
                completion2 = completion3;
                continue;
            }
            if (completion == null) {
                this.casStack(completion2, completion3);
                completion2 = this.stack;
                continue;
            }
            completion.next = completion3;
            if (completion.isLive()) {
                completion2 = completion3;
                continue;
            }
            completion = null;
            completion2 = this.stack;
        }
    }

    final void push(UniCompletion<?, ?> uniCompletion) {
        if (uniCompletion != null) {
            while (this.result == null && !this.tryPushStack(uniCompletion)) {
                CompletableFuture.lazySetNext(uniCompletion, null);
            }
        }
    }

    final CompletableFuture<T> postFire(CompletableFuture<?> completableFuture, int n) {
        if (completableFuture != null && completableFuture.stack != null) {
            if (completableFuture.result == null) {
                completableFuture.cleanStack();
            } else if (n >= 0) {
                completableFuture.postComplete();
            }
        }
        if (this.result != null && this.stack != null) {
            if (n < 0) {
                return this;
            }
            this.postComplete();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final <S> boolean uniApply(CompletableFuture<S> completableFuture, Function<? super S, ? extends T> function, UniApply<S, T> uniApply) {
        Object object;
        if (completableFuture == null || (object = completableFuture.result) == null || function == null) {
            return false;
        }
        if (this.result != null) return true;
        if (object instanceof AltResult) {
            Throwable throwable = ((AltResult)object).ex;
            if (throwable != null) {
                this.completeThrowable(throwable, object);
                return true;
            }
            object = null;
        }
        try {
            if (uniApply != null && !uniApply.claim()) {
                return false;
            }
            Object object2 = object;
            this.completeValue(function.apply(object2));
            return true;
        }
        catch (Throwable throwable) {
            this.completeThrowable(throwable);
        }
        return true;
    }

    private <V> CompletableFuture<V> uniApplyStage(Executor executor, Function<? super T, ? extends V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        CompletableFuture<? extends V> completableFuture = new CompletableFuture<V>();
        if (executor != null || !completableFuture.uniApply(this, function, null)) {
            UniApply<T, V> uniApply = new UniApply<T, V>(executor, completableFuture, this, function);
            this.push(uniApply);
            uniApply.tryFire(0);
        }
        return completableFuture;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final <S> boolean uniAccept(CompletableFuture<S> completableFuture, Consumer<? super S> consumer, UniAccept<S> uniAccept) {
        Object object;
        if (completableFuture == null || (object = completableFuture.result) == null || consumer == null) {
            return false;
        }
        if (this.result != null) return true;
        if (object instanceof AltResult) {
            Throwable throwable = ((AltResult)object).ex;
            if (throwable != null) {
                this.completeThrowable(throwable, object);
                return true;
            }
            object = null;
        }
        try {
            if (uniAccept != null && !uniAccept.claim()) {
                return false;
            }
            Object object2 = object;
            consumer.accept(object2);
            this.completeNull();
            return true;
        }
        catch (Throwable throwable) {
            this.completeThrowable(throwable);
        }
        return true;
    }

    private CompletableFuture<Void> uniAcceptStage(Executor executor, Consumer<? super T> consumer) {
        if (consumer == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        if (executor != null || !completableFuture.uniAccept(this, consumer, null)) {
            UniAccept<T> uniAccept = new UniAccept<T>(executor, completableFuture, this, consumer);
            this.push(uniAccept);
            uniAccept.tryFire(0);
        }
        return completableFuture;
    }

    final boolean uniRun(CompletableFuture<?> completableFuture, Runnable runnable, UniRun<?> uniRun) {
        Object object;
        if (completableFuture == null || (object = completableFuture.result) == null || runnable == null) {
            return false;
        }
        if (this.result == null) {
            Throwable throwable;
            if (object instanceof AltResult && (throwable = ((AltResult)object).ex) != null) {
                this.completeThrowable(throwable, object);
            } else {
                try {
                    if (uniRun != null && !uniRun.claim()) {
                        return false;
                    }
                    runnable.run();
                    this.completeNull();
                }
                catch (Throwable throwable2) {
                    this.completeThrowable(throwable2);
                }
            }
        }
        return true;
    }

    private CompletableFuture<Void> uniRunStage(Executor executor, Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        if (executor != null || !completableFuture.uniRun(this, runnable, null)) {
            UniRun uniRun = new UniRun(executor, completableFuture, this, runnable);
            this.push(uniRun);
            uniRun.tryFire(0);
        }
        return completableFuture;
    }

    final boolean uniWhenComplete(CompletableFuture<T> completableFuture, BiConsumer<? super T, ? super Throwable> biConsumer, UniWhenComplete<T> uniWhenComplete) {
        Object object;
        Throwable throwable = null;
        if (completableFuture == null || (object = completableFuture.result) == null || biConsumer == null) {
            return false;
        }
        if (this.result == null) {
            block8: {
                try {
                    Object object2;
                    if (uniWhenComplete != null && !uniWhenComplete.claim()) {
                        return false;
                    }
                    if (object instanceof AltResult) {
                        throwable = ((AltResult)object).ex;
                        object2 = null;
                    } else {
                        Object object3;
                        object2 = object3 = object;
                    }
                    biConsumer.accept(object2, throwable);
                    if (throwable == null) {
                        this.internalComplete(object);
                        return true;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable != null) break block8;
                    throwable = throwable2;
                }
            }
            this.completeThrowable(throwable, object);
        }
        return true;
    }

    private CompletableFuture<T> uniWhenCompleteStage(Executor executor, BiConsumer<? super T, ? super Throwable> biConsumer) {
        if (biConsumer == null) {
            throw new NullPointerException();
        }
        CompletableFuture<? super T> completableFuture = new CompletableFuture<T>();
        if (executor != null || !completableFuture.uniWhenComplete(this, biConsumer, null)) {
            UniWhenComplete<T> uniWhenComplete = new UniWhenComplete<T>(executor, completableFuture, this, biConsumer);
            this.push(uniWhenComplete);
            uniWhenComplete.tryFire(0);
        }
        return completableFuture;
    }

    final <S> boolean uniHandle(CompletableFuture<S> completableFuture, BiFunction<? super S, Throwable, ? extends T> biFunction, UniHandle<S, T> uniHandle) {
        Object object;
        if (completableFuture == null || (object = completableFuture.result) == null || biFunction == null) {
            return false;
        }
        if (this.result == null) {
            try {
                Object object2;
                Throwable throwable;
                if (uniHandle != null && !uniHandle.claim()) {
                    return false;
                }
                if (object instanceof AltResult) {
                    throwable = ((AltResult)object).ex;
                    object2 = null;
                } else {
                    Object object3;
                    throwable = null;
                    object2 = object3 = object;
                }
                this.completeValue(biFunction.apply(object2, throwable));
            }
            catch (Throwable throwable) {
                this.completeThrowable(throwable);
            }
        }
        return true;
    }

    private <V> CompletableFuture<V> uniHandleStage(Executor executor, BiFunction<? super T, Throwable, ? extends V> biFunction) {
        if (biFunction == null) {
            throw new NullPointerException();
        }
        CompletableFuture<? extends V> completableFuture = new CompletableFuture<V>();
        if (executor != null || !completableFuture.uniHandle(this, biFunction, null)) {
            UniHandle<T, V> uniHandle = new UniHandle<T, V>(executor, completableFuture, this, biFunction);
            this.push(uniHandle);
            uniHandle.tryFire(0);
        }
        return completableFuture;
    }

    final boolean uniExceptionally(CompletableFuture<T> completableFuture, Function<? super Throwable, ? extends T> function, UniExceptionally<T> uniExceptionally) {
        Object object;
        if (completableFuture == null || (object = completableFuture.result) == null || function == null) {
            return false;
        }
        if (this.result == null) {
            try {
                Throwable throwable;
                if (object instanceof AltResult && (throwable = ((AltResult)object).ex) != null) {
                    if (uniExceptionally != null && !uniExceptionally.claim()) {
                        return false;
                    }
                    this.completeValue(function.apply(throwable));
                } else {
                    this.internalComplete(object);
                }
            }
            catch (Throwable throwable) {
                this.completeThrowable(throwable);
            }
        }
        return true;
    }

    private CompletableFuture<T> uniExceptionallyStage(Function<Throwable, ? extends T> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        CompletableFuture<? extends T> completableFuture = new CompletableFuture<T>();
        if (!completableFuture.uniExceptionally(this, function, null)) {
            UniExceptionally<T> uniExceptionally = new UniExceptionally<T>(completableFuture, this, function);
            this.push(uniExceptionally);
            uniExceptionally.tryFire(0);
        }
        return completableFuture;
    }

    final boolean uniRelay(CompletableFuture<T> completableFuture) {
        Object object;
        if (completableFuture == null || (object = completableFuture.result) == null) {
            return false;
        }
        if (this.result == null) {
            this.completeRelay(object);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final <S> boolean uniCompose(CompletableFuture<S> completableFuture, Function<? super S, ? extends CompletionStage<T>> function, UniCompose<S, T> uniCompose) {
        Object object;
        if (completableFuture == null || (object = completableFuture.result) == null || function == null) {
            return false;
        }
        if (this.result != null) return true;
        if (object instanceof AltResult) {
            Throwable throwable = ((AltResult)object).ex;
            if (throwable != null) {
                this.completeThrowable(throwable, object);
                return true;
            }
            object = null;
        }
        try {
            if (uniCompose != null && !uniCompose.claim()) {
                return false;
            }
            Object object2 = object;
            CompletableFuture<Object> completableFuture2 = function.apply(object2).toCompletableFuture();
            if (completableFuture2.result != null && this.uniRelay(completableFuture2)) return true;
            UniRelay<Object> uniRelay = new UniRelay<Object>(this, completableFuture2);
            completableFuture2.push(uniRelay);
            uniRelay.tryFire(0);
            if (this.result != null) return true;
            return false;
        }
        catch (Throwable throwable) {
            this.completeThrowable(throwable);
        }
        return true;
    }

    private <V> CompletableFuture<V> uniComposeStage(Executor executor, Function<? super T, ? extends CompletionStage<V>> function) {
        Object object;
        if (function == null) {
            throw new NullPointerException();
        }
        if (executor == null && (object = this.result) != null) {
            if (object instanceof AltResult) {
                Throwable throwable = ((AltResult)object).ex;
                if (throwable != null) {
                    return new CompletableFuture<T>(CompletableFuture.encodeThrowable(throwable, object));
                }
                object = null;
            }
            try {
                Object object2 = object;
                CompletableFuture<V> completableFuture = function.apply(object2).toCompletableFuture();
                Object object3 = completableFuture.result;
                if (object3 != null) {
                    return new CompletableFuture<T>(CompletableFuture.encodeRelay(object3));
                }
                CompletableFuture<T> completableFuture2 = new CompletableFuture<T>();
                UniRelay<T> uniRelay = new UniRelay<T>(completableFuture2, completableFuture);
                completableFuture.push(uniRelay);
                uniRelay.tryFire(0);
                return completableFuture2;
            }
            catch (Throwable throwable) {
                return new CompletableFuture<T>(CompletableFuture.encodeThrowable(throwable));
            }
        }
        CompletableFuture<T> completableFuture = new CompletableFuture<T>();
        UniCompose<T, T> uniCompose = new UniCompose<T, T>(executor, completableFuture, this, function);
        this.push(uniCompose);
        uniCompose.tryFire(0);
        return completableFuture;
    }

    final void bipush(CompletableFuture<?> completableFuture, BiCompletion<?, ?, ?> biCompletion) {
        if (biCompletion != null) {
            Object object;
            while ((object = this.result) == null && !this.tryPushStack(biCompletion)) {
                CompletableFuture.lazySetNext(biCompletion, null);
            }
            if (completableFuture != null && completableFuture != this && completableFuture.result == null) {
                Completion completion;
                Completion completion2 = completion = object != null ? biCompletion : new CoCompletion(biCompletion);
                while (completableFuture.result == null && !completableFuture.tryPushStack(completion)) {
                    CompletableFuture.lazySetNext(completion, null);
                }
            }
        }
    }

    final CompletableFuture<T> postFire(CompletableFuture<?> completableFuture, CompletableFuture<?> completableFuture2, int n) {
        if (completableFuture2 != null && completableFuture2.stack != null) {
            if (completableFuture2.result == null) {
                completableFuture2.cleanStack();
            } else if (n >= 0) {
                completableFuture2.postComplete();
            }
        }
        return this.postFire(completableFuture, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final <R, S> boolean biApply(CompletableFuture<R> completableFuture, CompletableFuture<S> completableFuture2, BiFunction<? super R, ? super S, ? extends T> biFunction, BiApply<R, S, T> biApply) {
        Throwable throwable;
        Object object;
        Object object2;
        if (completableFuture == null || (object2 = completableFuture.result) == null || completableFuture2 == null || (object = completableFuture2.result) == null || biFunction == null) {
            return false;
        }
        if (this.result != null) return true;
        if (object2 instanceof AltResult) {
            throwable = ((AltResult)object2).ex;
            if (throwable != null) {
                this.completeThrowable(throwable, object2);
                return true;
            }
            object2 = null;
        }
        if (object instanceof AltResult) {
            throwable = ((AltResult)object).ex;
            if (throwable != null) {
                this.completeThrowable(throwable, object);
                return true;
            }
            object = null;
        }
        try {
            if (biApply != null && !biApply.claim()) {
                return false;
            }
            Object object3 = object2;
            Object object4 = object;
            this.completeValue(biFunction.apply(object3, object4));
            return true;
        }
        catch (Throwable throwable2) {
            this.completeThrowable(throwable2);
        }
        return true;
    }

    private <U, V> CompletableFuture<V> biApplyStage(Executor executor, CompletionStage<U> completionStage, BiFunction<? super T, ? super U, ? extends V> biFunction) {
        CompletableFuture<U> completableFuture;
        if (biFunction == null || (completableFuture = completionStage.toCompletableFuture()) == null) {
            throw new NullPointerException();
        }
        CompletableFuture<? extends V> completableFuture2 = new CompletableFuture<V>();
        if (executor != null || !completableFuture2.biApply(this, completableFuture, biFunction, null)) {
            BiApply<T, U, V> biApply = new BiApply<T, U, V>(executor, completableFuture2, this, completableFuture, biFunction);
            this.bipush(completableFuture, biApply);
            biApply.tryFire(0);
        }
        return completableFuture2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final <R, S> boolean biAccept(CompletableFuture<R> completableFuture, CompletableFuture<S> completableFuture2, BiConsumer<? super R, ? super S> biConsumer, BiAccept<R, S> biAccept) {
        Throwable throwable;
        Object object;
        Object object2;
        if (completableFuture == null || (object2 = completableFuture.result) == null || completableFuture2 == null || (object = completableFuture2.result) == null || biConsumer == null) {
            return false;
        }
        if (this.result != null) return true;
        if (object2 instanceof AltResult) {
            throwable = ((AltResult)object2).ex;
            if (throwable != null) {
                this.completeThrowable(throwable, object2);
                return true;
            }
            object2 = null;
        }
        if (object instanceof AltResult) {
            throwable = ((AltResult)object).ex;
            if (throwable != null) {
                this.completeThrowable(throwable, object);
                return true;
            }
            object = null;
        }
        try {
            if (biAccept != null && !biAccept.claim()) {
                return false;
            }
            Object object3 = object2;
            Object object4 = object;
            biConsumer.accept(object3, object4);
            this.completeNull();
            return true;
        }
        catch (Throwable throwable2) {
            this.completeThrowable(throwable2);
        }
        return true;
    }

    private <U> CompletableFuture<Void> biAcceptStage(Executor executor, CompletionStage<U> completionStage, BiConsumer<? super T, ? super U> biConsumer) {
        CompletableFuture<U> completableFuture;
        if (biConsumer == null || (completableFuture = completionStage.toCompletableFuture()) == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> completableFuture2 = new CompletableFuture<Void>();
        if (executor != null || !completableFuture2.biAccept(this, completableFuture, biConsumer, null)) {
            BiAccept<T, U> biAccept = new BiAccept<T, U>(executor, completableFuture2, this, completableFuture, biConsumer);
            this.bipush(completableFuture, biAccept);
            biAccept.tryFire(0);
        }
        return completableFuture2;
    }

    final boolean biRun(CompletableFuture<?> completableFuture, CompletableFuture<?> completableFuture2, Runnable runnable, BiRun<?, ?> biRun) {
        Object object;
        Object object2;
        if (completableFuture == null || (object2 = completableFuture.result) == null || completableFuture2 == null || (object = completableFuture2.result) == null || runnable == null) {
            return false;
        }
        if (this.result == null) {
            Throwable throwable;
            if (object2 instanceof AltResult && (throwable = ((AltResult)object2).ex) != null) {
                this.completeThrowable(throwable, object2);
            } else if (object instanceof AltResult && (throwable = ((AltResult)object).ex) != null) {
                this.completeThrowable(throwable, object);
            } else {
                try {
                    if (biRun != null && !biRun.claim()) {
                        return false;
                    }
                    runnable.run();
                    this.completeNull();
                }
                catch (Throwable throwable2) {
                    this.completeThrowable(throwable2);
                }
            }
        }
        return true;
    }

    private CompletableFuture<Void> biRunStage(Executor executor, CompletionStage<?> completionStage, Runnable runnable) {
        CompletableFuture<?> completableFuture;
        if (runnable == null || (completableFuture = completionStage.toCompletableFuture()) == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> completableFuture2 = new CompletableFuture<Void>();
        if (executor != null || !completableFuture2.biRun(this, completableFuture, runnable, null)) {
            BiRun biRun = new BiRun(executor, completableFuture2, this, completableFuture, runnable);
            this.bipush(completableFuture, biRun);
            biRun.tryFire(0);
        }
        return completableFuture2;
    }

    boolean biRelay(CompletableFuture<?> completableFuture, CompletableFuture<?> completableFuture2) {
        Object object;
        Object object2;
        if (completableFuture == null || (object2 = completableFuture.result) == null || completableFuture2 == null || (object = completableFuture2.result) == null) {
            return false;
        }
        if (this.result == null) {
            Throwable throwable;
            if (object2 instanceof AltResult && (throwable = ((AltResult)object2).ex) != null) {
                this.completeThrowable(throwable, object2);
            } else if (object instanceof AltResult && (throwable = ((AltResult)object).ex) != null) {
                this.completeThrowable(throwable, object);
            } else {
                this.completeNull();
            }
        }
        return true;
    }

    static CompletableFuture<Void> andTree(CompletableFuture<?>[] completableFutureArray, int n, int n2) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        if (n > n2) {
            completableFuture.result = NIL;
        } else {
            CompletableFuture<Object> completableFuture2;
            int n3 = n + n2 >>> 1;
            CompletableFuture<Object> completableFuture3 = n == n3 ? completableFutureArray[n] : CompletableFuture.andTree(completableFutureArray, n, n3);
            if (completableFuture3 == null || (n == n2 ? completableFuture3 : (completableFuture2 = n2 == n3 + 1 ? completableFutureArray[n2] : CompletableFuture.andTree(completableFutureArray, n3 + 1, n2))) == null) {
                throw new NullPointerException();
            }
            if (!completableFuture.biRelay(completableFuture3, completableFuture2)) {
                BiRelay biRelay = new BiRelay(completableFuture, completableFuture3, completableFuture2);
                completableFuture3.bipush(completableFuture2, biRelay);
                biRelay.tryFire(0);
            }
        }
        return completableFuture;
    }

    final void orpush(CompletableFuture<?> completableFuture, BiCompletion<?, ?, ?> biCompletion) {
        if (biCompletion != null) {
            while ((completableFuture == null || completableFuture.result == null) && this.result == null) {
                if (this.tryPushStack(biCompletion)) {
                    if (completableFuture == null || completableFuture == this || completableFuture.result != null) break;
                    CoCompletion coCompletion = new CoCompletion(biCompletion);
                    while (this.result == null && completableFuture.result == null && !completableFuture.tryPushStack(coCompletion)) {
                        CompletableFuture.lazySetNext(coCompletion, null);
                    }
                    break;
                }
                CompletableFuture.lazySetNext(biCompletion, null);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final <R, S extends R> boolean orApply(CompletableFuture<R> completableFuture, CompletableFuture<S> completableFuture2, Function<? super R, ? extends T> function, OrApply<R, S, T> orApply) {
        if (completableFuture == null) return false;
        if (completableFuture2 == null) return false;
        Object object = completableFuture.result;
        if (object == null) {
            object = completableFuture2.result;
            if (object == null) return false;
        }
        if (function == null) {
            return false;
        }
        if (this.result != null) return true;
        try {
            if (orApply != null && !orApply.claim()) {
                return false;
            }
            if (object instanceof AltResult) {
                Throwable throwable = ((AltResult)object).ex;
                if (throwable != null) {
                    this.completeThrowable(throwable, object);
                    return true;
                }
                object = null;
            }
            Object object2 = object;
            this.completeValue(function.apply(object2));
            return true;
        }
        catch (Throwable throwable) {
            this.completeThrowable(throwable);
        }
        return true;
    }

    private <U extends T, V> CompletableFuture<V> orApplyStage(Executor executor, CompletionStage<U> completionStage, Function<? super T, ? extends V> function) {
        CompletableFuture<U> completableFuture;
        if (function == null || (completableFuture = completionStage.toCompletableFuture()) == null) {
            throw new NullPointerException();
        }
        CompletableFuture<? extends V> completableFuture2 = new CompletableFuture<V>();
        if (executor != null || !completableFuture2.orApply(this, completableFuture, function, null)) {
            OrApply<T, U, V> orApply = new OrApply<T, U, V>(executor, completableFuture2, this, completableFuture, function);
            this.orpush(completableFuture, orApply);
            orApply.tryFire(0);
        }
        return completableFuture2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final <R, S extends R> boolean orAccept(CompletableFuture<R> completableFuture, CompletableFuture<S> completableFuture2, Consumer<? super R> consumer, OrAccept<R, S> orAccept) {
        if (completableFuture == null) return false;
        if (completableFuture2 == null) return false;
        Object object = completableFuture.result;
        if (object == null) {
            object = completableFuture2.result;
            if (object == null) return false;
        }
        if (consumer == null) {
            return false;
        }
        if (this.result != null) return true;
        try {
            if (orAccept != null && !orAccept.claim()) {
                return false;
            }
            if (object instanceof AltResult) {
                Throwable throwable = ((AltResult)object).ex;
                if (throwable != null) {
                    this.completeThrowable(throwable, object);
                    return true;
                }
                object = null;
            }
            Object object2 = object;
            consumer.accept(object2);
            this.completeNull();
            return true;
        }
        catch (Throwable throwable) {
            this.completeThrowable(throwable);
        }
        return true;
    }

    private <U extends T> CompletableFuture<Void> orAcceptStage(Executor executor, CompletionStage<U> completionStage, Consumer<? super T> consumer) {
        CompletableFuture<U> completableFuture;
        if (consumer == null || (completableFuture = completionStage.toCompletableFuture()) == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> completableFuture2 = new CompletableFuture<Void>();
        if (executor != null || !completableFuture2.orAccept(this, completableFuture, consumer, null)) {
            OrAccept<T, U> orAccept = new OrAccept<T, U>(executor, completableFuture2, this, completableFuture, consumer);
            this.orpush(completableFuture, orAccept);
            orAccept.tryFire(0);
        }
        return completableFuture2;
    }

    final boolean orRun(CompletableFuture<?> completableFuture, CompletableFuture<?> completableFuture2, Runnable runnable, OrRun<?, ?> orRun) {
        Object object;
        if (completableFuture == null || completableFuture2 == null || (object = completableFuture.result) == null && (object = completableFuture2.result) == null || runnable == null) {
            return false;
        }
        if (this.result == null) {
            try {
                Throwable throwable;
                if (orRun != null && !orRun.claim()) {
                    return false;
                }
                if (object instanceof AltResult && (throwable = ((AltResult)object).ex) != null) {
                    this.completeThrowable(throwable, object);
                } else {
                    runnable.run();
                    this.completeNull();
                }
            }
            catch (Throwable throwable) {
                this.completeThrowable(throwable);
            }
        }
        return true;
    }

    private CompletableFuture<Void> orRunStage(Executor executor, CompletionStage<?> completionStage, Runnable runnable) {
        CompletableFuture<?> completableFuture;
        if (runnable == null || (completableFuture = completionStage.toCompletableFuture()) == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> completableFuture2 = new CompletableFuture<Void>();
        if (executor != null || !completableFuture2.orRun(this, completableFuture, runnable, null)) {
            OrRun orRun = new OrRun(executor, completableFuture2, this, completableFuture, runnable);
            this.orpush(completableFuture, orRun);
            orRun.tryFire(0);
        }
        return completableFuture2;
    }

    final boolean orRelay(CompletableFuture<?> completableFuture, CompletableFuture<?> completableFuture2) {
        Object object;
        if (completableFuture == null || completableFuture2 == null || (object = completableFuture.result) == null && (object = completableFuture2.result) == null) {
            return false;
        }
        if (this.result == null) {
            this.completeRelay(object);
        }
        return true;
    }

    static CompletableFuture<Object> orTree(CompletableFuture<?>[] completableFutureArray, int n, int n2) {
        CompletableFuture<Object> completableFuture = new CompletableFuture<Object>();
        if (n <= n2) {
            CompletableFuture<Object> completableFuture2;
            int n3 = n + n2 >>> 1;
            CompletableFuture<Object> completableFuture3 = n == n3 ? completableFutureArray[n] : CompletableFuture.orTree(completableFutureArray, n, n3);
            if (completableFuture3 == null || (n == n2 ? completableFuture3 : (completableFuture2 = n2 == n3 + 1 ? completableFutureArray[n2] : CompletableFuture.orTree(completableFutureArray, n3 + 1, n2))) == null) {
                throw new NullPointerException();
            }
            if (!completableFuture.orRelay(completableFuture3, completableFuture2)) {
                OrRelay orRelay = new OrRelay(completableFuture, completableFuture3, completableFuture2);
                completableFuture3.orpush(completableFuture2, orRelay);
                orRelay.tryFire(0);
            }
        }
        return completableFuture;
    }

    static <U> CompletableFuture<U> asyncSupplyStage(Executor executor, Supplier<U> supplier) {
        if (supplier == null) {
            throw new NullPointerException();
        }
        CompletableFuture completableFuture = new CompletableFuture();
        executor.execute(new AsyncSupply(completableFuture, supplier));
        return completableFuture;
    }

    static CompletableFuture<Void> asyncRunStage(Executor executor, Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        executor.execute(new AsyncRun(completableFuture, runnable));
        return completableFuture;
    }

    private Object waitingGet(boolean bl) {
        Object object;
        Signaller signaller = null;
        boolean bl2 = false;
        int n = -1;
        while ((object = this.result) == null) {
            if (n < 0) {
                n = SPINS;
                continue;
            }
            if (n > 0) {
                if (ThreadLocalRandom.nextSecondarySeed() < 0) continue;
                --n;
                continue;
            }
            if (signaller == null) {
                signaller = new Signaller(bl, 0L, 0L);
                continue;
            }
            if (!bl2) {
                bl2 = this.tryPushStack(signaller);
                continue;
            }
            if (bl && signaller.interruptControl < 0) {
                signaller.thread = null;
                this.cleanStack();
                return null;
            }
            if (signaller.thread == null || this.result != null) continue;
            try {
                ForkJoinPool.managedBlock(signaller);
            }
            catch (InterruptedException interruptedException) {
                signaller.interruptControl = -1;
            }
        }
        if (signaller != null) {
            signaller.thread = null;
            if (signaller.interruptControl < 0) {
                if (bl) {
                    object = null;
                } else {
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.postComplete();
        return object;
    }

    private Object timedGet(long l) throws TimeoutException {
        Object object;
        if (Thread.interrupted()) {
            return null;
        }
        if (l <= 0L) {
            throw new TimeoutException();
        }
        long l2 = System.nanoTime() + l;
        Signaller signaller = new Signaller(true, l, l2 == 0L ? 1L : l2);
        boolean bl = false;
        while ((object = this.result) == null) {
            if (!bl) {
                bl = this.tryPushStack(signaller);
                continue;
            }
            if (signaller.interruptControl < 0 || signaller.nanos <= 0L) {
                signaller.thread = null;
                this.cleanStack();
                if (signaller.interruptControl < 0) {
                    return null;
                }
                throw new TimeoutException();
            }
            if (signaller.thread == null || this.result != null) continue;
            try {
                ForkJoinPool.managedBlock(signaller);
            }
            catch (InterruptedException interruptedException) {
                signaller.interruptControl = -1;
            }
        }
        if (signaller.interruptControl < 0) {
            object = null;
        }
        signaller.thread = null;
        this.postComplete();
        return object;
    }

    public CompletableFuture() {
    }

    private CompletableFuture(Object object) {
        this.result = object;
    }

    public static <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier) {
        return CompletableFuture.asyncSupplyStage(asyncPool, supplier);
    }

    public static <U> CompletableFuture<U> supplyAsync(Supplier<U> supplier, Executor executor) {
        return CompletableFuture.asyncSupplyStage(CompletableFuture.screenExecutor(executor), supplier);
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable) {
        return CompletableFuture.asyncRunStage(asyncPool, runnable);
    }

    public static CompletableFuture<Void> runAsync(Runnable runnable, Executor executor) {
        return CompletableFuture.asyncRunStage(CompletableFuture.screenExecutor(executor), runnable);
    }

    public static <U> CompletableFuture<U> completedFuture(U u) {
        return new CompletableFuture(u == null ? NIL : u);
    }

    @Override
    public boolean isDone() {
        return this.result != null;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        Object object = this.result;
        return CompletableFuture.reportGet(object == null ? this.waitingGet(true) : object);
    }

    @Override
    public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        long l2 = timeUnit.toNanos(l);
        Object object = this.result;
        return CompletableFuture.reportGet(object == null ? this.timedGet(l2) : object);
    }

    public T join() {
        Object object = this.result;
        return CompletableFuture.reportJoin(object == null ? this.waitingGet(false) : object);
    }

    public T getNow(T t) {
        Object object = this.result;
        return object == null ? t : CompletableFuture.reportJoin(object);
    }

    public boolean complete(T t) {
        boolean bl = this.completeValue(t);
        this.postComplete();
        return bl;
    }

    public boolean completeExceptionally(Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException();
        }
        boolean bl = this.internalComplete(new AltResult(throwable));
        this.postComplete();
        return bl;
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> function) {
        return this.uniApplyStage(null, function);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> function) {
        return this.uniApplyStage(asyncPool, function);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> function, Executor executor) {
        return this.uniApplyStage(CompletableFuture.screenExecutor(executor), function);
    }

    public CompletableFuture<Void> thenAccept(Consumer<? super T> consumer) {
        return this.uniAcceptStage(null, consumer);
    }

    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> consumer) {
        return this.uniAcceptStage(asyncPool, consumer);
    }

    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> consumer, Executor executor) {
        return this.uniAcceptStage(CompletableFuture.screenExecutor(executor), consumer);
    }

    public CompletableFuture<Void> thenRun(Runnable runnable) {
        return this.uniRunStage(null, runnable);
    }

    public CompletableFuture<Void> thenRunAsync(Runnable runnable) {
        return this.uniRunStage(asyncPool, runnable);
    }

    public CompletableFuture<Void> thenRunAsync(Runnable runnable, Executor executor) {
        return this.uniRunStage(CompletableFuture.screenExecutor(executor), runnable);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> completionStage, BiFunction<? super T, ? super U, ? extends V> biFunction) {
        return this.biApplyStage(null, completionStage, biFunction);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> completionStage, BiFunction<? super T, ? super U, ? extends V> biFunction) {
        return this.biApplyStage(asyncPool, completionStage, biFunction);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> completionStage, BiFunction<? super T, ? super U, ? extends V> biFunction, Executor executor) {
        return this.biApplyStage(CompletableFuture.screenExecutor(executor), completionStage, biFunction);
    }

    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> completionStage, BiConsumer<? super T, ? super U> biConsumer) {
        return this.biAcceptStage(null, completionStage, biConsumer);
    }

    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> completionStage, BiConsumer<? super T, ? super U> biConsumer) {
        return this.biAcceptStage(asyncPool, completionStage, biConsumer);
    }

    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> completionStage, BiConsumer<? super T, ? super U> biConsumer, Executor executor) {
        return this.biAcceptStage(CompletableFuture.screenExecutor(executor), completionStage, biConsumer);
    }

    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> completionStage, Runnable runnable) {
        return this.biRunStage(null, completionStage, runnable);
    }

    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> completionStage, Runnable runnable) {
        return this.biRunStage(asyncPool, completionStage, runnable);
    }

    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> completionStage, Runnable runnable, Executor executor) {
        return this.biRunStage(CompletableFuture.screenExecutor(executor), completionStage, runnable);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> completionStage, Function<? super T, U> function) {
        return this.orApplyStage(null, completionStage, function);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> completionStage, Function<? super T, U> function) {
        return this.orApplyStage(asyncPool, completionStage, function);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> completionStage, Function<? super T, U> function, Executor executor) {
        return this.orApplyStage(CompletableFuture.screenExecutor(executor), completionStage, function);
    }

    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> completionStage, Consumer<? super T> consumer) {
        return this.orAcceptStage(null, completionStage, consumer);
    }

    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> completionStage, Consumer<? super T> consumer) {
        return this.orAcceptStage(asyncPool, completionStage, consumer);
    }

    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> completionStage, Consumer<? super T> consumer, Executor executor) {
        return this.orAcceptStage(CompletableFuture.screenExecutor(executor), completionStage, consumer);
    }

    public CompletableFuture<Void> runAfterEither(CompletionStage<?> completionStage, Runnable runnable) {
        return this.orRunStage(null, completionStage, runnable);
    }

    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> completionStage, Runnable runnable) {
        return this.orRunStage(asyncPool, completionStage, runnable);
    }

    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> completionStage, Runnable runnable, Executor executor) {
        return this.orRunStage(CompletableFuture.screenExecutor(executor), completionStage, runnable);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> function) {
        return this.uniComposeStage(null, function);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> function) {
        return this.uniComposeStage(asyncPool, function);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> function, Executor executor) {
        return this.uniComposeStage(CompletableFuture.screenExecutor(executor), function);
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> biConsumer) {
        return this.uniWhenCompleteStage(null, biConsumer);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> biConsumer) {
        return this.uniWhenCompleteStage(asyncPool, biConsumer);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> biConsumer, Executor executor) {
        return this.uniWhenCompleteStage(CompletableFuture.screenExecutor(executor), biConsumer);
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> biFunction) {
        return this.uniHandleStage(null, biFunction);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> biFunction) {
        return this.uniHandleStage(asyncPool, biFunction);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> biFunction, Executor executor) {
        return this.uniHandleStage(CompletableFuture.screenExecutor(executor), biFunction);
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this;
    }

    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> function) {
        return this.uniExceptionallyStage(function);
    }

    public static CompletableFuture<Void> allOf(CompletableFuture<?> ... completableFutureArray) {
        return CompletableFuture.andTree(completableFutureArray, 0, completableFutureArray.length - 1);
    }

    public static CompletableFuture<Object> anyOf(CompletableFuture<?> ... completableFutureArray) {
        return CompletableFuture.orTree(completableFutureArray, 0, completableFutureArray.length - 1);
    }

    @Override
    public boolean cancel(boolean bl) {
        boolean bl2 = this.result == null && this.internalComplete(new AltResult(new CancellationException()));
        this.postComplete();
        return bl2 || this.isCancelled();
    }

    @Override
    public boolean isCancelled() {
        Object object = this.result;
        return object instanceof AltResult && ((AltResult)object).ex instanceof CancellationException;
    }

    public boolean isCompletedExceptionally() {
        Object object = this.result;
        return object instanceof AltResult && object != NIL;
    }

    public void obtrudeValue(T t) {
        this.result = t == null ? NIL : t;
        this.postComplete();
    }

    public void obtrudeException(Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException();
        }
        this.result = new AltResult(throwable);
        this.postComplete();
    }

    public int getNumberOfDependents() {
        int n = 0;
        Completion completion = this.stack;
        while (completion != null) {
            ++n;
            completion = completion.next;
        }
        return n;
    }

    public String toString() {
        int n;
        Object object = this.result;
        return super.toString() + (object == null ? ((n = this.getNumberOfDependents()) == 0 ? "[Not completed]" : "[Not completed, " + n + " dependents]") : (object instanceof AltResult && ((AltResult)object).ex != null ? "[Completed exceptionally]" : "[Completed normally]"));
    }

    static {
        try {
            Unsafe unsafe;
            UNSAFE = unsafe = Unsafe.getUnsafe();
            Class<CompletableFuture> clazz = CompletableFuture.class;
            RESULT = unsafe.objectFieldOffset(clazz.getDeclaredField("result"));
            STACK = unsafe.objectFieldOffset(clazz.getDeclaredField("stack"));
            NEXT = unsafe.objectFieldOffset(Completion.class.getDeclaredField("next"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    static final class Signaller
    extends Completion
    implements ForkJoinPool.ManagedBlocker {
        long nanos;
        final long deadline;
        volatile int interruptControl;
        volatile Thread thread = Thread.currentThread();

        Signaller(boolean bl, long l, long l2) {
            this.interruptControl = bl ? 1 : 0;
            this.nanos = l;
            this.deadline = l2;
        }

        @Override
        final CompletableFuture<?> tryFire(int n) {
            Thread thread = this.thread;
            if (thread != null) {
                this.thread = null;
                LockSupport.unpark(thread);
            }
            return null;
        }

        @Override
        public boolean isReleasable() {
            if (this.thread == null) {
                return true;
            }
            if (Thread.interrupted()) {
                int n = this.interruptControl;
                this.interruptControl = -1;
                if (n > 0) {
                    return true;
                }
            }
            if (this.deadline != 0L && (this.nanos <= 0L || (this.nanos = this.deadline - System.nanoTime()) <= 0L)) {
                this.thread = null;
                return true;
            }
            return false;
        }

        @Override
        public boolean block() {
            if (this.isReleasable()) {
                return true;
            }
            if (this.deadline == 0L) {
                LockSupport.park(this);
            } else if (this.nanos > 0L) {
                LockSupport.parkNanos(this, this.nanos);
            }
            return this.isReleasable();
        }

        @Override
        final boolean isLive() {
            return this.thread != null;
        }
    }

    static final class AsyncRun
    extends ForkJoinTask<Void>
    implements Runnable,
    AsynchronousCompletionTask {
        CompletableFuture<Void> dep;
        Runnable fn;

        AsyncRun(CompletableFuture<Void> completableFuture, Runnable runnable) {
            this.dep = completableFuture;
            this.fn = runnable;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void void_) {
        }

        @Override
        public final boolean exec() {
            this.run();
            return true;
        }

        @Override
        public void run() {
            Runnable runnable;
            CompletableFuture<Void> completableFuture = this.dep;
            if (completableFuture != null && (runnable = this.fn) != null) {
                this.dep = null;
                this.fn = null;
                if (completableFuture.result == null) {
                    try {
                        runnable.run();
                        completableFuture.completeNull();
                    }
                    catch (Throwable throwable) {
                        completableFuture.completeThrowable(throwable);
                    }
                }
                completableFuture.postComplete();
            }
        }
    }

    static final class AsyncSupply<T>
    extends ForkJoinTask<Void>
    implements Runnable,
    AsynchronousCompletionTask {
        CompletableFuture<T> dep;
        Supplier<T> fn;

        AsyncSupply(CompletableFuture<T> completableFuture, Supplier<T> supplier) {
            this.dep = completableFuture;
            this.fn = supplier;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void void_) {
        }

        @Override
        public final boolean exec() {
            this.run();
            return true;
        }

        @Override
        public void run() {
            Supplier<T> supplier;
            CompletableFuture<T> completableFuture = this.dep;
            if (completableFuture != null && (supplier = this.fn) != null) {
                this.dep = null;
                this.fn = null;
                if (completableFuture.result == null) {
                    try {
                        completableFuture.completeValue(supplier.get());
                    }
                    catch (Throwable throwable) {
                        completableFuture.completeThrowable(throwable);
                    }
                }
                completableFuture.postComplete();
            }
        }
    }

    static final class OrRelay<T, U>
    extends BiCompletion<T, U, Object> {
        OrRelay(CompletableFuture<Object> completableFuture, CompletableFuture<T> completableFuture2, CompletableFuture<U> completableFuture3) {
            super(null, completableFuture, completableFuture2, completableFuture3);
        }

        final CompletableFuture<Object> tryFire(int n) {
            CompletableFuture completableFuture;
            CompletableFuture completableFuture2;
            CompletableFuture completableFuture3 = this.dep;
            if (completableFuture3 == null || !completableFuture3.orRelay(completableFuture2 = this.src, completableFuture = this.snd)) {
                return null;
            }
            this.src = null;
            this.snd = null;
            this.dep = null;
            return completableFuture3.postFire(completableFuture2, completableFuture, n);
        }
    }

    static final class OrRun<T, U>
    extends BiCompletion<T, U, Void> {
        Runnable fn;

        OrRun(Executor executor, CompletableFuture<Void> completableFuture, CompletableFuture<T> completableFuture2, CompletableFuture<U> completableFuture3, Runnable runnable) {
            super(executor, completableFuture, completableFuture2, completableFuture3);
            this.fn = runnable;
        }

        final CompletableFuture<Void> tryFire(int n) {
            CompletableFuture completableFuture;
            CompletableFuture completableFuture2;
            CompletableFuture completableFuture3 = this.dep;
            if (completableFuture3 == null || !completableFuture3.orRun(completableFuture2 = this.src, completableFuture = this.snd, this.fn, n > 0 ? null : this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.snd = null;
            this.fn = null;
            return completableFuture3.postFire(completableFuture2, completableFuture, n);
        }
    }

    static final class OrAccept<T, U extends T>
    extends BiCompletion<T, U, Void> {
        Consumer<? super T> fn;

        OrAccept(Executor executor, CompletableFuture<Void> completableFuture, CompletableFuture<T> completableFuture2, CompletableFuture<U> completableFuture3, Consumer<? super T> consumer) {
            super(executor, completableFuture, completableFuture2, completableFuture3);
            this.fn = consumer;
        }

        final CompletableFuture<Void> tryFire(int n) {
            CompletableFuture completableFuture;
            CompletableFuture completableFuture2;
            CompletableFuture completableFuture3 = this.dep;
            if (completableFuture3 == null || !completableFuture3.orAccept(completableFuture2 = this.src, completableFuture = this.snd, this.fn, n > 0 ? null : this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.snd = null;
            this.fn = null;
            return completableFuture3.postFire(completableFuture2, completableFuture, n);
        }
    }

    static final class OrApply<T, U extends T, V>
    extends BiCompletion<T, U, V> {
        Function<? super T, ? extends V> fn;

        OrApply(Executor executor, CompletableFuture<V> completableFuture, CompletableFuture<T> completableFuture2, CompletableFuture<U> completableFuture3, Function<? super T, ? extends V> function) {
            super(executor, completableFuture, completableFuture2, completableFuture3);
            this.fn = function;
        }

        final CompletableFuture<V> tryFire(int n) {
            CompletableFuture completableFuture;
            CompletableFuture completableFuture2;
            CompletableFuture completableFuture3 = this.dep;
            if (completableFuture3 == null || !completableFuture3.orApply(completableFuture2 = this.src, completableFuture = this.snd, this.fn, n > 0 ? null : this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.snd = null;
            this.fn = null;
            return completableFuture3.postFire(completableFuture2, completableFuture, n);
        }
    }

    static final class BiRelay<T, U>
    extends BiCompletion<T, U, Void> {
        BiRelay(CompletableFuture<Void> completableFuture, CompletableFuture<T> completableFuture2, CompletableFuture<U> completableFuture3) {
            super(null, completableFuture, completableFuture2, completableFuture3);
        }

        final CompletableFuture<Void> tryFire(int n) {
            CompletableFuture completableFuture;
            CompletableFuture completableFuture2;
            CompletableFuture completableFuture3 = this.dep;
            if (completableFuture3 == null || !completableFuture3.biRelay(completableFuture2 = this.src, completableFuture = this.snd)) {
                return null;
            }
            this.src = null;
            this.snd = null;
            this.dep = null;
            return completableFuture3.postFire(completableFuture2, completableFuture, n);
        }
    }

    static final class BiRun<T, U>
    extends BiCompletion<T, U, Void> {
        Runnable fn;

        BiRun(Executor executor, CompletableFuture<Void> completableFuture, CompletableFuture<T> completableFuture2, CompletableFuture<U> completableFuture3, Runnable runnable) {
            super(executor, completableFuture, completableFuture2, completableFuture3);
            this.fn = runnable;
        }

        final CompletableFuture<Void> tryFire(int n) {
            CompletableFuture completableFuture;
            CompletableFuture completableFuture2;
            CompletableFuture completableFuture3 = this.dep;
            if (completableFuture3 == null || !completableFuture3.biRun(completableFuture2 = this.src, completableFuture = this.snd, this.fn, n > 0 ? null : this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.snd = null;
            this.fn = null;
            return completableFuture3.postFire(completableFuture2, completableFuture, n);
        }
    }

    static final class BiAccept<T, U>
    extends BiCompletion<T, U, Void> {
        BiConsumer<? super T, ? super U> fn;

        BiAccept(Executor executor, CompletableFuture<Void> completableFuture, CompletableFuture<T> completableFuture2, CompletableFuture<U> completableFuture3, BiConsumer<? super T, ? super U> biConsumer) {
            super(executor, completableFuture, completableFuture2, completableFuture3);
            this.fn = biConsumer;
        }

        final CompletableFuture<Void> tryFire(int n) {
            CompletableFuture completableFuture;
            CompletableFuture completableFuture2;
            CompletableFuture completableFuture3 = this.dep;
            if (completableFuture3 == null || !completableFuture3.biAccept(completableFuture2 = this.src, completableFuture = this.snd, this.fn, n > 0 ? null : this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.snd = null;
            this.fn = null;
            return completableFuture3.postFire(completableFuture2, completableFuture, n);
        }
    }

    static final class BiApply<T, U, V>
    extends BiCompletion<T, U, V> {
        BiFunction<? super T, ? super U, ? extends V> fn;

        BiApply(Executor executor, CompletableFuture<V> completableFuture, CompletableFuture<T> completableFuture2, CompletableFuture<U> completableFuture3, BiFunction<? super T, ? super U, ? extends V> biFunction) {
            super(executor, completableFuture, completableFuture2, completableFuture3);
            this.fn = biFunction;
        }

        final CompletableFuture<V> tryFire(int n) {
            CompletableFuture completableFuture;
            CompletableFuture completableFuture2;
            CompletableFuture completableFuture3 = this.dep;
            if (completableFuture3 == null || !completableFuture3.biApply(completableFuture2 = this.src, completableFuture = this.snd, this.fn, n > 0 ? null : this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.snd = null;
            this.fn = null;
            return completableFuture3.postFire(completableFuture2, completableFuture, n);
        }
    }

    static final class CoCompletion
    extends Completion {
        BiCompletion<?, ?, ?> base;

        CoCompletion(BiCompletion<?, ?, ?> biCompletion) {
            this.base = biCompletion;
        }

        @Override
        final CompletableFuture<?> tryFire(int n) {
            CompletableFuture<?> completableFuture;
            BiCompletion<?, ?, ?> biCompletion = this.base;
            if (biCompletion == null || (completableFuture = biCompletion.tryFire(n)) == null) {
                return null;
            }
            this.base = null;
            return completableFuture;
        }

        @Override
        final boolean isLive() {
            BiCompletion<?, ?, ?> biCompletion = this.base;
            return biCompletion != null && biCompletion.dep != null;
        }
    }

    static abstract class BiCompletion<T, U, V>
    extends UniCompletion<T, V> {
        CompletableFuture<U> snd;

        BiCompletion(Executor executor, CompletableFuture<V> completableFuture, CompletableFuture<T> completableFuture2, CompletableFuture<U> completableFuture3) {
            super(executor, completableFuture, completableFuture2);
            this.snd = completableFuture3;
        }
    }

    static final class UniCompose<T, V>
    extends UniCompletion<T, V> {
        Function<? super T, ? extends CompletionStage<V>> fn;

        UniCompose(Executor executor, CompletableFuture<V> completableFuture, CompletableFuture<T> completableFuture2, Function<? super T, ? extends CompletionStage<V>> function) {
            super(executor, completableFuture, completableFuture2);
            this.fn = function;
        }

        final CompletableFuture<V> tryFire(int n) {
            CompletableFuture completableFuture;
            CompletableFuture completableFuture2 = this.dep;
            if (completableFuture2 == null || !completableFuture2.uniCompose(completableFuture = this.src, this.fn, n > 0 ? null : this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.fn = null;
            return completableFuture2.postFire(completableFuture, n);
        }
    }

    static final class UniRelay<T>
    extends UniCompletion<T, T> {
        UniRelay(CompletableFuture<T> completableFuture, CompletableFuture<T> completableFuture2) {
            super(null, completableFuture, completableFuture2);
        }

        final CompletableFuture<T> tryFire(int n) {
            CompletableFuture completableFuture;
            CompletableFuture completableFuture2 = this.dep;
            if (completableFuture2 == null || !completableFuture2.uniRelay(completableFuture = this.src)) {
                return null;
            }
            this.src = null;
            this.dep = null;
            return completableFuture2.postFire(completableFuture, n);
        }
    }

    static final class UniExceptionally<T>
    extends UniCompletion<T, T> {
        Function<? super Throwable, ? extends T> fn;

        UniExceptionally(CompletableFuture<T> completableFuture, CompletableFuture<T> completableFuture2, Function<? super Throwable, ? extends T> function) {
            super(null, completableFuture, completableFuture2);
            this.fn = function;
        }

        final CompletableFuture<T> tryFire(int n) {
            CompletableFuture completableFuture;
            CompletableFuture completableFuture2 = this.dep;
            if (completableFuture2 == null || !completableFuture2.uniExceptionally(completableFuture = this.src, this.fn, this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.fn = null;
            return completableFuture2.postFire(completableFuture, n);
        }
    }

    static final class UniHandle<T, V>
    extends UniCompletion<T, V> {
        BiFunction<? super T, Throwable, ? extends V> fn;

        UniHandle(Executor executor, CompletableFuture<V> completableFuture, CompletableFuture<T> completableFuture2, BiFunction<? super T, Throwable, ? extends V> biFunction) {
            super(executor, completableFuture, completableFuture2);
            this.fn = biFunction;
        }

        final CompletableFuture<V> tryFire(int n) {
            CompletableFuture completableFuture;
            CompletableFuture completableFuture2 = this.dep;
            if (completableFuture2 == null || !completableFuture2.uniHandle(completableFuture = this.src, this.fn, n > 0 ? null : this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.fn = null;
            return completableFuture2.postFire(completableFuture, n);
        }
    }

    static final class UniWhenComplete<T>
    extends UniCompletion<T, T> {
        BiConsumer<? super T, ? super Throwable> fn;

        UniWhenComplete(Executor executor, CompletableFuture<T> completableFuture, CompletableFuture<T> completableFuture2, BiConsumer<? super T, ? super Throwable> biConsumer) {
            super(executor, completableFuture, completableFuture2);
            this.fn = biConsumer;
        }

        final CompletableFuture<T> tryFire(int n) {
            CompletableFuture completableFuture;
            CompletableFuture completableFuture2 = this.dep;
            if (completableFuture2 == null || !completableFuture2.uniWhenComplete(completableFuture = this.src, this.fn, n > 0 ? null : this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.fn = null;
            return completableFuture2.postFire(completableFuture, n);
        }
    }

    static final class UniRun<T>
    extends UniCompletion<T, Void> {
        Runnable fn;

        UniRun(Executor executor, CompletableFuture<Void> completableFuture, CompletableFuture<T> completableFuture2, Runnable runnable) {
            super(executor, completableFuture, completableFuture2);
            this.fn = runnable;
        }

        final CompletableFuture<Void> tryFire(int n) {
            CompletableFuture completableFuture;
            CompletableFuture completableFuture2 = this.dep;
            if (completableFuture2 == null || !completableFuture2.uniRun(completableFuture = this.src, this.fn, n > 0 ? null : this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.fn = null;
            return completableFuture2.postFire(completableFuture, n);
        }
    }

    static final class UniAccept<T>
    extends UniCompletion<T, Void> {
        Consumer<? super T> fn;

        UniAccept(Executor executor, CompletableFuture<Void> completableFuture, CompletableFuture<T> completableFuture2, Consumer<? super T> consumer) {
            super(executor, completableFuture, completableFuture2);
            this.fn = consumer;
        }

        final CompletableFuture<Void> tryFire(int n) {
            CompletableFuture completableFuture;
            CompletableFuture completableFuture2 = this.dep;
            if (completableFuture2 == null || !completableFuture2.uniAccept(completableFuture = this.src, this.fn, n > 0 ? null : this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.fn = null;
            return completableFuture2.postFire(completableFuture, n);
        }
    }

    static final class UniApply<T, V>
    extends UniCompletion<T, V> {
        Function<? super T, ? extends V> fn;

        UniApply(Executor executor, CompletableFuture<V> completableFuture, CompletableFuture<T> completableFuture2, Function<? super T, ? extends V> function) {
            super(executor, completableFuture, completableFuture2);
            this.fn = function;
        }

        final CompletableFuture<V> tryFire(int n) {
            CompletableFuture completableFuture;
            CompletableFuture completableFuture2 = this.dep;
            if (completableFuture2 == null || !completableFuture2.uniApply(completableFuture = this.src, this.fn, n > 0 ? null : this)) {
                return null;
            }
            this.dep = null;
            this.src = null;
            this.fn = null;
            return completableFuture2.postFire(completableFuture, n);
        }
    }

    static abstract class UniCompletion<T, V>
    extends Completion {
        Executor executor;
        CompletableFuture<V> dep;
        CompletableFuture<T> src;

        UniCompletion(Executor executor, CompletableFuture<V> completableFuture, CompletableFuture<T> completableFuture2) {
            this.executor = executor;
            this.dep = completableFuture;
            this.src = completableFuture2;
        }

        final boolean claim() {
            Executor executor = this.executor;
            if (this.compareAndSetForkJoinTaskTag((short)0, (short)1)) {
                if (executor == null) {
                    return true;
                }
                this.executor = null;
                executor.execute(this);
            }
            return false;
        }

        @Override
        final boolean isLive() {
            return this.dep != null;
        }
    }

    static abstract class Completion
    extends ForkJoinTask<Void>
    implements Runnable,
    AsynchronousCompletionTask {
        volatile Completion next;

        Completion() {
        }

        abstract CompletableFuture<?> tryFire(int var1);

        abstract boolean isLive();

        @Override
        public final void run() {
            this.tryFire(1);
        }

        @Override
        public final boolean exec() {
            this.tryFire(1);
            return true;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void void_) {
        }
    }

    static final class ThreadPerTaskExecutor
    implements Executor {
        ThreadPerTaskExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            new Thread(runnable).start();
        }
    }

    public static interface AsynchronousCompletionTask {
    }

    static final class AltResult {
        final Throwable ex;

        AltResult(Throwable throwable) {
            this.ex = throwable;
        }
    }
}

