/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.List;

public final class Timestamp
implements Serializable {
    private static final long serialVersionUID = -5502683707821851294L;
    private Date timestamp;
    private CertPath signerCertPath;
    private transient int myhash = -1;

    public Timestamp(Date date, CertPath certPath) {
        if (Timestamp.isNull(date, certPath)) {
            throw new NullPointerException();
        }
        this.timestamp = new Date(date.getTime());
        this.signerCertPath = certPath;
    }

    public Date getTimestamp() {
        return new Date(this.timestamp.getTime());
    }

    public CertPath getSignerCertPath() {
        return this.signerCertPath;
    }

    public int hashCode() {
        if (this.myhash == -1) {
            this.myhash = this.timestamp.hashCode() + this.signerCertPath.hashCode();
        }
        return this.myhash;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Timestamp)) {
            return false;
        }
        Timestamp timestamp = (Timestamp)object;
        if (this == timestamp) {
            return true;
        }
        return this.timestamp.equals(timestamp.getTimestamp()) && this.signerCertPath.equals(timestamp.getSignerCertPath());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append("timestamp: " + this.timestamp);
        List<? extends Certificate> list = this.signerCertPath.getCertificates();
        if (!list.isEmpty()) {
            stringBuffer.append("TSA: " + list.get(0));
        } else {
            stringBuffer.append("TSA: <empty>");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (Timestamp.isNull(this.timestamp, this.signerCertPath)) {
            throw new InvalidObjectException("Invalid null field(s)");
        }
        this.myhash = -1;
        this.timestamp = new Date(this.timestamp.getTime());
    }

    private static boolean isNull(Date date, CertPath certPath) {
        return date == null || certPath == null;
    }
}

