/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.LineNumber;
import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionTargeter;
import java.util.Objects;

public class LineNumberGen
implements InstructionTargeter,
Cloneable {
    static final LineNumberGen[] EMPTY_ARRAY = new LineNumberGen[0];
    private InstructionHandle ih;
    private int srcLine;

    public LineNumberGen(InstructionHandle ih, int srcLine) {
        this.setInstruction(ih);
        this.setSourceLine(srcLine);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone Not Supported");
        }
    }

    @Override
    public boolean containsTarget(InstructionHandle ih) {
        return this.ih == ih;
    }

    public InstructionHandle getInstruction() {
        return this.ih;
    }

    public LineNumber getLineNumber() {
        return new LineNumber(this.ih.getPosition(), this.srcLine);
    }

    public int getSourceLine() {
        return this.srcLine;
    }

    public void setInstruction(InstructionHandle instructionHandle) {
        Objects.requireNonNull(instructionHandle, "instructionHandle");
        BranchInstruction.notifyTarget(this.ih, instructionHandle, this);
        this.ih = instructionHandle;
    }

    public void setSourceLine(int srcLine) {
        this.srcLine = srcLine;
    }

    @Override
    public void updateTarget(InstructionHandle oldIh, InstructionHandle newIh) {
        if (oldIh != this.ih) {
            throw new ClassGenException("Not targeting " + oldIh + ", but " + this.ih + "}");
        }
        this.setInstruction(newIh);
    }
}

