/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class MessageFormat
extends Format {
    private static final long serialVersionUID = 6479157306784022952L;
    private Locale locale;
    private String pattern = "";
    private static final int INITIAL_FORMATS = 10;
    private Format[] formats = new Format[10];
    private int[] offsets = new int[10];
    private int[] argumentNumbers = new int[10];
    private static final int MAX_ARGUMENT_INDEX = 10000;
    private int maxOffset = -1;
    private static final int SEG_RAW = 0;
    private static final int SEG_INDEX = 1;
    private static final int SEG_TYPE = 2;
    private static final int SEG_MODIFIER = 3;
    private static final int TYPE_NULL = 0;
    private static final int TYPE_NUMBER = 1;
    private static final int TYPE_DATE = 2;
    private static final int TYPE_TIME = 3;
    private static final int TYPE_CHOICE = 4;
    private static final String[] TYPE_KEYWORDS = new String[]{"", "number", "date", "time", "choice"};
    private static final int MODIFIER_DEFAULT = 0;
    private static final int MODIFIER_CURRENCY = 1;
    private static final int MODIFIER_PERCENT = 2;
    private static final int MODIFIER_INTEGER = 3;
    private static final String[] NUMBER_MODIFIER_KEYWORDS = new String[]{"", "currency", "percent", "integer"};
    private static final int MODIFIER_SHORT = 1;
    private static final int MODIFIER_MEDIUM = 2;
    private static final int MODIFIER_LONG = 3;
    private static final int MODIFIER_FULL = 4;
    private static final String[] DATE_TIME_MODIFIER_KEYWORDS = new String[]{"", "short", "medium", "long", "full"};
    private static final int[] DATE_TIME_MODIFIERS = new int[]{2, 3, 2, 1, 0};

    public MessageFormat(String string) {
        this.locale = Locale.getDefault(Locale.Category.FORMAT);
        this.applyPattern(string);
    }

    public MessageFormat(String string, Locale locale) {
        this.locale = locale;
        this.applyPattern(string);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void applyPattern(String string) {
        StringBuilder[] stringBuilderArray = new StringBuilder[4];
        stringBuilderArray[0] = new StringBuilder();
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        this.maxOffset = -1;
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (n == 0) {
                if (c == '\'') {
                    if (i + 1 < string.length() && string.charAt(i + 1) == '\'') {
                        stringBuilderArray[n].append(c);
                        ++i;
                        continue;
                    }
                    bl = !bl;
                    continue;
                }
                if (c == '{' && !bl) {
                    n = 1;
                    if (stringBuilderArray[1] != null) continue;
                    stringBuilderArray[1] = new StringBuilder();
                    continue;
                }
                stringBuilderArray[n].append(c);
                continue;
            }
            if (bl) {
                stringBuilderArray[n].append(c);
                if (c != '\'') continue;
                bl = false;
                continue;
            }
            switch (c) {
                case ',': {
                    if (n < 3) {
                        if (stringBuilderArray[++n] != null) continue block7;
                        stringBuilderArray[n] = new StringBuilder();
                        continue block7;
                    }
                    stringBuilderArray[n].append(c);
                    continue block7;
                }
                case '{': {
                    ++n3;
                    stringBuilderArray[n].append(c);
                    continue block7;
                }
                case '}': {
                    if (n3 == 0) {
                        n = 0;
                        this.makeFormat(i, n2, stringBuilderArray);
                        ++n2;
                        stringBuilderArray[1] = null;
                        stringBuilderArray[2] = null;
                        stringBuilderArray[3] = null;
                        continue block7;
                    }
                    --n3;
                    stringBuilderArray[n].append(c);
                    continue block7;
                }
                case ' ': {
                    if (n == 2 && stringBuilderArray[2].length() <= 0) continue block7;
                    stringBuilderArray[n].append(c);
                    continue block7;
                }
                case '\'': {
                    bl = true;
                }
                default: {
                    stringBuilderArray[n].append(c);
                }
            }
        }
        if (n3 == 0 && n != 0) {
            this.maxOffset = -1;
            throw new IllegalArgumentException("Unmatched braces in the pattern.");
        }
        this.pattern = stringBuilderArray[0].toString();
    }

    public String toPattern() {
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i <= this.maxOffset; ++i) {
            MessageFormat.copyAndFixQuotes(this.pattern, n, this.offsets[i], stringBuilder);
            n = this.offsets[i];
            stringBuilder.append('{').append(this.argumentNumbers[i]);
            Format format = this.formats[i];
            if (format != null) {
                if (format instanceof NumberFormat) {
                    if (format.equals(NumberFormat.getInstance(this.locale))) {
                        stringBuilder.append(",number");
                    } else if (format.equals(NumberFormat.getCurrencyInstance(this.locale))) {
                        stringBuilder.append(",number,currency");
                    } else if (format.equals(NumberFormat.getPercentInstance(this.locale))) {
                        stringBuilder.append(",number,percent");
                    } else if (format.equals(NumberFormat.getIntegerInstance(this.locale))) {
                        stringBuilder.append(",number,integer");
                    } else if (format instanceof DecimalFormat) {
                        stringBuilder.append(",number,").append(((DecimalFormat)format).toPattern());
                    } else if (format instanceof ChoiceFormat) {
                        stringBuilder.append(",choice,").append(((ChoiceFormat)format).toPattern());
                    }
                } else if (format instanceof DateFormat) {
                    int n2;
                    for (n2 = 0; n2 < DATE_TIME_MODIFIERS.length; ++n2) {
                        DateFormat dateFormat = DateFormat.getDateInstance(DATE_TIME_MODIFIERS[n2], this.locale);
                        if (format.equals(dateFormat)) {
                            stringBuilder.append(",date");
                            break;
                        }
                        dateFormat = DateFormat.getTimeInstance(DATE_TIME_MODIFIERS[n2], this.locale);
                        if (!format.equals(dateFormat)) continue;
                        stringBuilder.append(",time");
                        break;
                    }
                    if (n2 >= DATE_TIME_MODIFIERS.length) {
                        if (format instanceof SimpleDateFormat) {
                            stringBuilder.append(",date,").append(((SimpleDateFormat)format).toPattern());
                        }
                    } else if (n2 != 0) {
                        stringBuilder.append(',').append(DATE_TIME_MODIFIER_KEYWORDS[n2]);
                    }
                }
            }
            stringBuilder.append('}');
        }
        MessageFormat.copyAndFixQuotes(this.pattern, n, this.pattern.length(), stringBuilder);
        return stringBuilder.toString();
    }

    public void setFormatsByArgumentIndex(Format[] formatArray) {
        for (int i = 0; i <= this.maxOffset; ++i) {
            int n = this.argumentNumbers[i];
            if (n >= formatArray.length) continue;
            this.formats[i] = formatArray[n];
        }
    }

    public void setFormats(Format[] formatArray) {
        int n = formatArray.length;
        if (n > this.maxOffset + 1) {
            n = this.maxOffset + 1;
        }
        for (int i = 0; i < n; ++i) {
            this.formats[i] = formatArray[i];
        }
    }

    public void setFormatByArgumentIndex(int n, Format format) {
        for (int i = 0; i <= this.maxOffset; ++i) {
            if (this.argumentNumbers[i] != n) continue;
            this.formats[i] = format;
        }
    }

    public void setFormat(int n, Format format) {
        this.formats[n] = format;
    }

    public Format[] getFormatsByArgumentIndex() {
        int n = -1;
        for (int i = 0; i <= this.maxOffset; ++i) {
            if (this.argumentNumbers[i] <= n) continue;
            n = this.argumentNumbers[i];
        }
        Format[] formatArray = new Format[n + 1];
        for (int i = 0; i <= this.maxOffset; ++i) {
            formatArray[this.argumentNumbers[i]] = this.formats[i];
        }
        return formatArray;
    }

    public Format[] getFormats() {
        Format[] formatArray = new Format[this.maxOffset + 1];
        System.arraycopy(this.formats, 0, formatArray, 0, this.maxOffset + 1);
        return formatArray;
    }

    public final StringBuffer format(Object[] objectArray, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.subformat(objectArray, stringBuffer, fieldPosition, null);
    }

    public static String format(String string, Object ... objectArray) {
        MessageFormat messageFormat = new MessageFormat(string);
        return messageFormat.format(objectArray);
    }

    @Override
    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.subformat((Object[])object, stringBuffer, fieldPosition, null);
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<AttributedCharacterIterator> arrayList = new ArrayList<AttributedCharacterIterator>();
        if (object == null) {
            throw new NullPointerException("formatToCharacterIterator must be passed non-null object");
        }
        this.subformat((Object[])object, stringBuffer, null, arrayList);
        if (arrayList.size() == 0) {
            return this.createAttributedCharacterIterator("");
        }
        return this.createAttributedCharacterIterator(arrayList.toArray(new AttributedCharacterIterator[arrayList.size()]));
    }

    public Object[] parse(String string, ParsePosition parsePosition) {
        int n;
        if (string == null) {
            Object[] objectArray = new Object[]{};
            return objectArray;
        }
        int n2 = -1;
        for (int i = 0; i <= this.maxOffset; ++i) {
            if (this.argumentNumbers[i] <= n2) continue;
            n2 = this.argumentNumbers[i];
        }
        Object[] objectArray = new Object[n2 + 1];
        int n3 = 0;
        int n4 = parsePosition.index;
        ParsePosition parsePosition2 = new ParsePosition(0);
        for (n = 0; n <= this.maxOffset; ++n) {
            int n5 = this.offsets[n] - n3;
            if (n5 == 0 || this.pattern.regionMatches(n3, string, n4, n5)) {
                n4 += n5;
                n3 += n5;
            } else {
                parsePosition.errorIndex = n4;
                return null;
            }
            if (this.formats[n] == null) {
                int n6 = n != this.maxOffset ? this.offsets[n + 1] : this.pattern.length();
                int n7 = n3 >= n6 ? string.length() : string.indexOf(this.pattern.substring(n3, n6), n4);
                if (n7 < 0) {
                    parsePosition.errorIndex = n4;
                    return null;
                }
                String string2 = string.substring(n4, n7);
                if (!string2.equals("{" + this.argumentNumbers[n] + "}")) {
                    objectArray[this.argumentNumbers[n]] = string.substring(n4, n7);
                }
                n4 = n7;
                continue;
            }
            parsePosition2.index = n4;
            objectArray[this.argumentNumbers[n]] = this.formats[n].parseObject(string, parsePosition2);
            if (parsePosition2.index == n4) {
                parsePosition.errorIndex = n4;
                return null;
            }
            n4 = parsePosition2.index;
        }
        n = this.pattern.length() - n3;
        if (n != 0 && !this.pattern.regionMatches(n3, string, n4, n)) {
            parsePosition.errorIndex = n4;
            return null;
        }
        parsePosition.index = n4 + n;
        return objectArray;
    }

    public Object[] parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Object[] objectArray = this.parse(string, parsePosition);
        if (parsePosition.index == 0) {
            throw new ParseException("MessageFormat parse error!", parsePosition.errorIndex);
        }
        return objectArray;
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    @Override
    public Object clone() {
        MessageFormat messageFormat = (MessageFormat)super.clone();
        messageFormat.formats = (Format[])this.formats.clone();
        for (int i = 0; i < this.formats.length; ++i) {
            if (this.formats[i] == null) continue;
            messageFormat.formats[i] = (Format)this.formats[i].clone();
        }
        messageFormat.offsets = (int[])this.offsets.clone();
        messageFormat.argumentNumbers = (int[])this.argumentNumbers.clone();
        return messageFormat;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MessageFormat messageFormat = (MessageFormat)object;
        return this.maxOffset == messageFormat.maxOffset && this.pattern.equals(messageFormat.pattern) && (this.locale != null && this.locale.equals(messageFormat.locale) || this.locale == null && messageFormat.locale == null) && Arrays.equals(this.offsets, messageFormat.offsets) && Arrays.equals(this.argumentNumbers, messageFormat.argumentNumbers) && Arrays.equals(this.formats, messageFormat.formats);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    private StringBuffer subformat(Object[] objectArray, StringBuffer stringBuffer, FieldPosition fieldPosition, List<AttributedCharacterIterator> list) {
        int n = 0;
        int n2 = stringBuffer.length();
        for (int i = 0; i <= this.maxOffset; ++i) {
            stringBuffer.append(this.pattern.substring(n, this.offsets[i]));
            n = this.offsets[i];
            int n3 = this.argumentNumbers[i];
            if (objectArray == null || n3 >= objectArray.length) {
                stringBuffer.append('{').append(n3).append('}');
                continue;
            }
            Object[] objectArray2 = objectArray[n3];
            String string = null;
            Format format = null;
            if (objectArray2 == null) {
                string = "null";
            } else if (this.formats[i] != null) {
                format = this.formats[i];
                if (format instanceof ChoiceFormat && (string = this.formats[i].format(objectArray2)).indexOf(123) >= 0) {
                    format = new MessageFormat(string, this.locale);
                    objectArray2 = objectArray;
                    string = null;
                }
            } else if (objectArray2 instanceof Number) {
                format = NumberFormat.getInstance(this.locale);
            } else if (objectArray2 instanceof Date) {
                format = DateFormat.getDateTimeInstance(3, 3, this.locale);
            } else if (objectArray2 instanceof String) {
                string = (String)objectArray2;
            } else {
                string = objectArray2.toString();
                if (string == null) {
                    string = "null";
                }
            }
            if (list != null) {
                if (n2 != stringBuffer.length()) {
                    list.add(this.createAttributedCharacterIterator(stringBuffer.substring(n2)));
                    n2 = stringBuffer.length();
                }
                if (format != null) {
                    AttributedCharacterIterator attributedCharacterIterator = format.formatToCharacterIterator(objectArray2);
                    this.append(stringBuffer, attributedCharacterIterator);
                    if (n2 != stringBuffer.length()) {
                        list.add(this.createAttributedCharacterIterator(attributedCharacterIterator, (AttributedCharacterIterator.Attribute)Field.ARGUMENT, (Object)n3));
                        n2 = stringBuffer.length();
                    }
                    string = null;
                }
                if (string == null || string.isEmpty()) continue;
                stringBuffer.append(string);
                list.add(this.createAttributedCharacterIterator(string, (AttributedCharacterIterator.Attribute)Field.ARGUMENT, (Object)n3));
                n2 = stringBuffer.length();
                continue;
            }
            if (format != null) {
                string = format.format(objectArray2);
            }
            n2 = stringBuffer.length();
            stringBuffer.append(string);
            if (i == 0 && fieldPosition != null && Field.ARGUMENT.equals(fieldPosition.getFieldAttribute())) {
                fieldPosition.setBeginIndex(n2);
                fieldPosition.setEndIndex(stringBuffer.length());
            }
            n2 = stringBuffer.length();
        }
        stringBuffer.append(this.pattern.substring(n, this.pattern.length()));
        if (list != null && n2 != stringBuffer.length()) {
            list.add(this.createAttributedCharacterIterator(stringBuffer.substring(n2)));
        }
        return stringBuffer;
    }

    private void append(StringBuffer stringBuffer, CharacterIterator characterIterator) {
        if (characterIterator.first() != '\uffff') {
            char c;
            stringBuffer.append(characterIterator.first());
            while ((c = characterIterator.next()) != '\uffff') {
                stringBuffer.append(c);
            }
        }
    }

    private void makeFormat(int n, int n2, StringBuilder[] stringBuilderArray) {
        Object object;
        int n3;
        String[] stringArray = new String[stringBuilderArray.length];
        for (n3 = 0; n3 < stringBuilderArray.length; ++n3) {
            StringBuilder stringBuilder = stringBuilderArray[n3];
            stringArray[n3] = stringBuilder != null ? stringBuilder.toString() : "";
        }
        try {
            n3 = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("can't parse argument number: " + stringArray[1], numberFormatException);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("negative argument number: " + n3);
        }
        if (n3 >= 10000) {
            throw new IllegalArgumentException(n3 + " exceeds the ArgumentIndex implementation limit");
        }
        if (n2 >= this.formats.length) {
            int n4 = this.formats.length * 2;
            object = new Format[n4];
            int[] nArray = new int[n4];
            int[] nArray2 = new int[n4];
            System.arraycopy(this.formats, 0, object, 0, this.maxOffset + 1);
            System.arraycopy(this.offsets, 0, nArray, 0, this.maxOffset + 1);
            System.arraycopy(this.argumentNumbers, 0, nArray2, 0, this.maxOffset + 1);
            this.formats = object;
            this.offsets = nArray;
            this.argumentNumbers = nArray2;
        }
        int n5 = this.maxOffset;
        this.maxOffset = n2;
        this.offsets[n2] = stringArray[0].length();
        this.argumentNumbers[n2] = n3;
        object = null;
        if (!stringArray[2].isEmpty()) {
            int n6 = MessageFormat.findKeyword(stringArray[2], TYPE_KEYWORDS);
            block4 : switch (n6) {
                case 0: {
                    break;
                }
                case 1: {
                    switch (MessageFormat.findKeyword(stringArray[3], NUMBER_MODIFIER_KEYWORDS)) {
                        case 0: {
                            object = NumberFormat.getInstance(this.locale);
                            break block4;
                        }
                        case 1: {
                            object = NumberFormat.getCurrencyInstance(this.locale);
                            break block4;
                        }
                        case 2: {
                            object = NumberFormat.getPercentInstance(this.locale);
                            break block4;
                        }
                        case 3: {
                            object = NumberFormat.getIntegerInstance(this.locale);
                            break block4;
                        }
                    }
                    try {
                        object = new DecimalFormat(stringArray[3], DecimalFormatSymbols.getInstance(this.locale));
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.maxOffset = n5;
                        throw illegalArgumentException;
                    }
                }
                case 2: 
                case 3: {
                    int n7 = MessageFormat.findKeyword(stringArray[3], DATE_TIME_MODIFIER_KEYWORDS);
                    if (n7 >= 0 && n7 < DATE_TIME_MODIFIER_KEYWORDS.length) {
                        if (n6 == 2) {
                            object = DateFormat.getDateInstance(DATE_TIME_MODIFIERS[n7], this.locale);
                            break;
                        }
                        object = DateFormat.getTimeInstance(DATE_TIME_MODIFIERS[n7], this.locale);
                        break;
                    }
                    try {
                        object = new SimpleDateFormat(stringArray[3], this.locale);
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.maxOffset = n5;
                        throw illegalArgumentException;
                    }
                }
                case 4: {
                    try {
                        object = new ChoiceFormat(stringArray[3]);
                        break;
                    }
                    catch (Exception exception) {
                        this.maxOffset = n5;
                        throw new IllegalArgumentException("Choice Pattern incorrect: " + stringArray[3], exception);
                    }
                }
                default: {
                    this.maxOffset = n5;
                    throw new IllegalArgumentException("unknown format type: " + stringArray[2]);
                }
            }
        }
        this.formats[n2] = object;
    }

    private static final int findKeyword(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return i;
        }
        String string2 = string.trim().toLowerCase(Locale.ROOT);
        if (string2 != string) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equals(stringArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private static final void copyAndFixQuotes(String string, int n, int n2, StringBuilder stringBuilder) {
        boolean bl = false;
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '{') {
                if (!bl) {
                    stringBuilder.append('\'');
                    bl = true;
                }
                stringBuilder.append(c);
                continue;
            }
            if (c == '\'') {
                stringBuilder.append("''");
                continue;
            }
            if (bl) {
                stringBuilder.append('\'');
                bl = false;
            }
            stringBuilder.append(c);
        }
        if (bl) {
            stringBuilder.append('\'');
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl;
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        if (getField.defaulted("argumentNumbers") || getField.defaulted("offsets") || getField.defaulted("formats") || getField.defaulted("locale") || getField.defaulted("pattern") || getField.defaulted("maxOffset")) {
            throw new InvalidObjectException("Stream has missing data");
        }
        this.locale = (Locale)getField.get("locale", null);
        String string = (String)getField.get("pattern", null);
        int n = getField.get("maxOffset", -2);
        int[] nArray = (int[])((int[])getField.get("argumentNumbers", null)).clone();
        int[] nArray2 = (int[])((int[])getField.get("offsets", null)).clone();
        Format[] formatArray = (Format[])((Format[])getField.get("formats", null)).clone();
        boolean bl2 = bl = n >= -1 && nArray.length > n && nArray2.length > n && formatArray.length > n;
        if (bl) {
            int n2 = string.length() + 1;
            for (int i = n; i >= 0; --i) {
                if (nArray[i] < 0 || nArray[i] >= 10000 || nArray2[i] < 0 || nArray2[i] > n2) {
                    bl = false;
                    break;
                }
                n2 = nArray2[i];
            }
        }
        if (!bl) {
            throw new InvalidObjectException("Stream has invalid data");
        }
        this.maxOffset = n;
        this.pattern = string;
        this.offsets = nArray2;
        this.formats = formatArray;
        this.argumentNumbers = nArray;
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("Deserialized MessageFormat objects need data");
    }

    public static class Field
    extends Format.Field {
        private static final long serialVersionUID = 7899943957617360810L;
        public static final Field ARGUMENT = new Field("message argument field");

        protected Field(String string) {
            super(string);
        }

        @Override
        protected Object readResolve() throws InvalidObjectException {
            if (this.getClass() != Field.class) {
                throw new InvalidObjectException("subclass didn't correctly implement readResolve");
            }
            return ARGUMENT;
        }
    }
}

