/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdIndex;
import jp.co.extreme.base.mmd.MmdIndexElement;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.base.runtime.BcRuntimeUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.util.DtsWordManager;
import jp.co.extreme.datasource.util.ScfMmdServerUtil;
import jp.co.extreme.module.xdts.model.XdtsProcessCondition;
import jp.co.extreme.module.xdts.model.XdtsSchemaObject;
import jp.co.extreme.module.xdts.server.XsysCreateInsertSqlTask;
import jp.co.extreme.sql.SqlConnection;
import jp.co.extreme.sql.SqlDefinitionCondition;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.context.SqlContext;

public class XdtsServerUtil
extends BcLoggableObject {
    private XdtsServerUtil() {
    }

    public static XdtsServerUtil getInstance() {
        return SingletonHolder.instance;
    }

    public Map<String, MmdModel> createMmdModelMap(DtsSession dtsSession, Collection<String> tableNameCollection) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        TreeMap<String, MmdModel> mmdMap = new TreeMap<String, MmdModel>();
        for (String tableName : tableNameCollection) {
            MmdModel mmdModel = sqlContext.createModelMetaData(dtsSession.getConnection(), tableName, true);
            mmdMap.put(tableName, mmdModel);
        }
        return mmdMap;
    }

    public MmdModel createMmdModelForSelect(ResultSetMetaData rsmd, String newTableName) throws Exception {
        Map<String, MmdField> mmdFieldMap = null;
        DtsWordManager wordManager = null;
        Locale locale = null;
        List<String> columnNameList = null;
        List<MmdField> mmdFieldList = ScfMmdServerUtil.createMmdFieldList(rsmd, mmdFieldMap, wordManager, null, locale, columnNameList);
        MmdModel mmdModel2 = new MmdModel();
        mmdModel2.tableName = newTableName;
        int i = 0;
        while (i < mmdFieldList.size()) {
            MmdField mmdField = mmdFieldList.get(i);
            mmdModel2.addField(mmdField);
            ++i;
        }
        return mmdModel2;
    }

    public boolean dropTable(SqlConnection sqlConn2, String tableName, boolean recreateTable, boolean truncateTable, boolean deleteRecord) throws Exception {
        SqlContext sqlContext2 = sqlConn2.getSqlContext();
        boolean existTable = sqlContext2.existTable(sqlConn2, tableName);
        this.getLogger().info("existTable=" + existTable);
        boolean doCreateTable = false;
        if (!existTable) {
            return existTable;
        }
        if (recreateTable) {
            this.getLogger().info("\u65e2\u5b58\u30c6\u30fc\u30d6\u30eb\u3092\u524a\u9664\u4e2d... \u30c6\u30fc\u30d6\u30eb\u540d=" + tableName);
            int cnt = sqlContext2.dropTable(sqlConn2, tableName);
            return false;
        }
        if (truncateTable) {
            this.getLogger().info(String.format("\u8907\u5199\u5148\u30c6\u30fc\u30d6\u30eb '%s' \u306eTRUNCATE\u4e2d...", tableName));
            int cnt = sqlContext2.truncateTable(sqlConn2, tableName);
            this.getLogger().info("\u4ef6\u6570=" + cnt);
        } else if (deleteRecord) {
            this.getLogger().info(String.format("\u8907\u5199\u5148\u30c6\u30fc\u30d6\u30eb '%s' \u306e\u30ec\u30b3\u30fc\u30c9\u3092\u524a\u9664\u4e2d...", tableName));
            int cnt = sqlContext2.deleteAllRow(sqlConn2, tableName);
            this.getLogger().info("\u4ef6\u6570=" + cnt);
        }
        return existTable;
    }

    public void createInsertQuery(DtsSession dtsSession1, Collection<XdtsSchemaObject> schemaObjectCollection, SqlContext sqlContext2, XdtsProcessCondition processCondition, BcLogger logger) throws Exception {
        SqlContext sqlContextWk1 = dtsSession1.getSqlContext();
        for (XdtsSchemaObject schemaObject : schemaObjectCollection) {
            this.createInsertQuery_L2(dtsSession1, schemaObject, sqlContext2, processCondition, logger);
        }
    }

    public void createInsertQuery_L2(DtsSession dtsSession1, XdtsSchemaObject schemaObject, SqlContext sqlContext2, XdtsProcessCondition processCondition, BcLogger logger) throws Exception {
        SqlContext sqlContext1 = dtsSession1.getSqlContext();
        File destFile = new File(processCondition.destDirPath, String.valueOf(schemaObject.name1) + ".sql");
        logger.info("destFile=" + destFile.getPath());
        BcFileUtil.makeParent(destFile);
        FileOutputStream os = new FileOutputStream(destFile, processCondition.append);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, BcConstants.charset.name());){
            String query = "SELECT * FROM " + schemaObject.name1;
            logger.info("query=" + query);
            SqlStatement stmt = dtsSession1.getConnection().createStatement();
            SqlResultSet rs = stmt.executeQuery(query);
            MmdModel mmdModel2 = XdtsServerUtil.getInstance().createMmdModelForSelect(rs.getMetaData(), schemaObject.name1);
            SqlDefinitionCondition definitionCondition = SqlDefinitionCondition.createDefault();
            this.removeField(sqlContext2, mmdModel2, definitionCondition, false, logger);
            String insertBaseQuery = sqlContext2.createInsertQueryForPrepareStatement(mmdModel2, BcRuntimeUtil.lineSeparator, true);
            logger.debug("insertBaseQuery=" + insertBaseQuery);
            XsysCreateInsertSqlTask createInsertQueryTask = new XsysCreateInsertSqlTask();
            createInsertQueryTask.setResultSet(rs);
            createInsertQueryTask.setCondition(sqlContext2, insertBaseQuery, mmdModel2, processCondition, writer);
            createInsertQueryTask.taskProcess();
        }
    }

    public void removeField(SqlContext sqlContext, MmdModel mmdModel, SqlDefinitionCondition definitionCondition, boolean renumber, BcLogger logger) throws Exception {
        Object mmdField;
        ArrayList<Object> removeFieldList = new ArrayList<Object>();
        int fieldCount = mmdModel.getFieldCount();
        int i = 0;
        while (i < fieldCount) {
            int index = fieldCount - i - 1;
            mmdField = mmdModel.getField(index);
            String definition = sqlContext.createColumnTypeDefinition((MmdField)mmdField, definitionCondition);
            if (BcStringUtil.isEmpty(definition)) {
                removeFieldList.add(mmdField);
                logger.info("\u8907\u5199\u5bfe\u8c61\u5916:" + ((MmdField)mmdField).tableColumnName);
            }
            ++i;
        }
        logger.info("\u8907\u5199\u5bfe\u8c61\u5916\u306e\u5217\u6570=" + removeFieldList.size());
        ArrayList<MmdIndex> removeIndexList = new ArrayList<MmdIndex>();
        for (MmdIndex mmdIndex : mmdModel.indexMap.values()) {
            int i2 = 0;
            while (i2 < mmdIndex.indexElementList.size()) {
                MmdIndexElement indexElement = mmdIndex.indexElementList.get(i2);
                int j = 0;
                while (j < removeFieldList.size()) {
                    MmdField mmdField2 = (MmdField)removeFieldList.get(j);
                    if (indexElement.columnName.equalsIgnoreCase(mmdField2.columnName)) {
                        removeIndexList.add(mmdIndex);
                        break;
                    }
                    ++j;
                }
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < removeIndexList.size()) {
            MmdIndex mmdIndex1 = (MmdIndex)removeIndexList.get(i3);
            MmdIndex mmdIndex2 = mmdModel.indexMap.remove(mmdIndex1.name);
            if (mmdIndex2 == null) {
                throw new Exception("mmdIndex2=" + mmdIndex2);
            }
            if (mmdIndex1.name.equalsIgnoreCase(mmdModel.primaryIndexName)) {
                mmdModel.primaryIndexName = null;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < removeFieldList.size()) {
            mmdField = (MmdField)removeFieldList.get(i3);
            mmdModel.removeField(((MmdField)mmdField).ordinalPosition - 1);
            ++i3;
        }
        if (renumber) {
            i3 = 0;
            while (i3 < mmdModel.getFieldCount()) {
                mmdField = mmdModel.getField(i3);
                ((MmdField)mmdField).ordinalPosition = i3 + 1;
                ++i3;
            }
        }
    }

    /* synthetic */ XdtsServerUtil(XdtsServerUtil xdtsServerUtil) {
        this();
    }

    private static final class SingletonHolder {
        private static final XdtsServerUtil instance = new XdtsServerUtil(null);

        private SingletonHolder() {
        }
    }
}

