/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.mail;

import java.io.File;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import jp.co.extreme.base.charset.BcCharsetNames;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcCollectionUtil;

public final class BcMailUtil {
    public static boolean isRFC822 = false;
    public static final String MATCH_MAIL = "([a-zA-Z0-9][a-zA-Z0-9_.+\\-]*)@(([a-zA-Z0-9][a-zA-Z0-9_\\-]+\\.)+[a-zA-Z]{2,6})";
    public static final String MATCH_URL = "^(https?|ftp)(:\\/\\/[-_.!~*\\'()a-zA-Z0-9;\\/?:\\@&=+\\$,%#]+)$";

    private BcMailUtil() {
    }

    public static String encodeForSubject(String subject1, String charCode) throws Exception {
        if (BcStringUtil.isEmpty(subject1)) {
            return null;
        }
        String subject2 = MimeUtility.encodeText((String)subject1, (String)charCode, (String)"B");
        return subject2;
    }

    public static void setContent(MimeMessage mimeMessage, String content, String charsetCode) throws Exception {
        if (content != null) {
            mimeMessage.setText(content.toString(), charsetCode);
        }
        if (BcCharsetNames.ISO_2022_JP.value.equalsIgnoreCase(charsetCode)) {
            mimeMessage.setHeader("Content-Transfer-Encoding", "7bit");
        }
    }

    public static void fileAttach(MimeMessage mimeMessage, Collection<File> fileCollection) throws Exception {
        if (BcCollectionUtil.isEmpty(fileCollection)) {
            return;
        }
        MimeMultipart mimeMultipart = new MimeMultipart();
        for (File file : fileCollection) {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            FileDataSource fileDataSource = new FileDataSource(file);
            DataHandler dataHandler = new DataHandler((DataSource)fileDataSource);
            mimeBodyPart.setDataHandler(dataHandler);
            mimeBodyPart.setFileName(file.getName());
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        }
        mimeMessage.setContent((Multipart)mimeMultipart);
    }

    public static boolean checkEmailAddress(String emailAddress) {
        return Pattern.matches(MATCH_MAIL, emailAddress);
    }

    public static enum MailProperty {
        mail_smtp_host("mail.smtp.host"),
        mail_smtp_port("mail.smtp.port"),
        mail_smtp_auth("mail.smtp.auth"),
        mail_smtp_starttls_enable("mail.smtp.starttls.enable"),
        mail_smtp_ssl_protocols("mail.smtp.ssl.protocols"),
        mail_smtp_ssl_trust("mail.smtp.ssl.trust"),
        mail_smtp_timeout("mail.smtp.timeout"),
        mail_smtp_debug("mail.smtp.debug");

        public final String key;

        private MailProperty(String key) {
            this.key = key;
        }
    }
}

