/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.dom;

import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import org.w3c.dom.DOMException;
import sun.plugin.dom.exception.BrowserNotSupportedException;

public class DOMObject {
    private JSObject jsobj;

    public DOMObject(JSObject jSObject) {
        this.jsobj = jSObject;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DOMObject)) {
            return false;
        }
        return this.jsobj.equals(((DOMObject)object).jsobj);
    }

    public Object call(String string, Object[] objectArray) throws DOMException {
        try {
            Object[] objectArray2 = null;
            if (objectArray != null) {
                objectArray2 = new Object[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray2[i] = this.unwrapObject(objectArray[i]);
                }
            }
            Object object = this.jsobj.call(string, objectArray2);
            return this.wrapObject(object);
        }
        catch (JSException jSException) {
            throw new BrowserNotSupportedException(jSException.toString());
        }
    }

    public Object getMember(String string) throws DOMException {
        try {
            Object object = this.jsobj.getMember(string);
            return this.wrapObject(object);
        }
        catch (JSException jSException) {
            throw new BrowserNotSupportedException(jSException.toString());
        }
    }

    public void setMember(String string, Object object) throws DOMException {
        object = this.unwrapObject(object);
        try {
            this.jsobj.setMember(string, object);
        }
        catch (JSException jSException) {
            throw new BrowserNotSupportedException(jSException.toString());
        }
    }

    public void removeMember(String string) throws DOMException {
        try {
            this.jsobj.removeMember(string);
        }
        catch (JSException jSException) {
            throw new BrowserNotSupportedException(jSException.toString());
        }
    }

    public Object getSlot(int n) throws DOMException {
        try {
            Object object = this.jsobj.getSlot(n);
            return this.wrapObject(object);
        }
        catch (JSException jSException) {
            throw new BrowserNotSupportedException(jSException.toString());
        }
    }

    public void setSlot(int n, Object object) throws DOMException {
        object = this.unwrapObject(object);
        try {
            this.jsobj.setSlot(n, object);
        }
        catch (JSException jSException) {
            throw new BrowserNotSupportedException(jSException.toString());
        }
    }

    public String toString() {
        Object object = this.getJSObject();
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    private Object wrapObject(Object object) {
        if (object == null) {
            return object;
        }
        if (object instanceof JSObject) {
            return new DOMObject((JSObject)object);
        }
        return object;
    }

    private Object unwrapObject(Object object) {
        if (object == null) {
            return object;
        }
        if (object instanceof DOMObject) {
            DOMObject dOMObject = (DOMObject)object;
            return dOMObject.getJSObject();
        }
        return object;
    }

    public Object getJSObject() {
        return this.jsobj;
    }
}

