/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.utilities;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.jai.codecimpl.util.RasterFactory;
import java.awt.Component;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.media.jai.JAI;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.widget.ScrollingImagePanel;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageIOUtilities {
    private static final int DEFAULT_ROI = -999;

    public static ColorModel getCompatibleColorModel(SampleModel sm) {
        int nBands = sm.getNumBands();
        int bufferType = sm.getDataType();
        ColorModel cm = null;
        ColorSpace cs = null;
        if (nBands > 1) {
            cm = ImageUtil.createColorModel((SampleModel)sm);
        } else if (bufferType == 0 || bufferType == 1 || bufferType == 3 || bufferType == 4 || bufferType == 5) {
            cs = ColorSpace.getInstance(1003);
            cm = RasterFactory.createComponentColorModel((int)bufferType, (ColorSpace)cs, (boolean)false, (boolean)false, (int)1);
        } else if (bufferType == 2) {
            cs = ColorSpace.getInstance(1003);
            cm = new ComponentColorModel(cs, false, false, 1, 2);
        }
        return cm;
    }

    private ImageIOUtilities() {
    }

    public static void displayImageIOMetadata(Node root) {
        ImageIOUtilities.displayMetadata(root, 0);
    }

    private static void indent(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("  ");
        }
    }

    private static void displayMetadata(Node node, int level) {
        Node child;
        ImageIOUtilities.indent(level);
        System.out.print("<" + node.getNodeName());
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = map.item(i);
                String attrValue = attr.getNodeValue();
                if (attrValue == null) {
                    attrValue = "";
                }
                System.out.print(" " + attr.getNodeName() + "=\"" + attrValue + "\"");
            }
        }
        System.out.print(">");
        String nodeValue = node.getNodeValue();
        if (nodeValue != null) {
            System.out.println(" " + nodeValue);
        } else {
            System.out.println("");
        }
        if (child != null) {
            for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                ImageIOUtilities.displayMetadata(child, level + 1);
            }
            ImageIOUtilities.indent(level);
            System.out.println("</" + node.getNodeName() + ">");
        }
    }

    private static void visualizeRescaled(RenderedImage image, String title, int roiThreshold) {
        ROI roi = new ROI(image, roiThreshold);
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        if (roi != null) {
            pb.add(roi);
        }
        RenderedOp op = JAI.create((String)"extrema", (ParameterBlock)pb);
        double[][] extrema = (double[][])op.getProperty("extrema");
        double[] scale = new double[]{255.0 / (extrema[1][0] - extrema[0][0])};
        double[] offset = new double[]{255.0 * extrema[0][0] / (extrema[0][0] - extrema[1][0])};
        ParameterBlock pbRescale = new ParameterBlock();
        pbRescale.add(scale);
        pbRescale.add(offset);
        pbRescale.addSource(image);
        RenderedOp rescaledImage = JAI.create((String)"Rescale", (ParameterBlock)pbRescale);
        ParameterBlock pbConvert = new ParameterBlock();
        pbConvert.addSource(rescaledImage);
        pbConvert.add(0);
        RenderedOp destImage = JAI.create((String)"format", (ParameterBlock)pbConvert);
        ImageIOUtilities.visualize((RenderedImage)destImage, title);
    }

    public static void visualize(RenderedImage ri) {
        ImageIOUtilities.visualize(ri, "");
    }

    public static void visualize(RenderedImage ri, String title) {
        final JFrame frame = new JFrame(title);
        frame.getContentPane().add((Component)new ScrollingImagePanel(ri, 1024, 768));
        frame.setDefaultCloseOperation(3);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                frame.pack();
                frame.setSize(1024, 768);
                frame.setVisible(true);
            }
        });
    }

    public static void visualize(RenderedImage ri, String title, boolean rescale) {
        ImageIOUtilities.visualize(ri, title, rescale, -999);
    }

    public static void visualize(RenderedImage ri, String title, boolean rescale, int roiThreshold) {
        if (rescale) {
            ImageIOUtilities.visualizeRescaled(ri, title, roiThreshold);
        } else {
            ImageIOUtilities.visualize(ri, title);
        }
    }

    public static List<ImageReaderWriterSpi> getJDKImageReaderWriterSPI(ServiceRegistry registry, String formatName, boolean isReader) {
        String descPart;
        Class spiClass;
        IIORegistry iioRegistry = (IIORegistry)registry;
        if (isReader) {
            spiClass = ImageReaderSpi.class;
            descPart = " image reader";
        } else {
            spiClass = ImageWriterSpi.class;
            descPart = " image writer";
        }
        Iterator<ImageReaderSpi> iter = iioRegistry.getServiceProviders(spiClass, true);
        String desc = "standard " + formatName + descPart;
        String jiioPath = "com.sun.media.imageioimpl";
        Locale locale = Locale.getDefault();
        ArrayList<ImageReaderWriterSpi> list = new ArrayList<ImageReaderWriterSpi>();
        block0: while (iter.hasNext()) {
            ImageReaderWriterSpi provider = iter.next();
            if (!provider.getVendorName().startsWith("Sun Microsystems") || !desc.equalsIgnoreCase(provider.getDescription(locale)) || provider.getPluginClassName().startsWith(jiioPath)) continue;
            String[] formatNames = provider.getFormatNames();
            for (int i = 0; i < formatNames.length; ++i) {
                if (!formatNames[i].equalsIgnoreCase(formatName)) continue;
                list.add(provider);
                continue block0;
            }
        }
        return list;
    }

    public static boolean replaceProvider(Class<? extends ImageReaderWriterSpi> providerClass, String customProviderName, String originalProviderName, String format) {
        IIORegistry registry = IIORegistry.getDefaultInstance();
        ImageReaderWriterSpi standard = null;
        ImageReaderWriterSpi custom = null;
        Iterator<? extends ImageReaderWriterSpi> it = registry.getServiceProviders(providerClass, false);
        while (it.hasNext()) {
            ImageReaderWriterSpi provider = it.next();
            String providerClassName = provider.getClass().getName();
            String[] formats = provider.getFormatNames();
            for (int i = 0; i < formats.length; ++i) {
                if (!formats[i].equalsIgnoreCase(format)) continue;
                if (providerClassName.equalsIgnoreCase(originalProviderName)) {
                    standard = provider;
                } else if (providerClassName.equalsIgnoreCase(customProviderName)) {
                    custom = provider;
                }
                if (standard == null || custom == null) continue;
                if (ImageReaderSpi.class.isAssignableFrom(standard.getClass())) {
                    return registry.setOrdering(ImageReaderSpi.class, (ImageReaderSpi)custom, (ImageReaderSpi)standard);
                }
                return registry.setOrdering(ImageWriterSpi.class, (ImageWriterSpi)custom, (ImageWriterSpi)standard);
            }
        }
        return false;
    }
}

