/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio;

import com.sun.media.BasicCodec;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class ArrayToPCM
extends BasicCodec {
    private static String ArrayToPCM = "ArrayToPCM";

    public String getName() {
        return ArrayToPCM;
    }

    public ArrayToPCM() {
        this.inputFormats = new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)};
        this.outputFormats = new Format[]{new AudioFormat("LINEAR", -1.0, 16, -1, -1, -1, -1, -1.0, Format.shortArray)};
    }

    public Format[] getSupportedOutputFormats(Format in) {
        if (!(in instanceof AudioFormat)) {
            return this.outputFormats;
        }
        AudioFormat iaf = (AudioFormat)in;
        if (!iaf.getEncoding().equals("LINEAR") || iaf.getDataType() != Format.byteArray) {
            return new Format[0];
        }
        AudioFormat oaf = new AudioFormat("LINEAR", iaf.getSampleRate(), 16, iaf.getChannels(), 0, 1, iaf.getFrameSizeInBits(), iaf.getFrameRate(), Format.shortArray);
        return new Format[]{oaf};
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        int samplesNumber;
        if (this.isEOM(inputBuffer)) {
            return 0;
        }
        byte[] inBuffer = (byte[])inputBuffer.getData();
        AudioFormat inFormat = (AudioFormat)inputBuffer.getFormat();
        boolean isSigned = inFormat.getSigned() == 1;
        boolean isBigEndian = inFormat.getEndian() == 1;
        int sampleSize = inFormat.getFrameSizeInBits() + 7 >> 3;
        int inLength = inputBuffer.getLength();
        int outLength = samplesNumber = sampleSize == 1 ? inLength : inLength >> 1;
        short[] outBuffer = this.validateShortArraySize(outputBuffer, outLength);
        int offset = isSigned ? 0 : 32768;
        int inOffset = 0;
        int outOffset = 0;
        if (sampleSize == 1) {
            int i2 = samplesNumber - 1;
            while (i2 >= 0) {
                outBuffer[i2] = (short)((inBuffer[i2] << 8) + offset);
                --i2;
            }
        } else if (isBigEndian) {
            int i3 = samplesNumber - 1;
            while (i3 >= 0) {
                int sample1 = inBuffer[inOffset++] << 8;
                int sample2 = inBuffer[inOffset++] & 0xFF;
                outBuffer[outOffset++] = (short)((sample1 | sample2) + offset);
                --i3;
            }
        } else {
            int i4 = samplesNumber - 1;
            while (i4 >= 0) {
                int sample1 = inBuffer[inOffset++] & 0xFF;
                int sample2 = inBuffer[inOffset++] << 8;
                outBuffer[outOffset++] = (short)((sample1 | sample2) + offset);
                --i4;
            }
        }
        outputBuffer.setLength(samplesNumber);
        outputBuffer.setFormat(this.outputFormat);
        return 0;
    }

    public static void main(String[] args) {
        ArrayToPCM codec = new ArrayToPCM();
        Format[] ifmt = codec.getSupportedInputFormats();
        Format[] ofmt = codec.getSupportedOutputFormats(new AudioFormat("LINEAR", 8000.0, 8, 2, 0, 0));
        int i2 = 0;
        while (i2 < ifmt.length) {
            System.out.println(ifmt[i2]);
            ++i2;
        }
        System.out.println("* out *");
        int i3 = 0;
        while (i3 < ofmt.length) {
            System.out.println(ofmt[i3]);
            ++i3;
        }
    }
}

