/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util;

import java.util.Vector;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.event.EventProcessor;

public class BSFEventProcessorReturningEventInfos
implements EventProcessor {
    BSFEngine engine;
    BSFManager manager;
    String filter;
    String source;
    int lineNo;
    int columnNo;
    Object script;
    Object dataFromScriptingEngine;

    BSFEventProcessorReturningEventInfos(BSFEngine engine, BSFManager manager, String filter, String source, int lineNo, int columnNo, Object script, Object dataFromScriptingEngine) throws BSFException {
        this.engine = engine;
        this.manager = manager;
        this.filter = filter;
        this.source = source;
        this.lineNo = lineNo;
        this.columnNo = columnNo;
        this.script = script;
        this.dataFromScriptingEngine = dataFromScriptingEngine;
    }

    @Override
    public void processEvent(String inFilter, Object[] evtInfo) {
        try {
            this.processExceptionableEvent(inFilter, evtInfo);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            System.err.println("BSFError: non-exceptionable event delivery threw exception (that's not nice): " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void processExceptionableEvent(String inFilter, Object[] evtInfo) throws Exception {
        if (this.filter != null && !this.filter.equals(inFilter)) {
            return;
        }
        Vector<String> paramNames = new Vector<String>();
        Vector<Object> paramValues = new Vector<Object>();
        paramNames.add("eventParameters");
        paramValues.add(evtInfo);
        paramNames.add("dataFromScriptingEngine");
        paramValues.add(this.dataFromScriptingEngine);
        paramNames.add("inFilter");
        paramValues.add(inFilter);
        paramNames.add("eventFilter");
        paramValues.add(this.filter);
        paramNames.add("BSFManager");
        paramValues.add(this.manager);
        this.engine.apply(this.source, this.lineNo, this.columnNo, this.script, paramNames, paramValues);
    }
}

