/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.swing.docviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.doc.renderer.DcfShapeRenderer;
import jp.co.extreme.doc.util.DcfDocumentUtil;
import jp.co.extreme.doc.util.DcfPageReader;
import jp.co.extreme.swing.SwgPanel;
import jp.co.extreme.swing.docviewer.DcfViewerEventHandler;
import nlc.lib.doc.DcfPage;
import nlc.lib.doc.DcfPageFormat;

public class DcfPaperPanel
extends SwgPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -2731942022282173669L;
    protected double scale;
    protected double rShadow = 4.0;
    protected double vShadow;
    protected int topMargin = 10;
    protected int bottomMargin = 10;
    protected int leftMargin = 10;
    protected int rightMargin = 10;
    protected int hGap = 12;
    protected int vGap = 12;
    protected int columnCount = 1;
    protected int rowCount = 1;
    protected int paperTopMargin = 20;
    protected int paperLeftMargin = 20;
    protected int offImageWidth;
    protected int offImageHeight;
    protected BufferedImage bufferedImage;
    protected Color backgroundColor = Color.gray;
    protected Color shadowColor = Color.black;
    protected Color paperBorderColor = Color.darkGray;
    protected Color paperColorDefault = Color.white;
    protected PopupMenu popupMenu;
    protected MenuItem printAllPageMenu;
    protected MenuItem printCurrentPageMenu;
    protected boolean fitToBase;
    protected int fixedColumnCount;
    protected DcfShapeRenderer shapeRenderer;
    protected List<Shape> shapeList;
    protected List<DcfViewerEventHandler> viewerEventHandlerList;
    protected DcfPageReader pageReader;
    protected int[] dispPages;
    protected AffineTransform affineTransform;
    int resizeEvnetCnt;

    public DcfPaperPanel() throws Exception {
        this.popupMenu = new PopupMenu(BcWords.getInstance().print);
        this.printAllPageMenu = new MenuItem("\u5168\u3066\u306e\u30da\u30fc\u30b8\u3092\u5370\u5237");
        this.printCurrentPageMenu = new MenuItem("\u3053\u306e\u30da\u30fc\u30b8\u3092\u5370\u5237");
        this.fixedColumnCount = -1;
        this.shapeRenderer = new DcfShapeRenderer();
        this.shapeList = new ArrayList<Shape>();
        this.viewerEventHandlerList = new ArrayList<DcfViewerEventHandler>();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setScale(1.0);
    }

    protected void setScale(double scale) throws Exception {
        this.scale = scale;
        this.affineTransform = new AffineTransform();
        this.affineTransform.scale(scale, scale);
        this.bufferedImage = null;
    }

    public boolean isFitToBase() {
        return this.fitToBase;
    }

    public void setFitToBase(boolean fitToBase) {
        this.fitToBase = fitToBase;
    }

    public int getFixedColumnCount() {
        return this.fixedColumnCount;
    }

    public void setFixedColumnCount(int fixedColumnCount) {
        this.fixedColumnCount = fixedColumnCount;
    }

    public DcfPageReader getPageReader() {
        return this.pageReader;
    }

    public void setPageReader(DcfPageReader pageReader) throws Exception {
        this.pageReader = pageReader;
        this.bufferedImage = null;
    }

    public int[] getDispPages() {
        return this.dispPages;
    }

    public void setDispPages(int ... dispPages) throws Exception {
        this.dispPages = dispPages;
        this.bufferedImage = null;
    }

    public void addViewerEventHandler(DcfViewerEventHandler eventHandler) {
        this.viewerEventHandlerList.add(eventHandler);
    }

    public boolean removeaViewerEventHandler(DcfViewerEventHandler eventHandler) {
        return this.viewerEventHandlerList.remove(eventHandler);
    }

    @Override
    public void actionPerformed2(ActionEvent ev) throws Exception {
        super.actionPerformed2(ev);
        if (ev.getSource() != this.printAllPageMenu) {
            ev.getSource();
        }
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        int i = 0;
        while (i < this.shapeList.size()) {
            Shape shape = this.shapeList.get(i);
            if (shape.contains(ev.getX(), ev.getY())) {
                DcfViewerEventHandler[] viewerEventHandler = this.viewerEventHandlerList.toArray(new DcfViewerEventHandler[0]);
                int j = 0;
                while (j < viewerEventHandler.length) {
                    viewerEventHandler[j].pageSelected(this, i);
                    ++j;
                }
                return;
            }
            ++i;
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }

    @Override
    public void mouseDragged(MouseEvent ev) {
    }

    @Override
    public void mouseMoved(MouseEvent ev) {
    }

    @Override
    public void componentResized(ComponentEvent ev) {
        ++this.resizeEvnetCnt;
        if (this.offImageWidth != this.getWidth()) {
            try {
                this.createOffImage();
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics gp) {
        if (this.bufferedImage == null) {
            try {
                this.createOffImage();
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
        gp.drawImage(this.bufferedImage, 0, 0, null);
    }

    protected void createOffImage() throws Exception {
        BigDecimal bd;
        this.shapeList.clear();
        this.offImageWidth = this.getWidth();
        this.offImageHeight = this.getHeight();
        if (this.pageReader == null) {
            this.bufferedImage = new BufferedImage(this.offImageWidth, this.offImageHeight, 6);
            Graphics2D g2d = this.bufferedImage.createGraphics();
            g2d.setClip(0, 0, this.offImageWidth, this.offImageHeight);
            g2d.setColor(this.backgroundColor);
            g2d.fillRect(0, 0, this.offImageWidth, this.offImageHeight);
            return;
        }
        double pageMaxWidth = DcfDocumentUtil.getMaxWidth(this.pageReader);
        int pageCount2 = -1;
        pageCount2 = this.dispPages == null ? this.pageReader.getPageCount() : this.dispPages.length;
        if (this.fixedColumnCount > 0) {
            this.columnCount = this.fixedColumnCount;
            if (this.fitToBase) {
                double paperWidthV = this.offImageWidth - this.leftMargin - this.rightMargin;
                this.scale = paperWidthV / pageMaxWidth;
                this.affineTransform = new AffineTransform();
                this.affineTransform.scale(this.scale, this.scale);
                bd = new BigDecimal((double)pageCount2 / (double)this.columnCount);
                bd = bd.setScale(0, 0);
                this.rowCount = bd.intValue();
                double pageHeightSum = DcfDocumentUtil.getHeightSum(this.pageReader);
                double ttHeight = pageHeightSum + (double)this.topMargin + (double)this.bottomMargin + (double)(this.vGap * (pageCount2 - 1));
                this.offImageHeight = (int)Math.max((double)this.getHeight(), ttHeight *= this.scale);
            }
            this.setPreferredSize(new Dimension(this.offImageWidth, this.offImageHeight));
            this.setSize(this.getPreferredSize());
        } else {
            this.offImageWidth = this.getWidth();
            this.offImageHeight = this.getHeight();
            double pageWidthv = pageMaxWidth * this.scale;
            this.columnCount = (int)((double)(this.getWidth() - this.leftMargin - this.rightMargin) / (pageWidthv + (double)this.hGap));
            if (this.columnCount <= 0) {
                this.columnCount = 1;
            }
            bd = new BigDecimal((double)pageCount2 / (double)this.columnCount);
            bd = bd.setScale(0, 0);
            this.rowCount = bd.intValue();
        }
        this.bufferedImage = new BufferedImage(this.offImageWidth, this.offImageHeight, 6);
        Graphics2D g2d = this.bufferedImage.createGraphics();
        g2d.setClip(0, 0, this.offImageWidth, this.offImageHeight);
        g2d.setColor(this.backgroundColor);
        g2d.fillRect(0, 0, this.offImageWidth, this.offImageHeight);
        g2d.setTransform(this.affineTransform);
        int basePageIndex = 0;
        int i = 0;
        while (i < this.rowCount) {
            int j = 0;
            while (j < this.columnCount) {
                int pageIndex = -1;
                if (this.dispPages == null) {
                    pageIndex = basePageIndex + (i * this.columnCount + j);
                } else {
                    int arrayIndex = i * this.columnCount + j;
                    if (arrayIndex < this.dispPages.length) {
                        pageIndex = basePageIndex + this.dispPages[arrayIndex];
                    }
                }
                if (pageIndex < 0 || pageIndex >= this.pageReader.getPageCount()) break;
                DcfPage dcfPage = this.pageReader.getPage(pageIndex);
                DcfPageFormat pageFormat = dcfPage.getPageFormat();
                Color paperColor = this.paperColorDefault;
                if (dcfPage.paperColor != null) {
                    paperColor = dcfPage.paperColor;
                }
                double px = (double)this.leftMargin + (double)j * (pageFormat.getWidth() + (double)this.hGap);
                double py = (double)this.topMargin + (double)i * (pageFormat.getHeight() + (double)this.vGap);
                Rectangle2D.Double rectangle = new Rectangle2D.Double(px, py, pageFormat.getWidth(), (int)pageFormat.getHeight());
                Shape shape = this.affineTransform.createTransformedShape(rectangle);
                this.shapeList.add(shape);
                this.drawPaper(g2d, px, py, pageFormat.getWidth(), pageFormat.getHeight(), paperColor);
                if (this.pageReader.isBgPageEnabled() && !BcStringUtil.isEmpty(dcfPage.getOverLayName())) {
                    DcfPage overLayPage = this.pageReader.getBgPage(dcfPage.getOverLayName());
                    if (overLayPage != null) {
                        this.shapeRenderer.drawPage(g2d, pageFormat.getImageableX(), pageFormat.getImageableY(), overLayPage);
                    } else {
                        BcLogUtil.warning("overLayName '" + dcfPage.getOverLayName() + " is not found.");
                    }
                }
                this.shapeRenderer.drawPage(g2d, px + (double)this.paperLeftMargin, py + (double)this.paperTopMargin, dcfPage);
                if (dcfPage.isBorder) {
                    g2d.setClip((int)(px + pageFormat.getImageableX()), (int)(py + pageFormat.getImageableY()), (int)dcfPage.getPageFormat().getImageableWidth(), (int)dcfPage.getPageFormat().getImageableHeight());
                    g2d.setColor(Color.black);
                    g2d.drawRect((int)(px + pageFormat.getImageableX()), (int)(py + pageFormat.getImageableY()), (int)dcfPage.getPageFormat().getImageableWidth(), (int)dcfPage.getPageFormat().getImageableHeight());
                }
                ++j;
            }
            ++i;
        }
    }

    protected Point2D.Double getLogicalPositionFromScreenPosition(Point2D.Double point2D) throws NoninvertibleTransformException {
        return (Point2D.Double)this.affineTransform.inverseTransform(point2D, null);
    }

    protected Point2D.Double getLogicalPositionFromScreenPosition(double x, double y) throws NoninvertibleTransformException {
        Point2D.Double point2D = new Point2D.Double(x, y);
        return this.getLogicalPositionFromScreenPosition(point2D);
    }

    protected void drawPaper(Graphics2D g2d, double x, double y, double paperWidthV, double paperHeightV, Color paperColor) throws Exception {
        g2d.setClip((int)(x + this.vShadow), (int)(y + this.vShadow), (int)paperWidthV, (int)paperHeightV);
        g2d.setColor(this.shadowColor);
        g2d.fillRect((int)(x + this.vShadow), (int)(y + this.vShadow), (int)paperWidthV, (int)paperHeightV);
        g2d.setClip((int)x, (int)y, (int)paperWidthV, (int)paperHeightV);
        g2d.setColor(paperColor);
        g2d.fillRect((int)x, (int)y, (int)paperWidthV, (int)paperHeightV);
        g2d.setColor(this.paperBorderColor);
        g2d.drawRect((int)x, (int)y, (int)paperWidthV, (int)paperHeightV);
    }
}

