/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf2.client;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import jp.co.extreme.base.event.BcEventHandler;
import jp.co.extreme.base.event.BcEventHandlerList;
import jp.co.extreme.base.event.BcProgressEvent;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.thread.BcMonitor;
import jp.co.extreme.base.thread.BcThread;
import jp.co.extreme.rmi.agent.RmiAgent;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.rmi.model.RmiRespons;
import jp.co.extreme.scf2.rmo.ScfFileRMO;

public class ScfFileDownloader
extends BcThread {
    protected RmiAgent rmixAgent;
    protected long chunkSize;
    protected String handleId;
    protected long fileSize;
    protected long loadedSize;
    protected long offset;
    protected String svFilePath;
    protected OutputStream os;
    protected File destFile;
    protected BcMonitor parentMonitor;
    protected boolean isComplete;
    protected BcEventHandlerList updateEventHandlerList = new BcEventHandlerList();

    public ScfFileDownloader(RmiAgent agent) throws Exception {
        this.rmixAgent = agent;
        this.setPriority(5);
    }

    public long getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(long chunkSize) {
        this.chunkSize = chunkSize;
    }

    public void addProgressEventHandler(BcEventHandler eventHandler) throws Exception {
        this.updateEventHandlerList.addEventHandler(eventHandler);
    }

    public boolean removeProgressEventHandler(BcEventHandler eventHandler) throws Exception {
        return this.updateEventHandlerList.removeEventHandler(eventHandler);
    }

    public synchronized void download(BcMonitor parentMonitor, String svFilePath, OutputStream os) throws Exception {
        if (parentMonitor != null) {
            parentMonitor.lock();
        }
        this.parentMonitor = parentMonitor;
        this.svFilePath = svFilePath;
        this.os = os;
        this.handleId = null;
        this.isComplete = false;
        this.getHandle();
        this.startThread();
    }

    public void download(BcMonitor parentMonitor, String svFilePath, File destFile, boolean append) throws Exception {
        BcLogUtil.debug("download:svFilePath=" + svFilePath);
        BcLogUtil.debug("download:destFile=" + destFile.getPath());
        this.destFile = destFile;
        BcFileUtil.makeParent(destFile);
        this.loadedSize = 0L;
        if (append) {
            this.loadedSize = this.offset = destFile.length();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(destFile.getPath(), append);
        BufferedOutputStream os = new BufferedOutputStream(fileOutputStream);
        this.download(parentMonitor, svFilePath, os);
    }

    public void download(BcMonitor parentMonitor, String svFilePath, File destFile) throws Exception {
        this.download(parentMonitor, svFilePath, destFile, false);
    }

    public void download(BcMonitor parentMonitor, File svFile, File destFile, boolean append) throws Exception {
        this.download(parentMonitor, svFile.getPath(), destFile, append);
    }

    protected void parentUnLock() {
        if (this.parentMonitor != null) {
            this.parentMonitor.unLock();
        }
    }

    protected void getHandle() throws Exception {
        BcLogUtil.debug("RmiFileDownloader.getHandle:svFilePath=" + this.svFilePath);
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(ScfFileRMO.class.getName());
        rmiReq.setMethodName("getDownloadHandle2");
        rmiReq.addData(this.svFilePath);
        rmiReq.addData(this.offset);
        RmiRespons rmiRes = this.rmixAgent.invoke(rmiReq);
        this.handleId = rmiRes.getDataAsString();
        this.fileSize = rmiRes.getDataAsNumber().intValue();
    }

    @Override
    protected void run2() throws Exception {
        block12: {
            try {
                try {
                    do {
                        this.binaryDataLoad();
                    } while (!this.isComplete);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                    try {
                        this.os.close();
                    }
                    catch (Exception ex2) {
                        BcLogUtil.error(ex2);
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.os.close();
                }
                catch (Exception ex2) {
                    BcLogUtil.error(ex2);
                }
                throw throwable;
            }
            try {
                this.os.close();
            }
            catch (Exception ex2) {
                BcLogUtil.error(ex2);
            }
        }
        this.stopThread();
        this.parentUnLock();
    }

    protected void binaryDataLoad() throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(ScfFileRMO.class.getName());
        rmiReq.setMethodName("getBinary");
        rmiReq.addData(this.handleId);
        rmiReq.addData(this.getChunkSize());
        RmiRespons rmiRes = this.rmixAgent.invoke(rmiReq);
        long byteSize = rmiRes.getDataAsNumber().longValue();
        byte[] bytes = rmiRes.getDataAsByteArray();
        if (byteSize > 0L) {
            this.os.write(bytes, 0, (int)byteSize);
            this.loadedSize += byteSize;
            BcProgressEvent updateEvent = new BcProgressEvent(this);
            updateEvent.max = this.fileSize;
            updateEvent.value = this.loadedSize;
            this.updateEventHandlerList.fireEvent(null);
        } else {
            this.isComplete = true;
        }
    }

    public boolean isComplete() {
        return this.isComplete;
    }
}

