/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.fx;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.fx.control.FxTabPane;
import jp.co.extreme.fx.extension.FxxAbstractDesktopPane;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.fx.viewer.FxxContentNode;
import jp.co.extreme.fx.viewer.FxxMultiTouchViewPane;
import jp.co.extreme.fx.viewer.FxxUrlEvent;
import jp.co.extreme.module.xfil.model.XfilUriEntityWrap;

public class XfilExplorerPane
extends FxxAbstractDesktopPane {
    protected SplitPane splitPane1 = new SplitPane();
    protected FxTabPane tabPane1 = new FxTabPane();
    protected SplitPane splitPane2 = new SplitPane();
    protected FxBorderPane borderPane1 = new FxBorderPane();
    public FxxMultiTouchViewPane multiTouchViewPane1 = new FxxMultiTouchViewPane();
    protected FxBorderPane borderPane2 = new FxBorderPane();
    public FxxMultiTouchViewPane multiTouchViewPane2 = new FxxMultiTouchViewPane();
    protected EventHandler<? super FxxUrlEvent> eventHandler;
    protected Stage stage;

    public XfilExplorerPane() throws Exception {
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.splitPane1.setOrientation(Orientation.HORIZONTAL);
        this.tabPane1.setMinWidth(240.0);
        this.splitPane1.getItems().addAll((Object[])new Node[]{this.tabPane1, this.splitPane2});
        this.splitPane1.setDividerPositions(new double[]{0.2f, 0.8f});
        this.splitPane2.setOrientation(Orientation.VERTICAL);
        this.splitPane2.getItems().addAll((Object[])new Node[]{this.borderPane1, this.borderPane2});
        this.splitPane2.setDividerPositions(new double[]{0.7f, 0.3f});
        this.borderPane1.setCenter((Node)this.multiTouchViewPane1);
        this.borderPane2.setCenter((Node)this.multiTouchViewPane2);
        this.setCenter((Node)this.splitPane1);
        FxUtil.defaultInitialize((Node)this);
    }

    public void addTab(Node node, int index) throws Exception {
        Tab tab = new Tab();
        tab.setGraphic((Node)FxImageHelper.createImageView_icon("table_64x64.png"));
        tab.setContent(node);
        if (index < 0) {
            this.tabPane1.getTabs().add((Object)tab);
            this.tabPane1.getSelectionModel().select((Object)tab);
        } else {
            this.tabPane1.getTabs().add(index, (Object)tab);
        }
    }

    public void clear() throws Exception {
        this.multiTouchViewPane1.clear();
        this.multiTouchViewPane2.clear();
    }

    public void setEventHandler(EventHandler<? super FxxUrlEvent> eventHandler) throws Exception {
        this.eventHandler = eventHandler;
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
    }

    public void addUriEntityWrap(XfilUriEntityWrap uriEntityWrap) throws Exception {
        FxxContentNode node = this.multiTouchViewPane1.addUri(uriEntityWrap.uri);
        node.setOnMouseClicked(ev -> {
            if (this.eventHandler != null) {
                EventType<FxxUrlEvent> eventType = null;
                eventType = ev.getClickCount() == 2 ? FxxUrlEvent.EXE : FxxUrlEvent.SELECTED;
                FxxUrlEvent urlEvent = new FxxUrlEvent(uriEntityWrap, null, eventType);
                this.eventHandler.handle(urlEvent);
            }
        });
    }

    public boolean show(Window ownerWindow) throws Exception {
        this.stage = new FxStage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.init();
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        FxUtil.setWindowCenter((Window)this.stage, 0.8f);
        this.stage.setTitle("Explorer");
        FxImageHelper.setStageIcon(this.stage);
        this.stage.show();
        return false;
    }
}

