/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.io.File;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.control.FxCheckBox;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxNumberField;
import jp.co.extreme.fx.control.FxTextArea;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.fx.XdtsCommitModeComboBox;
import jp.co.extreme.module.xdts.fx.XdtsProductComboBox;
import jp.co.extreme.module.xdts.model.XdtsProcessCondition;
import jp.co.extreme.scf5.model.ZScfIntProperties;
import jp.co.extreme.scf5.stub.ScfPropertyStub;
import jp.co.extreme.sql.SqlWords;

class XdtsAbstractConditionPane
extends FxBorderPane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField destFilePathField = new FxTextField();
    FxButton destFileChooseButton = FxUtil.createBrowsButton(null);
    FxTextField destDirPathField = new FxTextField();
    FxButton destDirChooseButton = FxUtil.createBrowsButton(null);
    FxTextField errorFilePathField = new FxTextField();
    FxButton errorFileChooseButton = FxUtil.createBrowsButton(null);
    FileChooser fileChooser = new FileChooser();
    DirectoryChooser directoryChooser = new DirectoryChooser();
    FxCheckBox executeQueryCheckBox = new FxCheckBox();
    XdtsCommitModeComboBox commitModeComboBox = new XdtsCommitModeComboBox();
    FxCheckBox ignoreExceptionCheckBox = new FxCheckBox();
    FxCheckBox recreateTableCheckBox = new FxCheckBox();
    FxCheckBox truncateTableCheckBox = new FxCheckBox();
    FxCheckBox copyRowsCheckBox = new FxCheckBox();
    FxNumberField rowCountUnitField = new FxNumberField(10, 0, false);
    FxTextArea conditionTextArea = new FxTextArea();
    XdtsProductComboBox productComboBox = new XdtsProductComboBox();
    FxTextField newTableNameField = new FxTextField("${tableName}");
    Stage stage;

    public XdtsAbstractConditionPane(Stage stage) throws Exception {
        this.stage = stage;
        this.setCenter((Node)this.centerPane);
        this.executeQueryCheckBox.setOnAction(this.actionEventHandler);
        this.executeQueryCheckBox.setSelected(true);
    }

    protected void setDestFile() throws Exception {
        this.destFilePathField.setPrefColumnCount(100);
        this.destFileChooseButton.setOnAction(this.actionEventHandler);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().sqlOutputFile), new Node[]{this.destFilePathField, this.destFileChooseButton});
        this.centerPane.addNodeUnit(nodeUnit);
    }

    protected void setDestDir() throws Exception {
        this.destDirPathField.setPrefColumnCount(100);
        this.destDirChooseButton.setOnAction(this.actionEventHandler);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().sqlOutputDir), new Node[]{this.destDirPathField, this.destDirChooseButton});
        this.centerPane.addNodeUnit(nodeUnit);
    }

    protected void setErrorFile() throws Exception {
        this.errorFilePathField.setPrefColumnCount(100);
        this.errorFileChooseButton.setOnAction(this.actionEventHandler);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().exceptionOutputFile), new Node[]{this.errorFilePathField, this.errorFileChooseButton});
        this.centerPane.addNodeUnit(nodeUnit);
    }

    protected void setExecuteSql() throws Exception {
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().executeSql), new Node[]{this.executeQueryCheckBox});
        this.centerPane.addNodeUnit(nodeUnit);
    }

    protected void setCommitMode() throws Exception {
        this.commitModeComboBox.getSelectionModel().select(0);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().commitMode), new Node[]{this.commitModeComboBox});
        this.centerPane.addNodeUnit(nodeUnit);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().ignoreSqlException), new Node[]{this.ignoreExceptionCheckBox});
        this.centerPane.addNodeUnit(nodeUnit);
    }

    protected void setRowCopyOption() throws Exception {
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().recreateTable), new Node[]{this.recreateTableCheckBox});
        this.centerPane.addNodeUnit(nodeUnit);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(SqlWords.getInstance().truncateTable.toPlain()), new Node[]{this.truncateTableCheckBox});
        this.centerPane.addNodeUnit(nodeUnit);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().copyRows), new Node[]{this.copyRowsCheckBox});
        this.centerPane.addNodeUnit(nodeUnit);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().copyRowsUnit), new Node[]{this.rowCountUnitField});
        this.centerPane.addNodeUnit(nodeUnit);
    }

    protected void setTargetProdct() throws Exception {
        this.productComboBox.getSelectionModel().select(0);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(XdtsWords.getInstance().targetProduct), new Node[]{this.productComboBox});
        this.centerPane.addNodeUnit(nodeUnit);
    }

    protected void getCondition(XdtsProcessCondition processCondition) throws Exception {
        processCondition.destFilePath = this.destFilePathField.getText();
        processCondition.destDirPath = this.destDirPathField.getText();
        processCondition.errorFilePath = this.errorFilePathField.getText();
        processCondition.executeQuery = this.executeQueryCheckBox.isSelected();
        processCondition.commitMode = this.commitModeComboBox.getCommitMode();
        processCondition.recreateTable = this.recreateTableCheckBox.isSelected();
        processCondition.truncateTable = this.truncateTableCheckBox.isSelected();
        processCondition.copyRow = this.copyRowsCheckBox.isSelected();
        processCondition.copyRowUnit = this.rowCountUnitField.getBigDecimal().longValue();
        processCondition.ignoreException = this.ignoreExceptionCheckBox.isSelected();
        processCondition.query = this.conditionTextArea.getText();
        processCondition.databaseProduct = this.productComboBox.getDatabaseProduct();
        processCondition.newTableName = this.newTableNameField.getText();
        ZScfIntProperties intProps = new ZScfIntProperties();
        intProps.put((Integer)XdtsConstants.Property.destFile.id, this.destFilePathField.getText());
        intProps.put((Integer)XdtsConstants.Property.destDir.id, this.destDirPathField.getText());
        intProps.put((Integer)XdtsConstants.Property.errorFile.id, this.errorFilePathField.getText());
        ScfPropertyStub.getInstance().putProperties(XdtsConstants.TableName.xdts_property.name(), intProps);
    }

    protected void setCondition(XdtsProcessCondition processCondition) throws Exception {
        this.destFilePathField.setText(processCondition.destFilePath);
        this.destDirPathField.setText(processCondition.destDirPath);
        this.errorFilePathField.setText(processCondition.errorFilePath);
        this.executeQueryCheckBox.setSelected(processCondition.executeQuery);
        this.commitModeComboBox.setCommitMode(processCondition.commitMode);
        this.recreateTableCheckBox.setSelected(processCondition.recreateTable);
        this.truncateTableCheckBox.setSelected(processCondition.truncateTable);
        this.copyRowsCheckBox.setSelected(processCondition.copyRow);
        this.rowCountUnitField.setValue(processCondition.copyRowUnit);
        this.ignoreExceptionCheckBox.setSelected(processCondition.ignoreException);
        this.conditionTextArea.setText(processCondition.query);
        if (processCondition.databaseProduct != null) {
            this.productComboBox.setProductId(processCondition.databaseProduct.id);
        }
        this.newTableNameField.setText(processCondition.newTableName);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource().hashCode() == ((Object)((Object)this.destFileChooseButton)).hashCode()) {
            FxUtil.initFileChooser(this.fileChooser, this.destFilePathField.getText());
            File file = this.fileChooser.showSaveDialog((Window)this.stage);
            if (file != null) {
                this.destFilePathField.setText(file.getPath());
            }
        } else if (ev.getSource().hashCode() == ((Object)((Object)this.destDirChooseButton)).hashCode()) {
            FxUtil.initDirectoryChooser(this.directoryChooser, this.destDirPathField.getText());
            File file = this.directoryChooser.showDialog((Window)this.stage);
            if (file != null) {
                this.destDirPathField.setText(file.getPath());
            }
        } else if (ev.getSource().hashCode() == ((Object)((Object)this.errorFileChooseButton)).hashCode()) {
            FxUtil.initFileChooser(this.fileChooser, this.errorFilePathField.getText());
            File file = this.fileChooser.showSaveDialog((Window)this.stage);
            if (file != null) {
                this.errorFilePathField.setText(file.getPath());
            }
        } else if (ev.getSource().hashCode() == ((Object)((Object)this.executeQueryCheckBox)).hashCode()) {
            this.commitModeComboBox.setDisable(!this.executeQueryCheckBox.isSelected());
        }
    }
}

