/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.dcmn.rmo;

import java.io.File;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.doc.util.DcfBookFile;
import jp.co.extreme.module.dcmn.server.DcmnDocumentHandle;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.rmo.RmiAbstractRMO;
import jp.co.extreme.scf.server.ScfServerContainer;
import jp.co.extreme.scf.server.ScfServerLoggerManager;
import jp.co.extreme.sql.context.SqlContext;
import nlc.lib.doc.DcfPage;

public abstract class DcmnAbstractReportRMO
extends RmiAbstractRMO {
    protected RmiRmoArgument rmoArg;
    protected DcfBookFile bookFile1;
    protected DtsSession dtsSession;
    protected SqlContext sqlContext;
    protected BcLogger serverLogger;

    public void createDocument(RmiRmoArgument rmoArg) throws Exception {
        this.rmoArg = rmoArg;
        String loggerHandleId = (String)rmoArg.getRequest().getObject("lhId");
        this.serverLogger = ScfServerLoggerManager.getInstance().getLogger(loggerHandleId);
        this.dtsSession = rmoArg.getDtsSession(this);
        this.sqlContext = this.dtsSession.getSqlContext();
        this.bookFile1 = new DcfBookFile();
        this.process();
    }

    public File createTempFile() throws Exception {
        File docDir = new File(AfbApplication.getInstance().toReal("${APP}data/doc/"));
        if (!docDir.exists()) {
            docDir.mkdirs();
        }
        File file = File.createTempFile("doc", ".tmp", docDir);
        return file;
    }

    public void process() throws Exception {
        this.bookFile1.setWriteMode(AfbApplication.getInstance().getTempDir());
        this.createReport();
        this.serverLogger.debug("===========================================================================");
        this.serverLogger.debug("pageFiler1.getPageCount()=" + this.bookFile1.getPageCount());
        if (this.bookFile1.getPageCount() > 0) {
            File destZipFile = this.createTempFile();
            this.serverLogger.debug("destZipFile=" + destZipFile.getPath());
            this.bookFile1.toZipFile(destZipFile);
            DcmnDocumentHandle docHandle = new DcmnDocumentHandle(this.rmoArg.getAgent());
            docHandle.setBook(this.bookFile1);
            ScfServerContainer.getInstance().getHandleManager().addHandle(docHandle);
            this.rmoArg.getRespons().addData(docHandle.getHandleId());
            this.rmoArg.getRespons().addData(destZipFile.getPath());
        } else {
            this.serverLogger.debug("page=0");
        }
        this.bookFile1.close();
    }

    public abstract void createReport() throws Exception;

    public final void replace(DcfPage page, int pageNo, int pageCount) throws Exception {
    }
}

