/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.html.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.base.util.BcHtmlConverter;
import jp.co.extreme.base.util.BcWordPack;
import jp.co.extreme.html.common.HtmlBuilder;

public final class EtcHtmlUtil {
    static HtmlBuilder htmlBuilder = HtmlBuilder.getInstance();
    static BcHtmlConverter htmlConverter = new BcHtmlConverter();

    private EtcHtmlUtil() {
    }

    public static String connectBrTag(Collection elemCollection, boolean htmlTag, boolean isCenter) {
        StringBuilder sb = new StringBuilder();
        for (Object element : elemCollection) {
            if (element == null) continue;
            if (!BcStringUtil.isEmpty(sb)) {
                sb.append(htmlBuilder.br());
            }
            sb.append(element.toString());
        }
        if (isCenter) {
            sb = new StringBuilder(htmlBuilder.center(sb.toString()));
        }
        if (htmlTag) {
            sb = new StringBuilder(htmlBuilder.html(sb.toString(), false));
        }
        return sb.toString();
    }

    public static String connectBrTag(boolean htmlTag, boolean isCenter, String ... strs) {
        return EtcHtmlUtil.connectBrTag(Arrays.asList(strs), htmlTag, isCenter);
    }

    public static String connectBrTag(boolean htmlTag, String ... strs) {
        return EtcHtmlUtil.connectBrTag(htmlTag, false, strs);
    }

    public static String connectBrTagCenter(Collection elemCollection) {
        return EtcHtmlUtil.connectBrTag(elemCollection, true, true);
    }

    public static String connectBrTagCenter(String ... strs) {
        return EtcHtmlUtil.connectBrTagCenter(Arrays.asList(strs));
    }

    public static List<String> toStringList(CharSequence charSequence) throws Exception {
        List<String> strList = null;
        strList = EtcHtmlUtil.isHtml(charSequence.toString()) ? htmlConverter.toPlainList(charSequence, true) : MmdUtil.splitTableColumnNameAsList(charSequence.toString());
        return strList;
    }

    public static boolean isHtml(String str1) {
        String str2 = BcStringUtil.trim(str1);
        if (BcStringUtil.isEmpty(str2)) {
            return false;
        }
        HtmlBuilder htmlBuilder = HtmlBuilder.getInstance();
        String str3 = str2.toUpperCase();
        return str3.startsWith(htmlBuilder.html_start(false).toUpperCase());
    }

    public static String toHtml(Object ... objects) {
        StringBuilder sb = new StringBuilder();
        sb.append(htmlBuilder.html_start(false));
        sb.append(htmlBuilder.center_start());
        sb.append(EtcHtmlUtil.toHtml2(objects));
        sb.append(htmlBuilder.center_end());
        sb.append(htmlBuilder.html_end());
        return sb.toString();
    }

    private static String toHtml2(Object ... objects) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            if (i > 0) {
                sb.append(htmlBuilder.br(false));
            }
            if (object instanceof BcWordPack) {
                BcWordPack wordPack = (BcWordPack)object;
                sb.append(EtcHtmlUtil.toHtml3(wordPack));
            } else {
                sb.append(BcStringUtil.toStringNotNull(object));
            }
            ++i;
        }
        if (BcStringUtil.isEmpty(sb)) {
            sb.append("N/A");
        }
        return sb.toString();
    }

    private static String toHtml3(BcWordPack wordPack) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < wordPack.objects.length) {
            Object object = wordPack.objects[i];
            if (i > 0) {
                if (wordPack.lineBreak) {
                    sb.append(htmlBuilder.br(false));
                } else if (!wordPack.connect) {
                    sb.append(BcStringUtil.SPACE_STR);
                }
            }
            if (object instanceof BcWordPack) {
                BcWordPack wordPack2 = (BcWordPack)object;
                sb.append(EtcHtmlUtil.toHtml3(wordPack2));
            } else {
                sb.append(EtcHtmlUtil.toHtml2(object));
            }
            ++i;
        }
        return sb.toString();
    }
}

