/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.util;

import java.awt.Component;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.stage.Window;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcExceptionHandler;
import jp.co.extreme.base.util.BcWarningException;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.swing.SwgOptionPane;

public class FxExceptionHandler
implements BcExceptionHandler {
    @Override
    public void handleException(final Throwable \uff54hrowable, final Object source) {
        if (Platform.isFxApplicationThread()) {
            this.handleException2(\uff54hrowable, source);
        } else {
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    FxExceptionHandler.this.handleException2(\uff54hrowable, source);
                }
            });
        }
    }

    protected void handleException2(Throwable \uff54hrowable, Object source) {
        String message = null;
        int messageType = 0;
        String title = BcWords.getInstance().exception;
        if (\uff54hrowable instanceof BcWarningException) {
            BcLogUtil.warning(\uff54hrowable);
            BcWarningException warningException = (BcWarningException)\uff54hrowable;
            message = warningException.getMessage();
            messageType = 2;
            title = BcWords.getInstance().warning;
        } else {
            BcLogUtil.error(\uff54hrowable);
            message = BcLogUtil.convertMessage(\uff54hrowable);
            messageType = 0;
            title = BcWords.getInstance().exception;
        }
        if (source == null) {
            FxOptionPane.showMessageDialog(message, title, messageType);
            return;
        }
        if (source instanceof Node) {
            Node node = (Node)source;
            Window ownerWindow = FxUtil.getWindow(node);
            FxOptionPane.showMessageDialog(ownerWindow, (Object)message, title, messageType);
            return;
        }
        if (source instanceof Component) {
            Component component = (Component)source;
            SwgOptionPane.showMessageDialog(component, message, title, messageType);
            return;
        }
    }
}

