/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.datechooser;

import java.util.Date;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.fx.datechooser.FxDateChooser;
import jp.co.extreme.fx.datechooser.FxDateChooserSkin;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.util.FxImageHelper;

public class FxDateChooserPane
extends FxBorderPane {
    protected FxDateChooser dateChooser = new InnerDateChooser();
    protected Date date;
    protected Stage stage;

    public FxDateChooserPane() {
        StackPane stackPane = new StackPane();
        stackPane.getChildren().add((Object)this.dateChooser);
        this.setCenter((Node)stackPane);
    }

    public void close() {
        this.stage.close();
    }

    public Date show(Window ownerWindow, Date initDate) throws Exception {
        this.date = initDate;
        this.stage = new FxStage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        FxScene scene = new FxScene((Parent)this);
        scene.getStylesheets().add((Object)FxDateChooserSkin.class.getResource("lcd.css").toExternalForm());
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(300.0);
        this.stage.setHeight(250.0);
        this.stage.setResizable(false);
        FxImageHelper.setStageIcon(this.stage);
        this.stage.showAndWait();
        return this.date;
    }

    class InnerDateChooser
    extends FxDateChooser {
        InnerDateChooser() {
        }

        @Override
        public void selected(Date date) {
            BcLogUtil.debug("selected:getDate()" + this.getDate());
            FxDateChooserPane.this.date = this.getDate();
            FxDateChooserPane.this.close();
        }
    }
}

