/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.core;

import java.util.Calendar;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.util.BcKanaUtil;
import jp.co.extreme.base.util.BcRomanUtil;

public final class BcTimeUtil_JP {
    public static final String FORMAT_yyyy\u5e74M\u6708d\u65e5 = "yyyy'\u5e74'M'\u6708'd'\u65e5'";
    public static final String FORMAT_yyyy\u5e74MM\u6708dd\u65e5 = "yyyy'\u5e74'MM'\u6708'dd'\u65e5'";
    public static final String FORMAT_MM\u6708dd\u65e5 = "MM'\u6708'dd'\u65e5'";
    public static final String[] dayOfWeekNameJpArray = new String[]{"\u65e5", "\u6708", "\u706b", "\u6c34", "\u6728", "\u91d1", "\u571f"};

    private BcTimeUtil_JP() {
    }

    public static Era findEra(int yyyyMMdd) throws Exception {
        int dateWk = 99999999;
        Era[] eraArray = Era.values();
        int n = eraArray.length;
        int n2 = 0;
        while (n2 < n) {
            Era era = eraArray[n2];
            if (yyyyMMdd >= era.startDate && yyyyMMdd < dateWk) {
                return era;
            }
            dateWk = era.startDate;
            ++n2;
        }
        return null;
    }

    public static Era findEra(Calendar calendar) throws Exception {
        int yyyyMMdd = BcTimeUtil.toYyyyMMdd(calendar);
        return BcTimeUtil_JP.findEra(yyyyMMdd);
    }

    public static Era findEraByName(String eraName) {
        Era era = null;
        try {
            era = Era.valueOf(eraName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return era;
    }

    public static Era findEraByAny(String str) {
        Era[] eraArray = Era.values();
        int n = eraArray.length;
        int n2 = 0;
        while (n2 < n) {
            Era era = eraArray[n2];
            try {
                if (BcTimeUtil_JP.findEraByAny_L2(era, str)) {
                    return era;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }

    private static boolean findEraByAny_L2(Era era, String str) throws Exception {
        if (BcStringUtil.isEmpty(str)) {
            return false;
        }
        String str2 = str.trim();
        if (era.name().equals(str2)) {
            return true;
        }
        String nameRoman = BcStringUtil.toLatinBasic(str2, 2).toString().toUpperCase();
        nameRoman = BcKanaUtil.hiraganaToZenKana(nameRoman, 2).toString();
        nameRoman = BcKanaUtil.hanKanaToZenKana(nameRoman, 2).toString();
        nameRoman = BcRomanUtil.zenKanaToRoman(nameRoman, 2);
        if (BcStringUtil.equalsIgnoreCase(era.getRomanLetters(), nameRoman)) {
            return true;
        }
        String initials = era.getRomanLetters().substring(0, 1);
        return BcStringUtil.equalsIgnoreCase(initials, nameRoman);
    }

    public static int getEraYear(Era era, int yyyy) throws Exception {
        int startYyyy = BcTimeUtil.toCalendar(era.startDate).get(1);
        return yyyy - startYyyy + 1;
    }

    public static int getEraYear(Era era, Calendar calendar) throws Exception {
        int yyyy = calendar.get(1);
        return BcTimeUtil_JP.getEraYear(era, yyyy);
    }

    public static int getEraStartDateByEraName(String eraName) {
        Era era = BcTimeUtil_JP.findEraByName(eraName);
        if (era != null) {
            return era.startDate;
        }
        return -1;
    }

    public static int getEraStartDateByAny(String eraName) {
        Era era = BcTimeUtil_JP.findEraByAny(eraName);
        if (era != null) {
            return era.startDate;
        }
        return -1;
    }

    public static int toYyyy(Era era, int eraYear) throws Exception {
        Calendar calendar = BcTimeUtil.toCalendar(era.startDate);
        int year = calendar.get(1);
        return year + eraYear - 1;
    }

    public static String toJpString(Calendar calendar, boolean isGannen) throws Exception {
        int mm = calendar.get(2) + 1;
        int dd = calendar.get(5);
        StringBuilder sb = new StringBuilder();
        Era era = BcTimeUtil_JP.findEra(calendar);
        if (era != null) {
            sb.append(era.name());
            int eraYear = BcTimeUtil_JP.getEraYear(era, calendar.get(1));
            if (isGannen) {
                if (eraYear == 1) {
                    sb.append("\u5143");
                } else {
                    sb.append(Integer.toString(eraYear));
                }
            } else {
                sb.append(Integer.toString(eraYear));
            }
        } else {
            sb.append(calendar.get(1));
        }
        sb.append("\u5e74" + mm + "\u6708" + dd + "\u65e5");
        return sb.toString();
    }

    public static String toJpString(int yyyyMMdd, boolean isGannen) throws Exception {
        Calendar calendar = BcTimeUtil.toCalendar(yyyyMMdd);
        return BcTimeUtil_JP.toJpString(calendar, isGannen);
    }

    public static String toJpString(Calendar calendar) throws Exception {
        return BcTimeUtil_JP.toJpString(calendar, false);
    }

    public static String toDayOfWeekName(int dayOfWeekId) throws Exception {
        return dayOfWeekNameJpArray[dayOfWeekId - 1];
    }

    public static String toDayOfWeekName(Calendar calendar) throws Exception {
        if (calendar == null) {
            return null;
        }
        return BcTimeUtil_JP.toDayOfWeekName(calendar.get(7));
    }

    public static enum Era {
        \u4ee4\u548c(20190501, "Reiwa"),
        \u5e73\u6210(19890108, "Heisei"),
        \u662d\u548c(19261225, "Syowa"),
        \u5927\u6b63(19120730, "Taisyo"),
        \u660e\u6cbb(18680125, "Meiji"),
        \u6176\u5fdc(18650501, "Keio"),
        \u5143\u6cbb(18640327, "Genji");

        private int startDate;
        private String romanLetters;
        private String code;

        private Era(int startDate, String romanLetters) {
            this.startDate = startDate;
            this.romanLetters = romanLetters;
            this.code = romanLetters.substring(0, 1);
        }

        public int getStartDate() {
            return this.startDate;
        }

        public String getRomanLetters() {
            return this.romanLetters;
        }

        public String getCode() {
            return this.code;
        }
    }
}

