/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.base.log;

import jp.co.extreme.base.log.BcLogConstants;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.log.BcLoggerFactoryLog4j;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class BcLoggerLog4j
implements BcLogger {
    private Logger l4Logger;
    private BcLogger bindLogger;

    @Override
    public String getName() {
        return this.l4Logger.getName();
    }

    @Override
    public void setLogLevel(BcLogConstants.LogLevel logLevel) {
        Level log4JLevel = BcLoggerFactoryLog4j.tol4Level(logLevel);
        BcLoggerFactoryLog4j.setAllLevels(this.l4Logger.getName(), log4JLevel);
    }

    @Override
    public BcLogConstants.LogLevel getLogLevel() {
        return BcLoggerFactoryLog4j.toLogLevel(this.l4Logger.getLevel());
    }

    @Override
    public void fatal(Object log) {
        String str = BcLogUtil.convertMessage(log);
        this.l4Logger.fatal(str);
        if (this.bindLogger != null) {
            this.bindLogger.fatal(str);
        }
    }

    @Override
    public void error(Object log) {
        String str = BcLogUtil.convertMessage(log);
        this.l4Logger.error(str);
        if (this.bindLogger != null) {
            this.bindLogger.error(str);
        }
    }

    @Override
    public void warning(Object log) {
        String str = BcLogUtil.convertMessage(log);
        this.l4Logger.warn(str);
        if (this.bindLogger != null) {
            this.bindLogger.warning(str);
        }
    }

    @Override
    public void info(Object log) {
        String str = BcLogUtil.convertMessage(log);
        this.l4Logger.info(str);
        if (this.bindLogger != null) {
            this.bindLogger.info(str);
        }
    }

    @Override
    public void debug(Object log) {
        String str = BcLogUtil.convertMessage(log);
        this.l4Logger.debug(str);
        if (this.bindLogger != null) {
            this.bindLogger.debug(str);
        }
    }

    @Override
    public void trace(Object log) {
        String str = BcLogUtil.convertMessage(log);
        this.l4Logger.trace(str);
        if (this.bindLogger != null) {
            this.bindLogger.trace(str);
        }
    }

    @Override
    public void bind(BcLogger bindLogger) {
        this.bindLogger = bindLogger;
    }

    public Logger getL4Logger() {
        return this.l4Logger;
    }

    public void setL4Logger(Logger l4Logger) {
        this.l4Logger = l4Logger;
    }
}

