/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.app.common;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URL;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.co.extreme.app.common.AfbApplicationContext;
import jp.co.extreme.app.common.AfbApplicationEvent;
import jp.co.extreme.app.common.AfbApplicationEventHandler;
import jp.co.extreme.app.common.AfbApplicationSetupProxy;
import jp.co.extreme.app.common.AfbConstants;
import jp.co.extreme.app.common.AfbLogUtil;
import jp.co.extreme.app.common.AfbShutdownManager;
import jp.co.extreme.app.common.AfbSingleInstanceHelper;
import jp.co.extreme.app.common.AfbXmlUtil;
import jp.co.extreme.awt.AwtImageHelper;
import jp.co.extreme.awt.AwtImageUtil;
import jp.co.extreme.base.charset.BcCharsetNames;
import jp.co.extreme.base.charset.BcUtf8Util;
import jp.co.extreme.base.core.BcJavaConstants;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.io.BcStreamUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.runtime.BcRuntimeContext;
import jp.co.extreme.base.runtime.BcRuntimeUtil;
import jp.co.extreme.base.thread.BcMonitor;
import jp.co.extreme.base.util.BcArgumentUtil;
import jp.co.extreme.base.util.BcCipherUtil;
import jp.co.extreme.base.xml.BcXmlUtil;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AfbApplication
extends BcLoggableObject
implements Serializable {
    private static final long serialVersionUID = -3388841829444427001L;
    private static BcRuntimeContext runtimeContext = new BcRuntimeContext();
    private String[] mainArgs;
    private int exitCode;
    private BcMonitor monitor = new BcMonitor();
    private File rootDir;
    private File logDir;
    private File tempDir;
    private File commonDir;
    private String configDirStr;
    private Document bootConfig;
    private Document generalConfigDom;
    private AfbApplicationContext appContext = new AfbApplicationContext();
    private Locale locale;
    public Properties properties = new Properties();
    public List<AfbApplicationEventHandler> applicationEventHandlerList = new ArrayList<AfbApplicationEventHandler>();
    private Map<String, String> fileAliasMap = new HashMap<String, String>();
    public boolean bootEnabled = true;
    public String lockFileName = ".lock";
    public String logFileName = "general.log";
    public Class setupClass;
    public boolean isDebug;
    private List<String> taskIdList = new ArrayList<String>();

    static {
        try {
            runtimeContext.setSystemProperties(System.getProperties());
            AfbApplication.runtimeContext.hostAddress = InetAddress.getLocalHost().getHostAddress();
            AfbApplication.runtimeContext.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
    }

    private AfbApplication() {
        try {
            this.setRootDirectry(BcRuntimeUtil.getUserDir());
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
        }
        AfbShutdownManager.getInstance();
        this.setLocale(Locale.getDefault());
    }

    public static AfbApplication getInstance() {
        return SingletonHolder.instance;
    }

    public BcRuntimeContext getRuntimeContext() {
        return runtimeContext;
    }

    public String[] getMainArguments() {
        return this.mainArgs;
    }

    public void setMainArguments(String[] mainArgs) throws Exception {
        this.mainArgs = mainArgs;
        String argValue = BcArgumentUtil.getArgumentValue(mainArgs, "-appRootDir");
        if (BcStringUtil.isEmpty(argValue)) {
            File rootDir1 = null;
            URL jarFileUrl = BcRuntimeUtil.getStartJarUrl();
            if (jarFileUrl == null) {
                rootDir1 = BcRuntimeUtil.getUserDir();
            } else {
                File jarFile = new File(jarFileUrl.toURI());
                rootDir1 = jarFile.getParentFile().getParentFile();
            }
            this.setRootDirectry(rootDir1);
        } else {
            File rootDir1 = new File(argValue);
            this.setRootDirectry(rootDir1);
        }
        this.configDirStr = BcArgumentUtil.getArgumentValue(mainArgs, "-configDir");
        argValue = BcArgumentUtil.getArgumentValue(mainArgs, "-runMode");
        this.appContext.runMode = BcNumberUtil.parseInt(argValue, -1);
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public File getRootDirectry() {
        return this.rootDir;
    }

    public void setRootDirectry(File rootDir) throws Exception {
        this.rootDir = rootDir;
        this.logDir = new File(this.toReal("${APP}log/"));
        this.tempDir = new File(this.toReal("${APP}temp/"));
    }

    public File getParentDirectry() {
        return this.rootDir.getParentFile();
    }

    public File getCommonDirectry() {
        if (this.commonDir == null) {
            this.commonDir = new File(this.getParentDirectry(), "common");
        }
        return this.commonDir;
    }

    public File getLogDir() {
        return this.logDir;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public AfbApplicationContext getApplicationContext() {
        return this.appContext;
    }

    public String toReal(String vPath) throws Exception {
        StringBuilder sb = BcStringUtil.replace((CharSequence)vPath, "${DATA_DIR}", "${APP}data/");
        sb = BcStringUtil.isEmpty(this.configDirStr) ? BcStringUtil.replace((CharSequence)sb, "${CONFIG_DIR}", "${APP}config/") : BcStringUtil.replace((CharSequence)sb, "${CONFIG_DIR}", this.configDirStr);
        sb = BcStringUtil.replace((CharSequence)sb, "${TEMP_DIR}", "${APP}temp/");
        if (this.getRootDirectry() != null) {
            sb = BcStringUtil.replace((CharSequence)sb, "${APP}", BcFileUtil.toDirectoryPath(this.getRootDirectry()));
            sb = BcStringUtil.replace((CharSequence)sb, "${PARENT_DIR}", BcFileUtil.toDirectoryPath(this.getParentDirectry()));
            sb = BcStringUtil.replace((CharSequence)sb, "${COMMON}", BcFileUtil.toDirectoryPath(this.getCommonDirectry()));
            if (this.getTempDir() != null) {
                sb = BcStringUtil.replace((CharSequence)sb, "${APP}temp/", BcFileUtil.toDirectoryPath(this.getTempDir()));
            }
        }
        if (this.fileAliasMap != null) {
            Set<Map.Entry<String, String>> entrySet = this.fileAliasMap.entrySet();
            for (Map.Entry<String, String> mapEntry : entrySet) {
                sb = BcStringUtil.replace((CharSequence)sb, mapEntry.getKey(), mapEntry.getValue());
            }
        }
        return sb.toString();
    }

    public Document getBootConfig() {
        return this.bootConfig;
    }

    public Document getGeneralConfig() {
        return this.generalConfigDom;
    }

    public void setGeneralConfig(Document generalConfigDom) throws Exception {
        this.generalConfigDom = generalConfigDom;
    }

    public void updateGeneralConfig(Document generalConfigDom) throws Exception {
        this.generalConfigDom = generalConfigDom;
        String filePath = this.toReal("${APP}config/general.xml");
        File file = new File(filePath);
        File tmpFile = File.createTempFile("general", ".tmp", file.getParentFile());
        BcXmlUtil.output(generalConfigDom, tmpFile, true);
        BcFileUtil.deleteIfExists(file);
        BcFileUtil.rename(tmpFile, file);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void startCommon() throws Exception {
        File commonLibDir;
        File libDir;
        String logFilePath = String.valueOf(this.toReal("${APP}log/")) + this.logFileName;
        File logFile = new File(logFilePath);
        BcLogger logger = BcLogUtil.getDefaultLogger();
        BcLogUtil.addFileFileHandler(logger, logFile);
        this.setLogger(logger);
        File binLibDir = new File(this.toReal("${APP}bin/lib/"));
        if (binLibDir.exists()) {
            this.getLogger().info("binLibDir=" + binLibDir.getPath());
            ClassLoader classLoader = BcRuntimeUtil.addClassPath(this.getClass().getClassLoader(), binLibDir);
        }
        if ((libDir = new File(this.toReal("${APP}lib/"))).exists()) {
            this.getLogger().info("libDir=" + libDir.getPath());
            ClassLoader classLoader = BcRuntimeUtil.addClassPath(this.getClass().getClassLoader(), libDir);
        }
        if ((commonLibDir = new File(this.toReal("${COMMON}lib/"))).exists()) {
            this.getLogger().info("commonLibDir=" + commonLibDir.getPath());
            ClassLoader classLoader = BcRuntimeUtil.addClassPath(this.getClass().getClassLoader(), commonLibDir);
        }
    }

    public int start(String[] mainArgs, boolean doWait) {
        try {
            this.start_L2(mainArgs, doWait);
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
            this.setExitCode(AfbConstants.ExitCode.NG.code);
        }
        return this.getExitCode();
    }

    protected void start_L2(String[] mainArgs, boolean doWait) throws Exception {
        File bootConfigDir;
        this.setExitCode(AfbConstants.ExitCode.OK.code);
        this.setMainArguments(mainArgs);
        File lockFile = new File(this.getRootDirectry(), this.lockFileName);
        FileLock fileLock = AfbSingleInstanceHelper.getInstance().tryLock(lockFile);
        if (fileLock == null) {
            this.getLogger().warning("Unlock file." + lockFile.getPath());
            this.setExitCode(11);
            return;
        }
        this.startCommon();
        String bootConfigDirName = BcArgumentUtil.getArgumentValue(mainArgs, "-bootConfig");
        this.fireEvent(new AfbApplicationEvent(this, 41, "Talisker \u8a2d\u5b9a\u60c5\u5831\u3092\u8aad\u8fbc\u307f\u4e2d\u3067\u3059..."));
        if (BcStringUtil.isEmpty(bootConfigDirName)) {
            if (this.bootEnabled) {
                bootConfigDir = new File(this.getRootDirectry(), "BOOT-CONFIG/");
                if (bootConfigDir.exists()) {
                    this.bootConfigByFile(bootConfigDir);
                } else {
                    this.setBootConfigFromZip(null);
                }
            }
        } else {
            bootConfigDir = new File(bootConfigDirName);
            this.bootConfigByFile(bootConfigDir);
        }
        this.getLogger().info(AfbLogUtil.jvmInfo());
        this.getLogger().info(AfbLogUtil.frameworkInfo());
        this.getLogger().info(AfbLogUtil.applicationInfo(this));
        if (doWait) {
            this.monitor.lock();
        }
        this.setAppIconImage();
        AfbApplicationSetupProxy applicationSetupProxy = new AfbApplicationSetupProxy();
        applicationSetupProxy.start(this, this.bootConfig);
        if (doWait) {
            this.monitor.sync();
        }
    }

    public void startForServlet(File bootConfigDir) throws Exception {
        this.getLogger().info("AfbApplication.startForServlet");
        this.startCommon();
        this.bootConfigByFile(bootConfigDir);
        AfbApplicationSetupProxy applicationSetupProxy = new AfbApplicationSetupProxy();
        applicationSetupProxy.start(this, this.bootConfig);
    }

    protected void bootConfigByFile(File bootConfigDir) throws Exception {
        File bootConfigFile = new File(bootConfigDir.getPath(), "config.xml");
        if (!bootConfigFile.exists()) {
            throw new FileNotFoundException("not found:" + bootConfigFile.getPath());
        }
        this.bootConfig = BcXmlUtil.createDocument(bootConfigFile);
        this.parseBootConfig(this.bootConfig);
    }

    protected void parseBootConfig(Document dom) throws Exception {
        List<Node> domNodeList = BcXmlUtil.getNodeList((Node)dom, (short)1);
        int i = 0;
        while (i < domNodeList.size()) {
            Node domNode = domNodeList.get(i);
            if (domNode.getNodeName().equals("developer")) {
                this.node_developer(domNode);
            } else if (domNode.getNodeName().equals("vendor")) {
                this.node_vendor(domNode);
            } else if (domNode.getNodeName().equals("application")) {
                this.node_application(domNode);
            } else if (domNode.getNodeName().equals("setupClass")) {
                this.node_setupClass(domNode);
            } else if (domNode.getNodeName().equals("property")) {
                this.node_property(domNode);
            }
            ++i;
        }
    }

    protected void node_developer(Node node) throws Exception {
        this.appContext.developerName = BcXmlUtil.getTextValue(node, "name");
        this.appContext.developerUrl = BcXmlUtil.getTextValue(node, "url");
        this.appContext.developerCopyright = BcXmlUtil.getTextValue(node, "copyright");
    }

    protected void node_vendor(Node node) throws Exception {
        this.appContext.vendorName = BcXmlUtil.getTextValue(node, "name");
        this.appContext.vendorUrl = BcXmlUtil.getTextValue(node, "url");
        this.appContext.vendorCopyright = BcXmlUtil.getTextValue(node, "copyright");
    }

    protected void node_application(Node node) throws Exception {
        this.appContext.appName = BcXmlUtil.getTextValue(node, "name");
        this.appContext.version = BcXmlUtil.getTextValue(node, "version");
        this.appContext.buildInfo = BcXmlUtil.getTextValue(node, "build");
        this.appContext.serialCode = BcXmlUtil.getTextValue(node, "serialCode");
        String tmpStr = BcXmlUtil.getTextValue(node, "runMode");
        this.appContext.isTrial = Boolean.parseBoolean(BcXmlUtil.getTextValue(node, "trial"));
        this.appContext.termOfValidity = AfbXmlUtil.parseDate(node, "termOfValidity");
    }

    protected void node_setupClass(Node node) throws Exception {
        String tmpStr = BcXmlUtil.getTextValue(node, "class");
        this.setupClass = Class.forName(tmpStr);
    }

    protected void node_property(Node node) throws Exception {
        List<Node> domNodeList2 = BcXmlUtil.getNodeList(node, (short)1);
        int i = 0;
        while (i < domNodeList2.size()) {
            Node nod2 = domNodeList2.get(i);
            if (nod2.getNodeName().equals("entry")) {
                String key = BcXmlUtil.getAttribute(nod2, "key");
                String value = BcXmlUtil.getTextValue(nod2);
                this.properties.setProperty(key, value);
            }
            ++i;
        }
    }

    public void setBootConfigFromZip(String optionPath) throws Exception {
        ArrayList<String> pathList = new ArrayList<String>();
        if (BcStringUtil.isEmpty(optionPath)) {
            String classPath = System.getProperty(BcJavaConstants.SysKey.java_class_path.value);
            String pathSeparator = System.getProperty(BcJavaConstants.SysKey.path_separator.value);
            BcStringUtil.tokenize(classPath, pathSeparator, true, true, pathList);
        } else {
            pathList.add(optionPath);
        }
        int i = 0;
        while (i < pathList.size()) {
            block10: {
                String path = (String)pathList.get(i);
                if (!BcStringUtil.isEmpty(path)) {
                    File file2 = new File(path);
                    if (!file2.exists()) {
                        file2 = new File(String.valueOf(this.getRootDirectry().getPath()) + "/" + path);
                    }
                    if (file2.exists()) {
                        ZipFile zipFile = null;
                        try {
                            zipFile = new ZipFile(file2);
                        }
                        catch (Exception ex) {
                            break block10;
                        }
                        ZipEntry zipEntry = zipFile.getEntry("BOOT-CONFIG/config.dat");
                        if (zipEntry != null) {
                            InputStream is = zipFile.getInputStream(zipEntry);
                            BcUtf8Util.skipBom(is);
                            byte[] bytes = BcStreamUtil.read(is);
                            is.close();
                            String xmlText = BcCipherUtil.decrypt("gw6hdf8s", bytes);
                            ByteArrayInputStream bais = new ByteArrayInputStream(xmlText.getBytes(BcCharsetNames.UTF_8.value));
                            BcUtf8Util.skipBom(bais);
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            BcStreamUtil.transmit(bais, baos, 1024);
                            byte[] bytes2 = baos.toByteArray();
                            ByteArrayInputStream bais2 = new ByteArrayInputStream(bytes2);
                            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                            this.bootConfig = documentBuilder.parse(bais2);
                            this.parseBootConfig(this.bootConfig);
                            break;
                        }
                        zipEntry = zipFile.getEntry("BOOT-CONFIG/config.xml");
                        if (zipEntry != null) {
                            this.bootConfig = BcXmlUtil.createDocument(zipFile.getInputStream(zipEntry));
                            this.parseBootConfig(this.bootConfig);
                            break;
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void exit(int exitCode) {
        this.setExitCode(exitCode);
        this.monitor.unLock();
    }

    public void exit() {
        this.exit(this.getExitCode());
    }

    public boolean addApplicationEventHandler(AfbApplicationEventHandler eventHandler) {
        return this.applicationEventHandlerList.add(eventHandler);
    }

    public boolean removeApplicationEventHandler(AfbApplicationEventHandler eventHandler) {
        return this.applicationEventHandlerList.remove(eventHandler);
    }

    public void fireEvent(AfbApplicationEvent ev) {
        AfbApplicationEventHandler[] eventHandlers = this.applicationEventHandlerList.toArray(new AfbApplicationEventHandler[0]);
        int i = 0;
        while (i < eventHandlers.length) {
            AfbApplicationEventHandler eventHandler = eventHandlers[i];
            try {
                eventHandler.actionPerformed(ev);
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
            ++i;
        }
    }

    public Map<String, String> getFileAliasMap() {
        return this.fileAliasMap;
    }

    public void setAppIconImage() throws Exception {
        BufferedImage image;
        File imageDir = new File(this.toReal("${APP}resource/image/"));
        File file = new File(imageDir, "app_icon.png");
        if (file.exists() && (image = AwtImageUtil.loadImage(file)) != null) {
            AwtImageHelper.setWindowIconImage(image);
        }
    }

    public void addTask(String taskName) {
        this.taskIdList.add(taskName);
    }

    public void addTask(int id) {
        this.addTask(Integer.toString(id));
    }

    public void removeTask(String name) {
        this.taskIdList.remove(name);
    }

    public void removeTask(int id) {
        this.removeTask(Integer.toString(id));
    }

    public boolean taskExists(String name) {
        return this.taskIdList.indexOf(name) >= 0;
    }

    public boolean taskExists(int id) {
        return this.taskExists(Integer.toString(id));
    }

    /* synthetic */ AfbApplication(AfbApplication afbApplication) {
        this();
    }

    private static final class SingletonHolder {
        private static final AfbApplication instance = new AfbApplication(null);

        private SingletonHolder() {
        }
    }
}

