/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.common;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jp.co.extreme.base.core.BcBooleanUtil;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.mmd.MmdIndexElement;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.datasource.util.DtsWordManager;
import jp.co.extreme.module.mmdx.model.MmdxField;
import jp.co.extreme.module.mmdx.model.MmdxIndex;
import jp.co.extreme.module.mmdx.model.MmdxModel;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.module.xsys.common.XsysConstants;
import jp.co.extreme.poi.PoiWorkbookUtil;
import jp.co.extreme.sql.SqlType;
import jp.co.extreme.sql.context.SqlTableMetadata;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class XdtsDefinitionCreator
extends BcLoggableObject {
    public static final String TAG_tableName = "${tableName}";
    public static final String TAG_tableLogicalName = "${tableLogicalName}";
    public static final String TAG_tableRemark = "${tableRemark}";
    public static final String TAG_schemaName = "${schemaName}";
    public static final String TAG_ordinalPosition = "${ordinalPosition}";
    public static final String TAG_columnName = "${columnName}";
    public static final String TAG_dataType = "${dataType}";
    public static final String TAG_dataSize = "${dataSize}";
    public static final String TAG_nullable = "${nullable}";
    public static final String TAG_columnLogicalName = "${columnLogicalName}";
    public static final String TAG_note = "${note}";
    public static final String TAG_indexName = "${indexName}";
    public static final String TAG_indexIsUnique = "${indexIsUnique}";
    public static final String TAG_isPrimaryIndex = "${isPrimaryIndex}";
    public static final String TAG_indexColumnOrdinalPosition = "${indexColumnOrdinalPosition}";
    public static final String TAG_indexColumnName = "${indexColumnName}";
    public static final String TAG_isAscending = "${isAscending}";
    public static final String TAG_createDate = "${createDate}";
    protected DtsWordManager wordManager;
    protected Map<String, SqlTableMetadata> tableMetadataMap;
    String templateSheetName = "TEMPLATE";

    public void create(List<MmdxModel> mdxList, DtsWordManager wordManager, Map<String, SqlTableMetadata> tableMetadataMap, Workbook workbook) throws Exception {
        this.wordManager = wordManager;
        this.tableMetadataMap = tableMetadataMap;
        boolean isSuccess = false;
        int i = 0;
        while (i < mdxList.size()) {
            int cnt = i + 1;
            if (cnt % 100 == 0) {
                BcLogUtil.info("cnt=" + cnt);
            }
            MmdxModel mdx = mdxList.get(i);
            this.create_L2(mdx, workbook);
            ++i;
        }
        workbook.removeSheetAt(workbook.getSheetIndex(this.templateSheetName));
        XsysConstants.setWorkbookProperties(workbook, null);
    }

    protected void create_L2(MmdxModel mmdxModel, Workbook workbook) throws Exception {
        this.msg("\u30c6\u30fc\u30d6\u30eb\u540d=" + mmdxModel.tableName);
        Sheet templeteHssfSheet = workbook.getSheet(this.templateSheetName);
        int templeteSheetIndex = workbook.getSheetIndex(this.templateSheetName);
        Sheet sheet = PoiWorkbookUtil.cloneSheet(workbook, templeteSheetIndex);
        PoiWorkbookUtil.setSheetName(sheet, mmdxModel.tableName, true);
        PoiWorkbookUtil.replaceText(sheet, TAG_tableName, mmdxModel.tableName);
        String logicalName = this.wordManager.getWord(mmdxModel.tableName, Locale.getDefault().getLanguage());
        PoiWorkbookUtil.replaceText(sheet, TAG_tableLogicalName, logicalName);
        PoiWorkbookUtil.replaceText(sheet, TAG_tableRemark, mmdxModel.note);
        SqlTableMetadata tableMetadata = this.getTableMetadata(mmdxModel.tableName);
        PoiWorkbookUtil.replaceText(sheet, TAG_schemaName, tableMetadata.TABLE_SCHEM);
        Cell cell_ordinalPosition = PoiWorkbookUtil.findCell(sheet, (Object)TAG_ordinalPosition);
        if (cell_ordinalPosition != null) {
            Row row_templete_columnOrdinalPosition = sheet.getRow(cell_ordinalPosition.getRowIndex());
            int i = 0;
            while (i < mmdxModel.getFieldCount()) {
                MmdxField mmdxField = mmdxModel.getField(i);
                this.create_L3(mmdxModel, mmdxField, sheet, row_templete_columnOrdinalPosition);
                ++i;
            }
            this.msg("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u884c\u3092\u524a\u9664\u4e2d...");
            PoiWorkbookUtil.removeRow(sheet, row_templete_columnOrdinalPosition.getRowNum());
        }
        this.createIndexInfo(mmdxModel, sheet);
        Calendar now = BcTimeUtil.createCalendar();
        String dateStr = BcTimeUtil.toString(now, "yyyy/MM/dd");
        PoiWorkbookUtil.replaceText(sheet, TAG_createDate, dateStr);
    }

    protected void create_L3(MmdxModel mdx, MmdxField mmdxField, Sheet sheet, Row row_templete_columnOrdinalPosition) throws Exception {
        int rowId = row_templete_columnOrdinalPosition.getRowNum() + mmdxField.ordinalPosition;
        Row ssRow2 = PoiWorkbookUtil.insertRow(sheet, rowId);
        PoiWorkbookUtil.copyRow(sheet, row_templete_columnOrdinalPosition, ssRow2, false);
        PoiWorkbookUtil.replaceText(ssRow2, TAG_ordinalPosition, Integer.toString(mmdxField.ordinalPosition));
        PoiWorkbookUtil.replaceText(ssRow2, TAG_columnName, mmdxField.columnName);
        SqlType sqlType = SqlType.getById(mmdxField.sqlTypeId);
        String sqlTypeStr = null;
        sqlTypeStr = sqlType != null ? sqlType.name() : Integer.toString(mmdxField.sqlTypeId);
        PoiWorkbookUtil.replaceText(ssRow2, TAG_dataType, sqlTypeStr);
        String dataSizeStr = null;
        dataSizeStr = BcNumberUtil.toString(mmdxField.dataSize);
        if (sqlType == SqlType.DECIMAL || sqlType == SqlType.NUMERIC) {
            dataSizeStr = String.valueOf(dataSizeStr) + ",";
            dataSizeStr = String.valueOf(dataSizeStr) + Integer.toString(mmdxField.decimalDigit);
        }
        PoiWorkbookUtil.replaceText(ssRow2, TAG_dataSize, dataSizeStr);
        PoiWorkbookUtil.replaceText(ssRow2, TAG_nullable, BcBooleanUtil.toYN(mmdxField.nullable));
        String logicalName = XdtsUtil.getLogicalName(mdx.logicalName, mmdxField, this.wordManager);
        PoiWorkbookUtil.replaceText(ssRow2, TAG_columnLogicalName, logicalName);
        PoiWorkbookUtil.replaceText(ssRow2, TAG_note, mmdxField.note);
    }

    protected Map<String, Integer> createIndexMap(MmdxModel mdx, MmdxIndex mmdxIndex) throws Exception {
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        int i = 0;
        while (i < mmdxIndex.indexElementList.size()) {
            MmdIndexElement indexElement = mmdxIndex.indexElementList.get(i);
            String tableColumnName = MmdUtil.createTableColumnName(mdx.logicalName, indexElement.columnName);
            indexMap.put(tableColumnName, i + 1);
            ++i;
        }
        return indexMap;
    }

    protected void createIndexInfo(MmdxModel mmdxModel, Sheet sheet) throws Exception {
        Cell cell1 = PoiWorkbookUtil.findCell(sheet, (Object)TAG_indexName);
        if (cell1 == null) {
            this.getLogger().debug("Not found ${indexName}");
            return;
        }
        Row row_templete_indexName = cell1.getRow();
        Cell cell2 = PoiWorkbookUtil.findCell(sheet, (Object)TAG_indexColumnOrdinalPosition);
        if (cell2 == null) {
            this.getLogger().debug("Not found ${indexColumnOrdinalPosition}");
            return;
        }
        Row row_templete_indexColumnOrdinalPosition = cell2.getRow();
        int gap = row_templete_indexColumnOrdinalPosition.getRowNum() - row_templete_indexName.getRowNum() - 1;
        if (gap < 0) {
            this.getLogger().debug("gap=" + gap);
            return;
        }
        int rowId_insert = row_templete_indexColumnOrdinalPosition.getRowNum() + 1;
        for (Map.Entry<String, MmdxIndex> mapEntry : mmdxModel.indexNameMap.entrySet()) {
            MmdxIndex mmdxIndex = mapEntry.getValue();
            boolean isPrimaryIndex = false;
            if (!BcStringUtil.isEmpty(mmdxModel.primaryIndexName)) {
                isPrimaryIndex = mmdxModel.primaryIndexName.equalsIgnoreCase(mmdxIndex.indexName);
            }
            int rowCount = this.createIndexInfo(mmdxIndex, isPrimaryIndex, sheet, row_templete_indexName, row_templete_indexColumnOrdinalPosition, rowId_insert);
            rowId_insert += rowCount;
            ++rowId_insert;
        }
        this.getLogger().debug("row_templete_indexName.getRowNum()=" + row_templete_indexName.getRowNum());
        this.getLogger().debug("row_templete_indexColumnOrdinalPosition.getRowNum()=" + row_templete_indexColumnOrdinalPosition.getRowNum());
        PoiWorkbookUtil.removeRow(sheet, row_templete_indexName.getRowNum(), row_templete_indexColumnOrdinalPosition.getRowNum());
    }

    protected int createIndexInfo(MmdxIndex mmdxIndex, boolean isPrimaryIndex, Sheet sheet, Row row_templete_indexName, Row row_templete_indexColumnOrdinalPosition, int rowId_insert) throws Exception {
        List<Row> rowList1 = PoiWorkbookUtil.copyInsertRow(sheet, row_templete_indexName.getRowNum(), row_templete_indexColumnOrdinalPosition.getRowNum() - 1, rowId_insert, true);
        Row row_indexName = BcCollectionUtil.getFirst(rowList1);
        PoiWorkbookUtil.replaceText(row_indexName, TAG_indexName, mmdxIndex.indexName);
        PoiWorkbookUtil.replaceText(row_indexName, TAG_indexIsUnique, BcBooleanUtil.toYN(mmdxIndex.isUnique));
        PoiWorkbookUtil.replaceText(row_indexName, TAG_isPrimaryIndex, BcBooleanUtil.toYN(isPrimaryIndex));
        int gap = row_templete_indexColumnOrdinalPosition.getRowNum() - row_templete_indexName.getRowNum() - 1;
        int i = 0;
        while (i < mmdxIndex.indexElementList.size()) {
            MmdIndexElement mmdIndexElement = mmdxIndex.indexElementList.get(i);
            String msg = " ordinalPosition=" + mmdIndexElement.ordinalPosition + "  columnName=" + mmdIndexElement.columnName + " isAscending=" + mmdIndexElement.isAscending;
            this.msg(msg);
            int rowId = row_indexName.getRowNum() + gap + mmdIndexElement.ordinalPosition;
            Row ssRow2 = PoiWorkbookUtil.copyInsertRow(sheet, row_templete_indexColumnOrdinalPosition.getRowNum(), rowId, false);
            PoiWorkbookUtil.replaceText(ssRow2, TAG_indexColumnOrdinalPosition, Integer.toString(mmdIndexElement.ordinalPosition));
            PoiWorkbookUtil.replaceText(ssRow2, TAG_indexColumnName, mmdIndexElement.columnName);
            PoiWorkbookUtil.replaceText(ssRow2, TAG_isAscending, BcBooleanUtil.toYN(mmdIndexElement.isAscending));
            ++i;
        }
        return rowList1.size() + mmdxIndex.indexElementList.size();
    }

    protected SqlTableMetadata getTableMetadata(String tableName) throws Exception {
        SqlTableMetadata tableMetadata = null;
        if (this.tableMetadataMap != null) {
            tableMetadata = this.tableMetadataMap.get(tableName);
        }
        if (tableMetadata == null) {
            tableMetadata = new SqlTableMetadata();
        }
        return tableMetadata;
    }

    protected void msg(String msg) throws Exception {
        this.getLogger().debug(msg);
    }
}

