/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.net;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.net.bsd.RExecClient;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class RExecTask
extends Task {
    private static final int PAUSE_TIME = 250;
    private String userid = null;
    private String password = null;
    private String command = null;
    private String server = null;
    private int port = 512;
    private Vector rexecTasks = new Vector();
    private boolean addCarriageReturn = false;
    private Integer defaultTimeout = null;

    public RExecSubTask createRead() {
        RExecRead task = new RExecRead();
        this.rexecTasks.addElement(task);
        return task;
    }

    public RExecSubTask createWrite() {
        RExecWrite task = new RExecWrite();
        this.rexecTasks.addElement(task);
        return task;
    }

    @Override
    public void execute() throws BuildException {
        if (this.server == null) {
            throw new BuildException("No Server Specified");
        }
        if (this.userid == null && this.password != null) {
            throw new BuildException("No Userid Specified");
        }
        if (this.password == null && this.userid != null) {
            throw new BuildException("No Password Specified");
        }
        AntRExecClient rexec2 = null;
        boolean success = false;
        try {
            try {
                rexec2 = new AntRExecClient();
                try {
                    rexec2.connect(this.server, this.port);
                }
                catch (IOException e) {
                    throw new BuildException("Can't connect to " + this.server);
                }
                if (this.userid != null && this.password != null && this.command != null && this.rexecTasks.size() == 0) {
                    rexec2.rexec(this.userid, this.password, this.command);
                } else {
                    this.handleMultipleTasks(rexec2);
                }
                rexec2.waitForEOF(this.defaultTimeout);
                success = true;
            }
            catch (IOException e) {
                throw new BuildException("Error r-executing command", e);
            }
        }
        finally {
            if (rexec2 != null && rexec2.isConnected()) {
                try {
                    rexec2.disconnect();
                }
                catch (IOException e) {
                    String msg = "Error disconnecting from " + this.server;
                    if (success) {
                        throw new BuildException(msg);
                    }
                    this.log(msg, 0);
                }
            }
        }
    }

    private void login(AntRExecClient rexec2) {
        if (this.addCarriageReturn) {
            rexec2.sendString("\n", true);
        }
        rexec2.waitForString("ogin:");
        rexec2.sendString(this.userid, true);
        rexec2.waitForString("assword:");
        rexec2.sendString(this.password, false);
    }

    public void setCommand(String c) {
        this.command = c;
    }

    public void setInitialCR(boolean b) {
        this.addCarriageReturn = b;
    }

    public void setPassword(String p) {
        this.password = p;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public void setServer(String m) {
        this.server = m;
    }

    public void setTimeout(Integer i) {
        this.defaultTimeout = i;
    }

    public void setUserid(String u) {
        this.userid = u;
    }

    private void handleMultipleTasks(AntRExecClient rexec2) {
        if (this.userid != null && this.password != null) {
            this.login(rexec2);
        }
        Enumeration tasksToRun = this.rexecTasks.elements();
        while (tasksToRun != null && tasksToRun.hasMoreElements()) {
            RExecSubTask task = (RExecSubTask)tasksToRun.nextElement();
            if (task instanceof RExecRead && this.defaultTimeout != null) {
                ((RExecRead)task).setDefaultTimeout(this.defaultTimeout);
            }
            task.execute(rexec2);
        }
    }

    public class AntRExecClient
    extends RExecClient {
        public void waitForString(String s) {
            this.waitForString(s, null);
        }

        /*
         * Unable to fully structure code
         */
        public void waitForString(String s, Integer timeout) {
            is = this.getInputStream();
            try {
                block8: {
                    block7: {
                        sb = new StringBuffer();
                        windowStart = -s.length();
                        if (timeout != null && timeout != 0) break block7;
                        while (windowStart < 0 || !sb.substring(windowStart).equals(s)) {
                            sb.append((char)is.read());
                            ++windowStart;
                        }
                        break block8;
                    }
                    endTime = Calendar.getInstance();
                    endTime.add(13, timeout);
                    ** GOTO lbl24
                    {
                        Thread.sleep(250L);
                        do {
                            if (Calendar.getInstance().before(endTime) && is.available() == 0) continue block4;
                            if (is.available() == 0) {
                                throw new BuildException("Response timed-out waiting for \"" + s + '\"', RExecTask.this.getLocation());
                            }
                            sb.append((char)is.read());
                            ++windowStart;
lbl24:
                            // 2 sources

                        } while (windowStart < 0 || !sb.substring(windowStart).equals(s));
                    }
                }
                RExecTask.this.log(sb.toString(), 2);
            }
            catch (BuildException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BuildException(e, RExecTask.this.getLocation());
            }
        }

        public void sendString(String s, boolean echoString) {
            OutputStream os = this.getOutputStream();
            try {
                os.write((String.valueOf(s) + "\n").getBytes());
                if (echoString) {
                    RExecTask.this.log(s, 2);
                }
                os.flush();
            }
            catch (Exception e) {
                throw new BuildException(e, RExecTask.this.getLocation());
            }
        }

        /*
         * Unable to fully structure code
         */
        public void waitForEOF(Integer timeout) {
            is = this.getInputStream();
            try {
                block9: {
                    block8: {
                        sb = new StringBuffer();
                        if (timeout != null && timeout != 0) break block8;
                        while ((read = is.read()) != -1) {
                            c = (char)read;
                            sb.append(c);
                            if (c != '\n') continue;
                            RExecTask.this.log(sb.toString(), 2);
                            sb.delete(0, sb.length());
                        }
                        break block9;
                    }
                    endTime = Calendar.getInstance();
                    endTime.add(13, timeout);
                    read = 0;
                    ** GOTO lbl35
                    {
                        Thread.sleep(250L);
                        do {
                            if (Calendar.getInstance().before(endTime) && is.available() == 0) continue block4;
                            if (is.available() == 0) {
                                RExecTask.this.log(sb.toString(), 2);
                                throw new BuildException("Response timed-out waiting for EOF", RExecTask.this.getLocation());
                            }
                            read = is.read();
                            if (read == -1) continue;
                            c = (char)read;
                            sb.append(c);
                            if (c != '\n') continue;
                            RExecTask.this.log(sb.toString(), 2);
                            sb.delete(0, sb.length());
lbl35:
                            // 4 sources

                        } while (read != -1);
                    }
                }
                if (sb.length() > 0) {
                    RExecTask.this.log(sb.toString(), 2);
                }
            }
            catch (BuildException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BuildException(e, RExecTask.this.getLocation());
            }
        }
    }

    public class RExecRead
    extends RExecSubTask {
        private Integer timeout;

        public RExecRead() {
            this.timeout = null;
        }

        @Override
        public void execute(AntRExecClient rexec2) throws BuildException {
            rexec2.waitForString(this.taskString, this.timeout);
        }

        public void setTimeout(Integer i) {
            this.timeout = i;
        }

        public void setDefaultTimeout(Integer defaultTimeout) {
            if (this.timeout == null) {
                this.timeout = defaultTimeout;
            }
        }
    }

    public class RExecSubTask {
        protected String taskString = "";

        public void execute(AntRExecClient rexec2) throws BuildException {
            throw new BuildException("Shouldn't be able instantiate a SubTask directly");
        }

        public void addText(String s) {
            this.setString(RExecTask.this.getProject().replaceProperties(s));
        }

        public void setString(String s) {
            this.taskString = String.valueOf(this.taskString) + s;
        }
    }

    public class RExecWrite
    extends RExecSubTask {
        private boolean echoString = true;

        @Override
        public void execute(AntRExecClient rexec2) throws BuildException {
            rexec2.sendString(this.taskString, this.echoString);
        }

        public void setEcho(boolean b) {
            this.echoString = b;
        }
    }
}

