/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.bsf.util.StringUtils;

public class MethodUtils {
    private static boolean areMethodConvertable(Class[] parms, Class[] args) {
        if (parms.length != args.length) {
            return false;
        }
        int i = 0;
        while (i < parms.length) {
            if (!MethodUtils.isMethodConvertable(parms[i], args[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String callToString(Class targetClass, String methodName, Class[] argTypes, boolean isStaticReference) {
        StringBuffer buf = new StringBuffer();
        if (isStaticReference) {
            buf.append("static ");
        }
        buf.append(StringUtils.getClassName(targetClass));
        if (methodName != null) {
            buf.append(".").append(methodName);
        }
        buf.append("(");
        if (argTypes != null && argTypes.length > 0) {
            buf.append(StringUtils.getClassName(argTypes[0]));
            int i = 1;
            while (i < argTypes.length) {
                buf.append(",").append(StringUtils.getClassName(argTypes[i]));
                ++i;
            }
        } else {
            buf.append("[none]");
        }
        buf.append(")");
        return buf.toString();
    }

    static int entryGetModifiers(Object entry) {
        return entry instanceof Method ? ((Method)entry).getModifiers() : ((Constructor)entry).getModifiers();
    }

    static String entryGetName(Object entry) {
        return entry instanceof Method ? ((Method)entry).getName() : ((Constructor)entry).getName();
    }

    static Class[] entryGetParameterTypes(Object entry) {
        return entry instanceof Method ? ((Method)entry).getParameterTypes() : ((Constructor)entry).getParameterTypes();
    }

    static String entryToString(Object entry) {
        return entry instanceof Method ? ((Method)entry).toString() : ((Constructor)entry).toString();
    }

    public static Constructor getConstructor(Class targetClass, Class[] argTypes) throws SecurityException, NoSuchMethodException {
        return (Constructor)MethodUtils.getEntryPoint(targetClass, null, argTypes, true);
    }

    /*
     * Unable to fully structure code
     */
    private static Object getEntryPoint(Class targetClass, String methodName, Class[] argTypes, boolean isStaticReference) throws SecurityException, NoSuchMethodException {
        m = null;
        try {
            if (methodName != null) {
                m = targetClass.getMethod(methodName, argTypes);
                if (isStaticReference && !Modifier.isStatic(MethodUtils.entryGetModifiers(m))) {
                    throw new NoSuchMethodException(String.valueOf(MethodUtils.callToString(targetClass, methodName, argTypes, isStaticReference)) + " resolved to instance " + m);
                }
                return m;
            }
            return targetClass.getConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            if (argTypes == null || argTypes.length == 0) {
                throw new NoSuchMethodException(String.valueOf(MethodUtils.callToString(targetClass, methodName, argTypes, isStaticReference)) + " not found.");
            }
            methods = methodName != null ? targetClass.getMethods() : targetClass.getConstructors();
            if (methods.length == 0) {
                throw new NoSuchMethodException("No methods!");
            }
            best = new MoreSpecific();
            i = 0;
            ** while (i < methods.length)
        }
lbl-1000:
        // 1 sources

        {
            mi = methods[i];
            if (Modifier.isPublic(MethodUtils.entryGetModifiers(mi)) && (methodName == null || MethodUtils.entryGetName(mi).equals(methodName)) && MethodUtils.areMethodConvertable(MethodUtils.entryGetParameterTypes(mi), argTypes)) {
                best.addItem(mi);
            }
            ++i;
            continue;
        }
lbl23:
        // 1 sources

        m = best.getMostSpecific(targetClass, methodName, argTypes, isStaticReference);
        if (m == null) {
            throw new NoSuchMethodException(String.valueOf(MethodUtils.callToString(targetClass, methodName, argTypes, isStaticReference)) + " -- no signature match");
        }
        if (methodName != null && isStaticReference && !Modifier.isStatic(MethodUtils.entryGetModifiers(m))) {
            throw new NoSuchMethodException(String.valueOf(MethodUtils.callToString(targetClass, methodName, argTypes, isStaticReference)) + " resolved to instance: " + m);
        }
        return m;
    }

    public static Method getMethod(Class target, String methodName, Class[] argTypes, boolean isStaticReference) throws SecurityException, NoSuchMethodException {
        return (Method)MethodUtils.getEntryPoint(target, methodName, argTypes, isStaticReference);
    }

    public static Method getMethod(Object target, String methodName, Class[] argTypes) throws SecurityException, NoSuchMethodException {
        boolean staticRef = target instanceof Class;
        return MethodUtils.getMethod(staticRef ? (Class<?>)target : target.getClass(), methodName, argTypes, staticRef);
    }

    private static boolean isAssignmentConvertable(Class parm, Class arg) {
        return arg.equals(Integer.TYPE) && (parm.equals(Byte.TYPE) || parm.equals(Short.TYPE) || parm.equals(Character.TYPE)) || MethodUtils.isMethodConvertable(parm, arg);
    }

    /*
     * Unable to fully structure code
     */
    private static boolean isMethodConvertable(Class parm, Class arg) {
        if (parm.equals(arg)) {
            return true;
        }
        if (arg != null) ** GOTO lbl9
        return parm.isPrimitive() == false;
lbl-1000:
        // 1 sources

        {
            if (!arg.isArray()) {
                return false;
            }
            parm = parm.getComponentType();
            arg = arg.getComponentType();
lbl9:
            // 2 sources

            ** while (parm.isArray())
        }
lbl10:
        // 1 sources

        if (arg.isArray()) {
            return false;
        }
        if (parm.isAssignableFrom(arg)) {
            return true;
        }
        if (parm.equals(Void.TYPE) || parm.equals(Boolean.TYPE) || arg.equals(Void.TYPE) || arg.equals(Boolean.TYPE)) {
            return false;
        }
        primTypes = new Class[]{Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
        parmscore = 0;
        while (parmscore < primTypes.length) {
            if (parm.equals(primTypes[parmscore])) break;
            ++parmscore;
        }
        if (parmscore >= primTypes.length) {
            return false;
        }
        argscore = 0;
        while (argscore < primTypes.length) {
            if (arg.equals(primTypes[argscore])) break;
            ++argscore;
        }
        if (argscore >= primTypes.length) {
            return false;
        }
        return argscore < parmscore && (argscore != 0 || parmscore > 2);
    }

    private static class MoreSpecific
    extends Vector {
        private MoreSpecific() {
        }

        void addItem(Object newEntry) {
            if (this.size() == 0) {
                this.addElement(newEntry);
            } else {
                Class[] newargs = MethodUtils.entryGetParameterTypes(newEntry);
                boolean keep = true;
                Enumeration e = this.elements();
                while (keep & e.hasMoreElements()) {
                    Object oldEntry = e.nextElement();
                    Class[] oldargs = MethodUtils.entryGetParameterTypes(oldEntry);
                    if (MethodUtils.areMethodConvertable(oldargs, newargs)) {
                        this.removeElement(oldEntry);
                        continue;
                    }
                    if (!MethodUtils.areMethodConvertable(newargs, oldargs)) continue;
                    keep = false;
                }
                if (keep) {
                    this.addElement(newEntry);
                }
            }
        }

        Object getMostSpecific(Class targetClass, String methodName, Class[] argTypes, boolean isStaticReference) throws NoSuchMethodException {
            if (this.size() == 1) {
                return this.firstElement();
            }
            if (this.size() > 1) {
                StringBuffer buf = new StringBuffer();
                Enumeration e = this.elements();
                buf.append(e.nextElement());
                while (e.hasMoreElements()) {
                    buf.append(" and ").append(e.nextElement());
                }
                throw new NoSuchMethodException(String.valueOf(MethodUtils.callToString(targetClass, methodName, argTypes, isStaticReference)) + " is ambiguous. It matches " + buf.toString());
            }
            return null;
        }
    }
}

