/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class ExceptionTable
extends Attribute {
    private int[] exception_index_table;

    public ExceptionTable(ExceptionTable c) {
        this(c.getNameIndex(), c.getLength(), c.getExceptionIndexTable(), c.getConstantPool());
    }

    public ExceptionTable(int name_index, int length, int[] exception_index_table, ConstantPool constant_pool) {
        super((byte)3, name_index, length, constant_pool);
        this.exception_index_table = exception_index_table != null ? exception_index_table : new int[]{};
    }

    ExceptionTable(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (int[])null, constant_pool);
        int number_of_exceptions = input.readUnsignedShort();
        this.exception_index_table = new int[number_of_exceptions];
        int i = 0;
        while (i < number_of_exceptions) {
            this.exception_index_table[i] = input.readUnsignedShort();
            ++i;
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitExceptionTable(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.exception_index_table.length);
        int[] nArray = this.exception_index_table;
        int n = this.exception_index_table.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            file.writeShort(index);
            ++n2;
        }
    }

    public int[] getExceptionIndexTable() {
        return this.exception_index_table;
    }

    public int getNumberOfExceptions() {
        return this.exception_index_table == null ? 0 : this.exception_index_table.length;
    }

    public String[] getExceptionNames() {
        String[] names = new String[this.exception_index_table.length];
        int i = 0;
        while (i < this.exception_index_table.length) {
            names[i] = super.getConstantPool().getConstantString(this.exception_index_table[i], (byte)7).replace('/', '.');
            ++i;
        }
        return names;
    }

    public void setExceptionIndexTable(int[] exception_index_table) {
        this.exception_index_table = exception_index_table != null ? exception_index_table : new int[]{};
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Exceptions: ");
        int i = 0;
        while (i < this.exception_index_table.length) {
            String str = super.getConstantPool().getConstantString(this.exception_index_table[i], (byte)7);
            buf.append(Utility.compactClassName(str, false));
            if (i < this.exception_index_table.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        return buf.toString();
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        ExceptionTable c = (ExceptionTable)this.clone();
        if (this.exception_index_table != null) {
            c.exception_index_table = new int[this.exception_index_table.length];
            System.arraycopy(this.exception_index_table, 0, c.exception_index_table, 0, this.exception_index_table.length);
        }
        c.setConstantPool(_constant_pool);
        return c;
    }
}

