/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.task;

import java.util.concurrent.Callable;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.task.TskTaskContext;

public abstract class TskAbstractCallable<T>
extends BcLoggableObject
implements Callable {
    protected TskTaskContext taskContext = new TskTaskContext();
    private Throwable throwable;
    private String name;

    public TskAbstractCallable() {
        this.setName(this.getClass().getName());
    }

    public TskTaskContext getTaskContext() {
        return this.taskContext;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public final T call() throws Exception {
        this.throwable = null;
        this.taskContext.startTime = System.currentTimeMillis();
        this.taskStarted();
        T respons = null;
        try {
            respons = this.taskProcess();
            this.taskContext.endTime = System.currentTimeMillis();
            this.taskFinished();
        }
        catch (Exception ex) {
            this.handleException(ex);
            throw ex;
        }
        return respons;
    }

    protected abstract T taskProcess() throws Exception;

    protected void taskStarted() {
    }

    protected void taskFinished() {
    }

    protected void handleException(Throwable throwable) {
        this.throwable = throwable;
        this.getLogger().error(BcLogUtil.getStackTrace(throwable));
    }

    public Throwable getThrowable() {
        return this.throwable;
    }
}

