/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsod.fx;

import java.util.List;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.etc.util.EtcEventHandlerManager;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.module.xsod.common.XsodUtil;
import jp.co.extreme.module.xsod.fx.XsodController;
import jp.co.extreme.module.xsod.fx.XsodEventHandler;
import jp.co.extreme.module.xsod.fx.XsodUiFactory;
import jp.co.extreme.module.xsod.model.XsodCategory;
import jp.co.extreme.module.xsod.model.XsodMenuData;

public class XsodCategory1Pane
extends FxBorderPane
implements XsodEventHandler {
    HBox menuBox = XsodUiFactory.getInstance().createHBox();

    public XsodCategory1Pane() throws Exception {
        this.initComponent();
        EtcEventHandlerManager.getInstance().addEventHandler(XsodEventHandler.class, this);
    }

    protected void initComponent() throws Exception {
        this.menuBox.setPadding(new Insets(10.0, 20.0, 10.0, 20.0));
        this.menuBox.setSpacing(20.0);
        StackPane baseStackPane = XsodUiFactory.getInstance().createBackgrondNode((Node)this.menuBox, Color.SILVER);
        this.setCenter((Node)baseStackPane);
    }

    protected void setCategoryList(List<XsodCategory> categoryList) throws Exception {
        this.menuBox.getChildren().clear();
        XsodMenuData menuData = XsodController.getInstance().getMenuData();
        int i = 0;
        while (i < categoryList.size()) {
            XsodCategory category = categoryList.get(i);
            String categoryName = XsodUtil.getName(category, XsodController.getInstance().langCode, true);
            Button button = XsodUiFactory.getInstance().createButton2(categoryName);
            button.setOnAction(this.actionEventHandler);
            button.setUserData((Object)category.code);
            this.menuBox.getChildren().add((Object)button);
            ++i;
        }
        if (categoryList.size() > 0) {
            XsodCategory category = categoryList.get(0);
            XsodController.getInstance().category1Selected(category.code);
        }
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        BcLogUtil.debug("actionPerformed:ev.getSource()=" + ev.getSource());
        if (ev.getSource() instanceof Button) {
            Button button = (Button)ev.getSource();
            String categoryName = (String)button.getUserData();
            XsodController.getInstance().category1Selected(categoryName);
        }
    }

    @Override
    public void langChanged(String langCode) throws Exception {
        BcLogUtil.debug("\u8a00\u8a9e\u304c\u5909\u66f4\u3055\u308c\u305f langCode=" + langCode);
    }
}

