/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsod.dao;

import java.util.List;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.xsod.model.XsodOrder;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class XsodOrderDAO
extends OrmAbstractDAO<XsodOrder> {
    public static final int MODE_default = 1;

    private XsodOrderDAO() {
        super(new XsodOrder[0]);
        this.setTableName("xsod_order");
    }

    public static XsodOrderDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, int mode, String alias, int sessionId, short[] statuses) throws Exception {
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (sessionId > 0) {
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "session_id = " + sessionId);
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcNumberUtil.isEmpty(statuses)) {
            String condition = sqlContext.numberToCommaEnumeration(statuses).toString();
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "status IN (" + condition + ")");
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        if (mode == 1) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "order_date_time");
        }
        return selectQuery;
    }

    public List<XsodOrder> getList(DtsSession dtsSession, int sessionId, short ... statuses) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "od";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, 1, alias, sessionId, statuses);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    /* synthetic */ XsodOrderDAO(XsodOrderDAO xsodOrderDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final XsodOrderDAO instance = new XsodOrderDAO(null);

        private SingletonHolder() {
        }
    }
}

