/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.viewer;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcExceptionUtil;
import jp.co.extreme.fx.control.FxTabPane;
import jp.co.extreme.fx.extension.FxxAbstractDesktopPane;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.fx.viewer.FxxContent;
import jp.co.extreme.fx.viewer.FxxContentGroup;
import jp.co.extreme.fx.viewer.FxxContentNode;
import jp.co.extreme.fx.viewer.FxxMultiTouchViewPane;
import jp.co.extreme.fx.viewer.FxxNavigatePane;
import jp.co.extreme.fx.viewer.FxxUrlEvent;

public class FxxViwerDesktopPane
extends FxxAbstractDesktopPane {
    protected SplitPane splitPane1 = new SplitPane();
    protected FxTabPane tabPane1 = new FxTabPane();
    protected FxxNavigatePane navigatePane = new FxxNavigatePane();
    protected SplitPane splitPane2 = new SplitPane();
    protected FxBorderPane borderPane1 = new FxBorderPane();
    protected FxxMultiTouchViewPane multiTouchViewPane = new FxxMultiTouchViewPane();
    protected EventHandler<? super FxxUrlEvent> eventHandler;
    protected Stage stage;

    public FxxViwerDesktopPane() throws Exception {
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.splitPane1.setOrientation(Orientation.HORIZONTAL);
        this.splitPane1.getItems().addAll((Object[])new Node[]{this.tabPane1, this.splitPane2});
        this.setCenter((Node)this.splitPane1);
        this.splitPane2.setOrientation(Orientation.VERTICAL);
        this.splitPane2.getItems().addAll((Object[])new Node[]{this.borderPane1});
        this.borderPane1.setCenter((Node)this.multiTouchViewPane);
        Tab tab = new Tab();
        tab.setClosable(false);
        tab.setGraphic((Node)FxImageHelper.createImageView_icon("table_64x64.png"));
        tab.setContent((Node)this.navigatePane);
        this.tabPane1.getTabs().add((Object)tab);
        this.tabPane1.getSelectionModel().select((Object)tab);
        this.navigatePane.setEventHandler((EventHandler<? super FxxUrlEvent>)((EventHandler)ev -> {
            try {
                FxxContent fxxContent = (FxxContent)ev.value;
                this.multiTouchViewPane.clear();
                double scale = 1.0;
                FxxContentNode contentNode = fxxContent.getNode(scale);
                this.multiTouchViewPane.addContentNode(contentNode);
            }
            catch (Exception ex) {
                BcExceptionUtil.getExceptionHandler().handleException(ex, (Object)this);
            }
        }));
        FxUtil.defaultInitialize((Node)this);
    }

    public void setContentGroup(FxxContentGroup contentGroup) throws Exception {
        this.navigatePane.setContents(contentGroup);
    }

    public void clear() throws Exception {
        this.multiTouchViewPane.clear();
    }

    public void setEventHandler(EventHandler<? super FxxUrlEvent> eventHandler) throws Exception {
        this.eventHandler = eventHandler;
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
    }

    @Override
    public void exitAction() throws Exception {
        this.stage.close();
    }

    public boolean show(Window ownerWindow) throws Exception {
        this.stage = new FxStage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.init();
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                try {
                    double ratio = 200.0 / FxxViwerDesktopPane.this.stage.getWidth();
                    FxxViwerDesktopPane.this.splitPane1.setDividerPositions(new double[]{ratio});
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        FxUtil.setWindowCenter((Window)this.stage, 0.8f);
        FxImageHelper.setStageIcon(this.stage);
        this.stage.show();
        return false;
    }
}

